/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.schedule;

import com.kingdee.bos.bi.model.common.mm.ComboBoxObject;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class ScheduleLog {
    private String FID;
    private String FScheduleID;
    private Date FStartTime;
    private Date FEndTime;
    private String allTime;
    private String FCallType;
    private String FExecutor;
    private String LogType;
    private List logDetailList;

    public String getAllTime() {
        return this.allTime;
    }

    public void setAllTime(String allTime) {
        this.allTime = allTime;
    }

    public List getLogDetailList() {
        return this.logDetailList;
    }

    public void setLogDetailList(List logDetailList) {
        this.logDetailList = logDetailList;
    }

    public String getFID() {
        return this.FID;
    }

    public void setFID(String fid) {
        this.FID = fid;
    }

    public String getFScheduleID() {
        return this.FScheduleID;
    }

    public void setFScheduleID(String scheduleID) {
        this.FScheduleID = scheduleID;
    }

    public Date getFStartTime() {
        return this.FStartTime;
    }

    public void setFStartTime(Date startTime) {
        this.FStartTime = startTime;
    }

    public Date getFEndTime() {
        return this.FEndTime;
    }

    public void setFEndTime(Date endTime) {
        this.FEndTime = endTime;
    }

    public String getFCallType() {
        return this.FCallType;
    }

    public void setFCallType(String callType) {
        this.FCallType = callType;
    }

    public String getFExecutor() {
        return this.FExecutor;
    }

    public void setFExecutor(String executor) {
        this.FExecutor = executor;
    }

    public String getLogType() {
        return this.LogType;
    }

    public void setLogType(String logType) {
        this.LogType = logType;
    }

    public static Vector loadSerialNumberIteams(IManagementFacade facade, String scheduleId) throws BIModelRemoteException {
        if (facade == null || scheduleId == null || scheduleId.length() == 0) {
            return null;
        }
        Vector<ComboBoxObject> serialNumberIteams = new Vector<ComboBoxObject>();
        ComboBoxObject obj = null;
        String sql = "select L.FScheduleID,L.FID,L.FStartTime,L.FEndTime,L.FEndTime-L.FStartTime AS allTime,L.FCallType,U.FName_l2 from T_BI_LOG_DataRule L , T_PM_USER U where L.FScheduleID='" + scheduleId + "' and L.FExecutor= U.FID order by L.FStartTime desc";
        try {
            RDRowSet rs = facade.executeQuery(sql);
            while (rs.next()) {
                obj = new ComboBoxObject();
                obj.setCode(rs.getString("FID"));
                obj.setName(rs.getObject("FStartTime").toString());
                serialNumberIteams.add(obj);
            }
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        return serialNumberIteams;
    }

    public static Vector loadLogTypeIteams() {
        Vector<ComboBoxObject> logTypeIteams = new Vector<ComboBoxObject>();
        ComboBoxObject obj = null;
        obj = new ComboBoxObject("all", "\u6240\u6709");
        logTypeIteams.add(obj);
        obj = new ComboBoxObject("error", "\u51fa\u9519");
        logTypeIteams.add(obj);
        return logTypeIteams;
    }

    public static ScheduleLog load(IManagementFacade facade, String logId, String logType) throws BIModelRemoteException {
        if (facade == null || logId == null || logId.length() == 0) {
            return null;
        }
        ScheduleLog logModel = new ScheduleLog();
        ArrayList<LogDetail> logDetailList = new ArrayList<LogDetail>();
        LogDetail logDetail = null;
        String sqlBaseInfo = "select L.FID,L.FScheduleID,L.FStartTime,L.FEndTime,L.FEndTime-L.FStartTime AS allTime,L.FCallType,U.FName_l2 from T_BI_LOG_DataRule L , T_PM_USER U where L.FID='" + logId + "' and L.FExecutor= U.FID order by L.FStartTime desc";
        String sqlLogDetail = "select LD.FLogID,LD.FOrder,A.FName,S.FSchemaName,D.FType,LD.FItemOrder,LD.FLogType,LD.FLogMemo from  T_BI_LOG_DRDetails  LD ,T_BI_AppModel A,T_BI_AM_DR_Schema S,T_BI_AM_DR_Detail D where LD.FLogID='" + logId + ("all".equals(logType) ? "" : "' and LD.FLogType='" + logType) + "' and LD.FAMID=A.FID and  LD.FSchemaID=S.FSchemaID and ( LD.FSchemaID=D.FSchemaID and LD.FItemOrder=D.FOrder ) order by LD.FOrder";
        try {
            RDRowSet rs = facade.executeQuery(sqlBaseInfo);
            if (rs.next()) {
                logModel.setFID(rs.getString("FID"));
                Date startTime = (Date)rs.getObject("FStartTime");
                Date endTime = (Date)rs.getObject("FEndTime");
                long allTimeL = endTime.getTime() - startTime.getTime();
                float allTimeF = (float)allTimeL / 1000.0f;
                logModel.setFStartTime(startTime);
                logModel.setFEndTime(endTime);
                logModel.setAllTime(allTimeF + "");
                logModel.setFCallType(rs.getString("FCallType"));
                logModel.setFExecutor(rs.getString("FName_l2"));
            }
            rs = facade.executeQuery(sqlLogDetail);
            while (rs.next()) {
                logDetail = logModel.new LogDetail();
                logDetail.setFAMName(rs.getString("FName"));
                logDetail.setFSchemaName(rs.getString("FSchemaName"));
                logDetail.setFSchemaType(rs.getString("FType"));
                logDetail.setFItemOrder(rs.getInt("FItemOrder"));
                logDetail.setFLogType(rs.getString("FLogType"));
                logDetail.setFLogMemo(rs.getString("FLogMemo"));
                logDetailList.add(logDetail);
            }
            logModel.setLogDetailList(logDetailList);
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        return logModel;
    }

    public static void DelOne(IManagementFacade facade, String currLogId) {
        String delDRDetail = "delete from T_BI_LOG_DRDetails where FLogID='" + currLogId + "'";
        String delDataRuel = "delete from T_BI_LOG_DataRule where FID='" + currLogId + "'";
        try {
            facade.executeUpdate(delDRDetail);
            facade.executeUpdate(delDataRuel);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void DelAll(IManagementFacade facade, String scheduleId) {
        String delDRDetail = "delete from T_BI_LOG_DRDetails where FLogID in (select FID from  T_BI_LOG_DataRule where FScheduleID ='" + scheduleId + "')";
        String delDataRuel = "delete from T_BI_LOG_DataRule where FScheduleID='" + scheduleId + "'";
        try {
            facade.executeUpdate(delDRDetail);
            facade.executeUpdate(delDataRuel);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        try {
            Date date1 = new SimpleDateFormat("yyyy-mm-dd").parse("2006-06-08");
            Date date2 = new SimpleDateFormat("yyyy-mm-dd").parse("2006-06-12");
            long l = date1.getTime() - date2.getTime() > 0L ? date1.getTime() - date2.getTime() : date2.getTime() - date1.getTime();
            System.out.println(l / 1000L + "\u79d2");
            long day = (date1.getTime() - date2.getTime()) / 86400000L > 0L ? (date1.getTime() - date2.getTime()) / 86400000L : (date2.getTime() - date1.getTime()) / 86400000L;
            System.out.println("\u76f8\u5dee\u7684\u65e5\u671f: " + day);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public class LogDetail {
        private String FLogID;
        private int FOrder;
        private String FAMName;
        private String FSchemaName;
        private String FSchemaType;
        private int FItemOrder;
        private String FLogType;
        private String FLogMemo;

        public String getFLogID() {
            return this.FLogID;
        }

        public void setFLogID(String logID) {
            this.FLogID = logID;
        }

        public int getFOrder() {
            return this.FOrder;
        }

        public void setFOrder(int order) {
            this.FOrder = order;
        }

        public String getFAMName() {
            return this.FAMName;
        }

        public void setFAMName(String famName) {
            this.FAMName = famName;
        }

        public String getFSchemaName() {
            return this.FSchemaName;
        }

        public void setFSchemaName(String schemaName) {
            this.FSchemaName = schemaName;
        }

        public String getFSchemaType() {
            return this.FSchemaType;
        }

        public void setFSchemaType(String schemaType) {
            this.FSchemaType = schemaType;
        }

        public int getFItemOrder() {
            return this.FItemOrder;
        }

        public void setFItemOrder(int itemOrder) {
            this.FItemOrder = itemOrder;
        }

        public String getFLogType() {
            return this.FLogType;
        }

        public void setFLogType(String logType) {
            this.FLogType = logType;
        }

        public String getFLogMemo() {
            return this.FLogMemo;
        }

        public void setFLogMemo(String logMemo) {
            this.FLogMemo = logMemo;
        }
    }
}

