/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.time;

import com.kingdee.bos.bi.model.common.mm.time.TimeDimensionNode;
import com.kingdee.bos.bi.model.common.mm.time.TimeModel;
import com.kingdee.bos.bi.model.common.mm.time.TimeTreeModel;
import com.kingdee.bos.bi.model.common.mm.time.TimeUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class TimeBuilder {
    private Level[] levels = null;
    private Calendar startTime = null;
    private Calendar endTime = null;
    public static final int LEVEL_YEAR = 1;
    public static final int LEVEL_HALFYEAR = 2;
    public static final int LEVEL_QUARTER = 3;
    public static final int LEVEL_MONTH = 4;
    public static final int LEVEL_DATE = 5;
    public static final String LEVEL_NAME_YEAR = "year";
    public static final String LEVEL_NAME_HALFYEAR = "halfyear";
    public static final String LEVEL_NAME_QUARTER = "quarter";
    public static final String LEVEL_NAME_MONTH = "month";
    public static final String LEVEL_NAME_DATE = "date";

    public static TimeBuilder createInstance(TimeModel timeModel) {
        TimeBuilder timeBuilder = new TimeBuilder(timeModel);
        timeBuilder.levels = timeBuilder.getLevels(timeModel);
        timeBuilder.startTime = TimeUtil.createCalendar(timeModel.getDateBegin());
        timeBuilder.endTime = TimeUtil.createCalendar(timeModel.getDateEnd());
        return timeBuilder;
    }

    private TimeBuilder(TimeModel model) {
    }

    public List builder(TimeModel model) {
        return null;
    }

    public Level[] getLevels(TimeModel model) {
        if (this.levels == null) {
            ArrayList<Level> list = new ArrayList<Level>();
            if (model.getUseDay()) {
                list.add(0, new Level(null, 5, LEVEL_NAME_DATE));
            }
            if (model.getUseMonth()) {
                if (list.size() > 0) {
                    list.add(0, new Level((Level)list.get(0), 4, LEVEL_NAME_MONTH));
                } else {
                    list.add(0, new Level(null, 4, LEVEL_NAME_MONTH));
                }
            }
            if (model.getUseQuarter()) {
                if (list.size() > 0) {
                    list.add(0, new Level((Level)list.get(0), 3, LEVEL_NAME_QUARTER));
                } else {
                    list.add(0, new Level(null, 3, LEVEL_NAME_QUARTER));
                }
            }
            if (model.getUseHalfYear()) {
                if (list.size() > 0) {
                    list.add(0, new Level((Level)list.get(0), 2, LEVEL_NAME_HALFYEAR));
                } else {
                    list.add(0, new Level(null, 2, LEVEL_NAME_HALFYEAR));
                }
            }
            if (model.getUseYear()) {
                if (list.size() > 0) {
                    list.add(0, new Level((Level)list.get(0), 1, LEVEL_NAME_YEAR));
                } else {
                    list.add(0, new Level(null, 1, LEVEL_NAME_YEAR));
                }
            }
            this.levels = list.toArray(new Level[list.size()]);
        }
        return this.levels;
    }

    public void doBuilder(TimeDimensionNode parent, Calendar startTime, Calendar endTime, Level level, int year, boolean isStart, boolean isEnd) {
        Calendar calendar = TimeUtil.createCalendar(new Date());
        switch (level.getLevel()) {
            case 1: {
                int startYear = TimeUtil.getYear(startTime);
                int endYear = TimeUtil.getYear(endTime);
                for (int i = startYear; i <= endYear; ++i) {
                    TimeUtil.resetCalendarAll(calendar, i, 1, 1);
                    TimeDimensionNode yearNode = new TimeDimensionNode();
                    TimeTreeModel yearModel = new TimeTreeModel();
                    yearModel.setDimensionType(parent.getTimeModel().getDimensionType());
                    yearNode.setTimeModel(yearModel);
                    yearModel.setName(i + "\u5e74");
                    yearModel.setNumber(TimeUtil.getStringTime(calendar));
                    yearModel.setLevelName(LEVEL_NAME_YEAR);
                    parent.addChild(yearNode);
                    Level nextLevel = level.getNextLevel();
                    if (nextLevel == null) continue;
                    if (nextLevel.getLevel() != 5) {
                        this.doBuilder(yearNode, startTime, endTime, nextLevel, i, i == startYear, i == endYear);
                        continue;
                    }
                    Calendar temp = null;
                    Calendar end = null;
                    Calendar firstDayOfYear = TimeUtil.createCalendar(new Date());
                    TimeUtil.resetCalendarAll(firstDayOfYear, i, 1, 1);
                    Calendar endDayOfYear = TimeUtil.createCalendar(new Date());
                    TimeUtil.resetCalendarAll(endDayOfYear, i, 12, 31);
                    temp = startTime.after(firstDayOfYear) ? TimeUtil.createCalendar(startTime) : firstDayOfYear;
                    end = endTime.after(endDayOfYear) ? endDayOfYear : TimeUtil.createCalendar(endTime);
                    int endDay = TimeUtil.getIntTime(end);
                    while (TimeUtil.getIntTime(temp) <= endDay) {
                        TimeDimensionNode dateNode = new TimeDimensionNode();
                        TimeTreeModel dateModel = new TimeTreeModel();
                        dateNode.setTimeModel(dateModel);
                        dateModel.setName(TimeUtil.getMonth(temp) + "\u6708" + TimeUtil.getDay(temp) + "\u65e5");
                        dateModel.setNumber(TimeUtil.getStringTime(temp));
                        dateModel.setLevelName(LEVEL_NAME_DATE);
                        yearNode.addChild(dateNode);
                        temp.add(5, 1);
                    }
                }
                break;
            }
            case 2: {
                int startHalfYear = TimeUtil.getHalfYear(startTime);
                int endHalfYear = TimeUtil.getHalfYear(endTime);
                int n = 2;
                for (int i = 1; i <= n; ++i) {
                    if (isStart && i < startHalfYear || isEnd && i > endHalfYear) continue;
                    int h = (i - 1) * 6 + 1;
                    TimeUtil.resetCalendarAll(calendar, year, h, 1);
                    TimeDimensionNode halfYearNode = new TimeDimensionNode();
                    TimeTreeModel halfYearModel = new TimeTreeModel();
                    halfYearNode.setTimeModel(halfYearModel);
                    halfYearModel.setName(i == 1 ? "\u4e0a\u534a\u5e74" : "\u4e0b\u534a\u5e74");
                    halfYearModel.setNumber(TimeUtil.getStringTime(calendar));
                    halfYearModel.setLevelName(LEVEL_NAME_HALFYEAR);
                    parent.addChild(halfYearNode);
                    Level nextLevel = level.getNextLevel();
                    if (nextLevel == null) continue;
                    if (nextLevel.getLevel() != 5) {
                        this.doBuilder(halfYearNode, startTime, endTime, nextLevel, year, isStart && i == startHalfYear, isEnd && i == endHalfYear);
                        continue;
                    }
                    Calendar temp = null;
                    Calendar end = null;
                    Calendar firstDayOfYear = TimeUtil.createCalendar(new Date());
                    TimeUtil.resetCalendarAll(firstDayOfYear, year, h, 1);
                    Calendar endDayOfYear = TimeUtil.createCalendar(new Date());
                    TimeUtil.resetCalendarAll(endDayOfYear, year, h + 5, 1);
                    TimeUtil.resetCalendarAll(endDayOfYear, year, h + 5, endDayOfYear.getMaximum(5));
                    temp = startTime.after(firstDayOfYear) ? TimeUtil.createCalendar(startTime) : firstDayOfYear;
                    end = endTime.after(endDayOfYear) ? endDayOfYear : TimeUtil.createCalendar(endTime);
                    int endDay = TimeUtil.getIntTime(end);
                    while (TimeUtil.getIntTime(temp) <= endDay) {
                        TimeDimensionNode dateNode = new TimeDimensionNode();
                        TimeTreeModel dateModel = new TimeTreeModel();
                        dateNode.setTimeModel(dateModel);
                        dateModel.setName(TimeUtil.getMonth(temp) + "\u6708" + TimeUtil.getDay(temp) + "\u65e5");
                        dateModel.setNumber(TimeUtil.getStringTime(temp));
                        dateModel.setLevelName(LEVEL_NAME_DATE);
                        halfYearNode.addChild(dateNode);
                        temp.add(5, 1);
                    }
                }
                break;
            }
            case 3: {
                int startQuarter = TimeUtil.getQuarter(startTime);
                int endQuarter = TimeUtil.getQuarter(endTime);
                int m = 4;
                for (int j = 1; j <= m; ++j) {
                    if (isStart && j < startQuarter || isEnd && j > endQuarter) continue;
                    int h = (j - 1) * 3 + 1;
                    TimeUtil.resetCalendarAll(calendar, year, h, 1);
                    TimeDimensionNode quarterNode = new TimeDimensionNode();
                    TimeTreeModel quarterModel = new TimeTreeModel();
                    quarterNode.setTimeModel(quarterModel);
                    quarterModel.setName("\u7b2c" + j + "\u5b63\u5ea6");
                    quarterModel.setNumber(TimeUtil.getStringTime(calendar));
                    quarterModel.setLevelName(LEVEL_NAME_HALFYEAR);
                    parent.addChild(quarterNode);
                    Level nextLevel = level.getNextLevel();
                    if (nextLevel == null) continue;
                    if (nextLevel.getLevel() != 5) {
                        this.doBuilder(quarterNode, startTime, endTime, level.getNextLevel(), year, isStart && j == startQuarter, isEnd && j == endQuarter);
                        continue;
                    }
                    Calendar temp = null;
                    Calendar end = null;
                    Calendar firstDayOfYear = TimeUtil.createCalendar(new Date());
                    TimeUtil.resetCalendarAll(firstDayOfYear, year, h, 1);
                    Calendar endDayOfYear = TimeUtil.createCalendar(new Date());
                    TimeUtil.resetCalendarAll(endDayOfYear, year, h + 2, 1);
                    TimeUtil.resetCalendarAll(endDayOfYear, year, h + 2, endDayOfYear.getMaximum(5));
                    temp = startTime.after(firstDayOfYear) ? TimeUtil.createCalendar(startTime) : firstDayOfYear;
                    end = endTime.after(endDayOfYear) ? endDayOfYear : TimeUtil.createCalendar(endTime);
                    int endDay = TimeUtil.getIntTime(end);
                    while (TimeUtil.getIntTime(temp) <= endDay) {
                        TimeDimensionNode dateNode = new TimeDimensionNode();
                        TimeTreeModel dateModel = new TimeTreeModel();
                        dateNode.setTimeModel(dateModel);
                        dateModel.setName(TimeUtil.getMonth(temp) + "\u6708" + TimeUtil.getDay(temp) + "\u65e5");
                        dateModel.setNumber(TimeUtil.getStringTime(temp));
                        dateModel.setLevelName(LEVEL_NAME_DATE);
                        quarterNode.addChild(dateNode);
                        temp.add(5, 1);
                    }
                }
                break;
            }
            case 4: {
                int startMonth = TimeUtil.getMonth(startTime);
                int endMonth = TimeUtil.getMonth(endTime);
                int n = 12;
                for (int i = 1; i <= n; ++i) {
                    if (isStart && i < startMonth || isEnd && i > endMonth) continue;
                    TimeUtil.resetCalendarAll(calendar, year, i, 1);
                    TimeDimensionNode monthNode = new TimeDimensionNode();
                    TimeTreeModel monthModel = new TimeTreeModel();
                    monthNode.setTimeModel(monthModel);
                    monthModel.setName(i + "\u6708");
                    monthModel.setNumber(TimeUtil.getStringTime(calendar));
                    monthModel.setLevelName(LEVEL_NAME_MONTH);
                    parent.addChild(monthNode);
                    Level nextLevel = level.getNextLevel();
                    if (nextLevel == null) continue;
                    if (nextLevel.getLevel() != 5) {
                        this.doBuilder(monthNode, startTime, endTime, level.getNextLevel(), year, isStart && i == startMonth, isEnd && i == endMonth);
                        continue;
                    }
                    Calendar temp = null;
                    Calendar end = null;
                    Calendar firstDayOfYear = TimeUtil.createCalendar(new Date());
                    TimeUtil.resetCalendarAll(firstDayOfYear, year, i, 1);
                    Calendar endDayOfYear = TimeUtil.createCalendar(new Date());
                    TimeUtil.resetCalendarAll(endDayOfYear, year, i, 1);
                    TimeUtil.resetCalendarAll(endDayOfYear, year, i, endDayOfYear.getMaximum(5));
                    temp = startTime.after(firstDayOfYear) ? TimeUtil.createCalendar(startTime) : firstDayOfYear;
                    end = endTime.after(endDayOfYear) ? endDayOfYear : TimeUtil.createCalendar(endTime);
                    int endDay = TimeUtil.getIntTime(end);
                    while (TimeUtil.getIntTime(temp) <= endDay) {
                        TimeDimensionNode dateNode = new TimeDimensionNode();
                        TimeTreeModel dateModel = new TimeTreeModel();
                        dateNode.setTimeModel(dateModel);
                        dateModel.setName(TimeUtil.getDay(temp) + "\u65e5");
                        dateModel.setNumber(TimeUtil.getStringTime(temp));
                        dateModel.setLevelName(LEVEL_NAME_DATE);
                        monthNode.addChild(dateNode);
                        temp.add(5, 1);
                    }
                }
                break;
            }
        }
    }

    public static void main(String[] args) {
        TimeModel t = new TimeModel();
        Calendar dateBegin = TimeUtil.createCalendar(new Date());
        TimeUtil.resetCalendarAll(dateBegin, 2000, 12, 2);
        Calendar dateEnd = TimeUtil.createCalendar(new Date());
        TimeUtil.resetCalendarAll(dateEnd, 2001, 7, 1);
        t.setDateBegin(dateBegin.getTime());
        t.setDateEnd(dateEnd.getTime());
        t.setUseYear(true);
        t.setUseHalfYear(true);
        t.setUseQuarter(true);
        t.setUseMonth(true);
        t.setUseDay(true);
        TimeBuilder b = TimeBuilder.createInstance(t);
        TimeDimensionNode root = new TimeDimensionNode();
        TimeTreeModel m = new TimeTreeModel();
        m.setDimensionType("time");
        root.setTimeModel(m);
        Level[] level = b.getLevels(t);
        b.doBuilder(root, dateBegin, dateEnd, level[0], 2000, false, false);
        System.out.println(root);
    }

    class Level
    implements Comparable {
        int level;
        String levelName;
        Level nextLevel = null;

        Level(Level nextLevel, int level, String levelName) {
            this.nextLevel = nextLevel;
            this.level = level;
            this.levelName = levelName;
        }

        int getLevel() {
            return this.level;
        }

        Level getNextLevel() {
            return this.nextLevel;
        }

        public int compareTo(Object obj) {
            if (this == obj) {
                return 0;
            }
            if (obj instanceof Level) {
                Level another = (Level)obj;
                return this.level - another.level;
            }
            return -1;
        }
    }
}

