/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.commonui.contentList.panel;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeLabelUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.plaf.LabelUI;
import org.apache.log4j.Logger;

public abstract class AbstractContentList
extends TypicalDialog {
    protected static final Logger log = CommonLogger.getLogger(AbstractContentList.class);
    private static final long serialVersionUID = -7786193847906768360L;
    private KDPanel panMain;
    private KDLabel labList;
    private KDWorkButton btnAdd;
    private KDWorkButton btnEdit;
    private KDWorkButton btnDel;
    private KDList lstMain;
    private KDScrollPane scrPane;
    protected List modelList = new ArrayList();
    private boolean readOnly = false;

    public AbstractContentList() {
    }

    public AbstractContentList(Frame owner) {
        super(owner);
    }

    public AbstractContentList(Dialog owner) {
        super(owner);
    }

    protected void todoInit() {
        this.setSize(350, 450);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        parent.add(this.getPanMain(), thisCell);
        this.initModelList();
    }

    public void setWindowTitle(String title) {
        super.setTitle(title);
    }

    public void setListTitle(String title) {
        this.getLabList().setText(title);
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
    }

    public void setBtnOkText(String name) {
        this.btnOk.setText(name);
    }

    private void initModelList() {
        this.loadModelList();
        this.lstMain.removeAllElements();
        Iterator it = this.getModelList().iterator();
        while (it.hasNext()) {
            this.lstMain.addElement(it.next());
        }
    }

    public List getModelList() {
        return Collections.unmodifiableList(this.modelList);
    }

    public void removeModelFromList(Object o) {
        int sel = this.lstMain.getSelectedIndex();
        int con = this.lstMain.getElementCount() - 1;
        this.modelList.remove(o);
        this.lstMain.removeElement(o);
        this.lstMain.setSelectedIndex(sel == con ? sel - 1 : sel);
    }

    public void setModelList(List modelList) {
        this.modelList.clear();
        this.modelList.addAll(modelList);
    }

    protected void loadModelList() {
    }

    private Component getPanMain() {
        if (this.panMain == null) {
            this.panMain = new KDPanel();
            this.setPanMainLayout();
            this.addPanMainComponent();
        }
        return this.panMain;
    }

    private void setPanMainLayout() {
        TableLayout2 tly = new TableLayout2(2, 4);
        tly.setRowsSpacing(TableLayout2.ALL, 5);
        tly.setFixedHeight(0, 21);
        tly.setRatableHeight(1, 100);
        tly.setColsSpacing(TableLayout2.ALL, 5);
        tly.setFixedWidth(new int[]{1, 2, 3}, 21);
        tly.setRatableWidth(0, 100);
        this.panMain.setLayout((LayoutManager)tly);
    }

    private void addPanMainComponent() {
        this.panMain.add((Component)this.getLabList(), (Object)TableLayout2.param((int)0, (int)0));
        this.panMain.add(this.getBtnAdd(), (Object)TableLayout2.param((int)0, (int)1));
        this.panMain.add(this.getBtnEdit(), (Object)TableLayout2.param((int)0, (int)2));
        this.panMain.add(this.getBtnDel(), (Object)TableLayout2.param((int)0, (int)3));
        this.panMain.add(this.getScrPane(), (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)3));
    }

    public KDLabel getLabList() {
        if (this.labList == null) {
            this.labList = new KDLabel();
            this.labList.setUI((LabelUI)new KingdeeLabelUI(){

                protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
                    super.paintEnabledText(l, g, s, textX, textY += 4);
                }
            });
        }
        return this.labList;
    }

    public Component getBtnAdd() {
        if (this.btnAdd == null) {
            this.btnAdd = new KDWorkButton();
            this.setButttonStatus(this.btnAdd, Resource.ICON_NEW_FILE, "\u65b0\u589e");
            this.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractContentList.this.action_Add();
                }
            });
        }
        return this.btnAdd;
    }

    protected abstract void action_Add();

    public Component getBtnEdit() {
        if (this.btnEdit == null) {
            this.btnEdit = new KDWorkButton();
            this.setButttonStatus(this.btnEdit, Resource.ICON_EDIT, "\u7f16\u8f91");
            this.btnEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AbstractContentList.this.checkListSelected()) {
                        AbstractContentList.this.action_Edit();
                    }
                }
            });
        }
        return this.btnEdit;
    }

    protected abstract void action_Edit();

    public Component getBtnDel() {
        if (this.btnDel == null) {
            this.btnDel = new KDWorkButton();
            this.setButttonStatus(this.btnDel, Resource.ICON_DELETE, "\u5220\u9664");
            this.btnDel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AbstractContentList.this.checkListSelected() && WindowUtil.msgboxYesNo((Component)AbstractContentList.this.getOwner(), (Object)("\u662f\u5426\u5220\u9664\u3010" + AbstractContentList.this.getSelectedModel() + "\u3011\uff1f"), (String)"\u63d0\u793a\u4fe1\u606f")) {
                        AbstractContentList.this.action_Delete();
                    }
                }
            });
        }
        return this.btnDel;
    }

    protected abstract void action_Delete();

    protected boolean checkListSelected() {
        if (this.lstMain.getSelectedIndex() < 0) {
            WindowUtil.msgboxInfo((Object)"\u5fc5\u987b\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"\u63d0\u793a\u4fe1\u606f", (Component)this.getOwner());
            return false;
        }
        return true;
    }

    private void setButttonStatus(KDWorkButton button, ImageIcon icon, String text) {
        button.setIcon((Icon)icon);
        button.setToolTipText(text);
        button.setVisible(!this.readOnly);
        button.setFocusable(true);
        button.setFocusPainted(false);
    }

    public Component getScrPane() {
        if (this.scrPane == null) {
            this.scrPane = new KDScrollPane(this.getLstMain());
        }
        return this.scrPane;
    }

    private Component getLstMain() {
        if (this.lstMain == null) {
            this.lstMain = new KDList();
        }
        return this.lstMain;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        if (readOnly) {
            this.btnOk.setVisible(false);
            this.btnCancel.setText("\u5173\u95ed");
        }
    }

    public void setOpenFromToolBar() {
        this.btnOk.setVisible(false);
        this.btnCancel.setText("\u786e\u5b9a");
    }

    public Object getSelectedModel() {
        return this.lstMain.getSelectedValue();
    }

    protected void onOk() {
        if (this.checkListSelected()) {
            super.onOk();
        }
    }
}

