/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.commonui.propsheet.beans.verify;

import com.kingdee.bos.bi.model.commonui.propsheet.beans.value.StringValue;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.verify.AbstractVerifier;
import com.kingdee.bos.bi.model.util.StringUtil;

public class LengthVerifier
extends AbstractVerifier {
    private int minLength = 0;
    private int maxLength = 0;

    public LengthVerifier(String msg, int minLength, int maxLength) {
        super(msg);
        this.minLength = minLength;
        this.maxLength = maxLength;
        if (StringUtil.isEmpty(msg)) {
            this.msg = "\u957f\u5ea6\u5fc5\u987b\u5728" + minLength + "\u548c" + maxLength + "\u4e4b\u95f4\uff01";
        }
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public boolean verify(Object value) {
        if (value == null) {
            return false;
        }
        if (this.minLength > this.maxLength) {
            return false;
        }
        if (value instanceof String) {
            String sv = (String)value;
            int le = sv.length();
            return le >= this.minLength && le <= this.maxLength;
        }
        if (value instanceof StringValue) {
            String sv = ((StringValue)value).getStringValue();
            int le = sv.length();
            return le >= this.minLength && le <= this.maxLength;
        }
        return false;
    }

    public static void main(String[] args) {
        LengthVerifier v = new LengthVerifier("msg", 1, 10);
        System.out.println(v.verify("012345678w9"));
    }
}

