/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.appmodel;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.common.list.ListUtil;
import com.kingdee.bos.bi.model.common.mm.appmodel.AppModelUtil;
import com.kingdee.bos.bi.model.rt.appmodel.DimensionViewRef;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.DimensionView;
import com.kingdee.bos.bi.model.rt.dim.DimensionViewFactory;
import com.kingdee.bos.bi.model.rt.fact.Fact;
import com.kingdee.bos.bi.model.ui.exception.BIModelBizException;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AppModelView
implements Serializable {
    private static final long serialVersionUID = 2285502034602684050L;
    private static final Logger log = LogUtil.getPackageLogger(AppModelView.class);
    public static final String TYPE_FINANCE = "finance";
    public static final String TYPE_CUSTOM = "common";
    private String id;
    private DimensionViewRef dimRef;
    private String type;
    private String pubnumber;
    private String name;
    private String dbCenterId;
    private String dbCenterName;
    private Map aggMap = null;
    private static Object obj = new Object();
    private static int counter = 0;

    private AppModelView(String type, String id, DimensionViewRef dimRef, String pubnumber, String name, String dbCenterId, String dbCenterName) {
        this.type = type;
        this.id = id;
        this.dimRef = dimRef;
        this.pubnumber = pubnumber;
        this.name = name;
        this.dbCenterId = dbCenterId;
        this.dbCenterName = dbCenterName;
    }

    public String getId() {
        return this.id;
    }

    public DimensionViewRef getDimRef() {
        return this.dimRef;
    }

    public String getPubnumber() {
        return this.pubnumber;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDbCenterId() {
        return this.dbCenterId;
    }

    public String getDbCenterName() {
        return this.dbCenterName;
    }

    public Map getAggMap() {
        return this.aggMap;
    }

    public void setAggMap(Map aggMap) {
        this.aggMap = aggMap;
    }

    public void publish(boolean flag, Connection cn) throws BIModelBizException {
        if (flag) {
            this.pub(this.pubnumber, cn);
        } else {
            this.unpub(cn, false, this.pubnumber);
        }
    }

    public void synModel(Connection cn) throws BIModelBizException {
        try {
            new Fact(this.dimRef).synModel(this.pubnumber, cn);
            int count = this.dimRef.getSize();
            int order = 0;
            for (int i = 0; i < count; ++i) {
                DimensionView dv = this.dimRef.getDimensionView(i);
                dv.synModel(this.pubnumber, cn, order++);
            }
        }
        catch (SQLException e) {
            throw new BIModelBizException(e);
        }
    }

    private void pub(String pubnumber, Connection con) throws BIModelBizException {
        try {
            DimensionView dv;
            int i;
            this.unpub(con, true, pubnumber);
            int count = this.dimRef.getSize();
            int order = 0;
            for (i = 0; i < count; ++i) {
                dv = this.dimRef.getDimensionView(i);
                dv.publish(pubnumber, con, order++);
            }
            for (i = 0; i < count; ++i) {
                dv = this.dimRef.getDimensionView(i);
                DimensionMeta dm = dv.getDimensionDef();
                dm.publish(this.id, dv.getId(), con);
            }
            new Fact(this.dimRef).publish(this.type, pubnumber, con);
            this.createCube(con);
            if (!this.savePubnumber(con, pubnumber)) {
                throw new SQLException("\u4fdd\u5b58\u53d1\u5e03\u7f16\u7801\u5931\u8d25\uff01");
            }
        }
        catch (SQLException e) {
            this.unpub(con, true, pubnumber);
            throw new BIModelBizException(e);
        }
    }

    private void unpub(Connection cn, boolean ignoreError, String pubnumber) throws BIModelBizException {
        boolean error = false;
        try {
            DimensionView dv;
            int i;
            int count = this.dimRef.getSize();
            for (i = 0; i < count; ++i) {
                dv = this.dimRef.getDimensionView(i);
                try {
                    dv.unpublish(pubnumber, cn);
                    continue;
                }
                catch (SQLException e) {
                    log.error((Object)"\u53d6\u6d88\u53d1\u5e03\u65f6\u51fa\u9519", (Throwable)e);
                    error = true;
                }
            }
            for (i = 0; i < count; ++i) {
                dv = this.dimRef.getDimensionView(i);
                DimensionMeta dm = dv.getDimensionDef();
                try {
                    dm.unPublish(this.id, cn);
                    break;
                }
                catch (SQLException e) {
                    log.error((Object)"\u53d6\u6d88\u53d1\u5e03\u65f6\u51fa\u9519", (Throwable)e);
                    error = true;
                    continue;
                }
            }
            new Fact(this.dimRef).unpublish(pubnumber, cn);
            this.delCube(cn);
        }
        catch (SQLException e) {
            log.error((Object)"\u53d6\u6d88\u53d1\u5e03\u65f6\u51fa\u9519", (Throwable)e);
            error = true;
        }
        if (!ignoreError && error) {
            throw new BIModelBizException("\u53d1\u751f\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u4f7f\u7528\u63a7\u5236\u5236\u53f0\u6e05\u9664\u53ef\u80fd\u7684\u5783\u573e\uff01");
        }
    }

    private void delCube(Connection cn) throws SQLException {
        String sql = "delete from T_BI_AM_Cube where FAMID='" + this.id + "'";
        DBUtil.executeUpdate(sql, cn);
    }

    private void createCube(Connection cn) throws SQLException {
    }

    private boolean savePubnumber(Connection cn, String pubnumber) throws SQLException {
        String sql = "Update " + ListUtil.getViewTablename(TYPE_FINANCE) + " set FPublishNumber='" + pubnumber + "' where FID='" + this.id + "'";
        return DBUtil.executeUpdate(sql, cn) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppModelView fromDB(String viewid, Context ctx) throws SQLException {
        DimensionViewRef dr = new DimensionViewRef();
        String pubnumber = null;
        String name = null;
        String type = null;
        String dbCenterId = null;
        String dbCenterName = null;
        HashMap aggMap = new HashMap();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection cn = null;
        try {
            cn = BISystem.getJdbcConnection((Context)ctx);
            String sqlPubNumber = "select A.FName,A.FPublishNumber,A.FType,A.FDBCenterId,B.FDBCenterName from T_BI_AppModel A left join T_BI_DB_CENTER B on\tA.FDBCenterId= B.FID where  A.FID='" + viewid + "'";
            stmt = cn.prepareStatement(sqlPubNumber);
            rs = stmt.executeQuery();
            while (rs.next()) {
                pubnumber = rs.getString("FPublishNumber");
                name = rs.getString("FName");
                type = rs.getString("FType");
                if (StringUtil.isEmpty(type)) {
                    type = TYPE_FINANCE;
                }
                dbCenterId = rs.getString("FDBCenterId");
                dbCenterName = rs.getString("FDBCenterName");
            }
            String sqlRef = "select FDimType, FDimViewID, FDimAlias from T_BI_AM_DimRef where FAMID='" + viewid + "' order by FDimType ASC";
            stmt = cn.prepareStatement(sqlRef);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String dimensionType = (String)rs.getObject(1);
                String id = (String)rs.getObject(2);
                DimensionType dt = DimensionType.getObj(ctx, dimensionType);
                DimensionView dv = DimensionViewFactory.createDimensionView(dt, id, ctx);
                String alias = (String)rs.getObject(3);
                if (dv.getDimensionDef().isMeasure()) {
                    dr.add(-1, dv, id, alias);
                    continue;
                }
                dr.add(0, dv, id, alias);
            }
            if (StringUtil.equalsIgnoreCase(TYPE_CUSTOM, type)) {
                aggMap.putAll(AppModelUtil.loadAppAggregate(cn, viewid));
            }
            rs.close();
            stmt.close();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt, (Connection)cn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        if (pubnumber == null) {
            pubnumber = AppModelView.getPubNumber();
        }
        AppModelView apv = new AppModelView(type, viewid, dr, pubnumber, name, dbCenterId, dbCenterName);
        apv.setAggMap(aggMap);
        return apv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPubNumber() {
        Object object = obj;
        synchronized (object) {
            if (counter++ > 9) {
                counter = 0;
            }
            return System.currentTimeMillis() + "" + counter;
        }
    }
}

