/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.bireport.calmember.lastyear;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.EnumObj;
import com.kingdee.bos.bi.model.rt.bireport.BIReportMDXUtils;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalMember;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalculatorType;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.FormatString;
import com.kingdee.bos.bi.model.rt.dim.Member;
import com.kingdee.bos.bi.model.ui.dialog.bireport.calmember.lastyear.LastYearDetailPanel;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.bi.model.util.XmlUtil;
import java.io.IOException;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class LastYearCalMember
extends CalMember {
    private String calMode;
    private String calMeasure;
    private int solveOrder;
    private String formatString;
    private List advances;
    private String appModelType;

    public LastYearCalMember(String name, String caption, DimensionType dt, String schema) {
        super(null, null, null, name, caption, dt, CalculatorType.lastYear);
        try {
            this.fromXML(schema);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toMDX() {
        StringBuffer sb = new StringBuffer();
        sb.append(" member [");
        sb.append("measures].[" + this.number);
        sb.append("] as '");
        sb.append(this.getMdx());
        sb.append("'");
        sb.append(",solveOrder=" + this.solveOrder + "");
        if (this.formatString != null) {
            sb.append(",formatString='" + this.formatString + "'");
        }
        if (!StringUtil.isEmpty(this.name)) {
            sb.append(",caption='" + this.name + "'");
        }
        return sb.toString();
    }

    private String getMdx() {
        StringBuffer sb = new StringBuffer();
        if (!"common".equalsIgnoreCase(this.appModelType)) {
            if ("Dif".equalsIgnoreCase(this.calMode)) {
                sb.append("(measures.[" + this.calMeasure + "]) - (measures.[" + this.calMeasure + "] ,Year.prevMember)");
            } else if ("Rate".equalsIgnoreCase(this.calMode)) {
                sb.append("measures.[" + this.calMeasure + "]/(measures.[" + this.calMeasure + "] ,Year.prevMember)");
            } else if ("Growth".equalsIgnoreCase(this.calMode)) {
                sb.append("((measures.[" + this.calMeasure + "])-(measures.[" + this.calMeasure + "] ,Year.prevMember))/(measures.[" + this.calMeasure + "] ,Year.prevMember)");
            }
        } else {
            String mem = BIReportMDXUtils.addSquareBrackets(this.calMeasure);
            if ("Dif".equalsIgnoreCase(this.calMode)) {
                sb.append("(measures." + mem + ")\u2013(measures." + mem + ",ParallelPeriod())");
            } else if ("Rate".equalsIgnoreCase(this.calMode)) {
                sb.append("(measures." + mem + ")/(measures." + mem + ",ParallelPeriod())");
            } else if ("Growth".equalsIgnoreCase(this.calMode)) {
                sb.append("((measures." + mem + ")-(measures." + mem + ",ParallelPeriod()))/(measures." + mem + ",ParallelPeriod())");
            }
        }
        return sb.toString();
    }

    private void fromXML(String xml) throws IOException, JDOMException {
        if (StringUtil.isEmpty(xml)) {
            this.solveOrder = 1;
            return;
        }
        Element e = XmlUtil.toRootElement(xml);
        this.calMode = e.getAttributeValue("calMode");
        this.calMeasure = e.getAttributeValue("calMeasure");
        this.appModelType = e.getAttributeValue("appModelType");
        this.formatString = e.getAttributeValue("formatString");
        this.solveOrder = 1;
        try {
            this.solveOrder = Integer.parseInt(e.getAttributeValue("solveOrder"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        List eles = e.getChildren("measure");
        if (eles == null || eles.size() > 0) {
            // empty if block
        }
    }

    @Override
    public String getSchema() {
        StringBuffer sb = new StringBuffer();
        sb.append("");
        sb.append("");
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        sb.append("<LastYear");
        sb.append(" calMode=\"" + this.calMode + "\"");
        sb.append(" calMeasure=\"" + this.calMeasure + "\"");
        sb.append(" formatString=\"" + this.formatString + "\"");
        sb.append(" appModelType=\"" + this.appModelType + "\"");
        sb.append(" solveOrder=\"" + this.solveOrder + "\" >");
        sb.append("</LastYear>");
        return sb.toString();
    }

    public int getCalMeasureIndex(LastYearDetailPanel zRateDetailPanel) {
        int i = zRateDetailPanel.calMeasure.getItemCount();
        for (int y = 0; y < i; ++y) {
            Member measure = (Member)zRateDetailPanel.calMeasure.getItemAt(y);
            String number = measure.getNumber();
            if (!number.equals(this.calMeasure)) continue;
            return y;
        }
        return 0;
    }

    public int getFormatStringIndex(LastYearDetailPanel lastMonthDetailPanel) {
        int i = lastMonthDetailPanel.cmbFormatString.getItemCount();
        for (int y = 0; y < i; ++y) {
            FormatString format = (FormatString)lastMonthDetailPanel.cmbFormatString.getItemAt(y);
            if (!format.getName().equals(this.formatString)) continue;
            return y;
        }
        return 0;
    }

    public int getCalModeIndex(LastYearDetailPanel lastMonthDetailPanel) {
        int i = lastMonthDetailPanel.calMode.getItemCount();
        for (int y = 0; y < i; ++y) {
            EnumObj mode = (EnumObj)lastMonthDetailPanel.calMode.getItemAt(y);
            if (!mode.getName().equals(this.calMode)) continue;
            return y;
        }
        return 0;
    }

    public int getSolveOrder() {
        return this.solveOrder;
    }

    @Override
    public String toMDX(Dimension dim, Context ctx) {
        return null;
    }
}

