/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.dim;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.DimensionMetaFactory;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.custom.general.GeneralDimension;
import com.kingdee.bos.bi.model.rt.dim.custom.time.TimeDimension;
import com.kingdee.bos.bi.model.rt.dim.measure.MeasureDimension;
import com.kingdee.bos.bi.model.rt.dim.metric.MetricDimension;
import com.kingdee.bos.bi.model.rt.dim.org.OrgDimension;
import com.kingdee.bos.bi.model.rt.dim.period.PeriodDimension;
import com.kingdee.bos.bi.model.rt.dim.year.YearDimension;
import java.sql.SQLException;

public class DimensionFactory {
    public static Dimension createDimension(DimensionType dt, AppModel appmodel, Context ctx) throws SQLException {
        String type = dt.getName();
        String innerType = dt.getInnerType();
        DimensionMeta dm = DimensionMetaFactory.createDimensionMeta(dt, ctx);
        if ("org".equalsIgnoreCase(type)) {
            return new OrgDimension(appmodel, dm);
        }
        if ("metric".equalsIgnoreCase(type)) {
            return new MetricDimension(appmodel, dm);
        }
        if ("year".equalsIgnoreCase(type)) {
            return new YearDimension(appmodel, dm);
        }
        if ("period".equalsIgnoreCase(type)) {
            return new PeriodDimension(appmodel, dm);
        }
        if ("measure".equalsIgnoreCase(type)) {
            return new MeasureDimension(appmodel, dm);
        }
        if ("time".equalsIgnoreCase(innerType)) {
            return new TimeDimension(appmodel, dm);
        }
        if ("general".equalsIgnoreCase(innerType)) {
            return new GeneralDimension(appmodel, dm);
        }
        return null;
    }
}

