/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.dim;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.custom.general.GeneralDimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.custom.time.TimeDimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.measure.MeasureDimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.metric.MetricDimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.org.OrgDimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.period.PeriodDimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.year.YearDimensionMeta;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.util.StringUtil;
import java.io.IOException;
import java.sql.SQLException;
import org.jdom2.JDOMException;

public class DimensionMetaFactory {
    public static DimensionMeta createDimensionMeta(DimensionType dt, Context ctx) {
        String type = dt.getName();
        String innerType = dt.getInnerType();
        if ("measure".equalsIgnoreCase(type)) {
            return new MeasureDimensionMeta(dt);
        }
        if ("metric".equalsIgnoreCase(type)) {
            return new MetricDimensionMeta(dt);
        }
        if ("org".equalsIgnoreCase(type)) {
            return new OrgDimensionMeta(dt);
        }
        if ("period".equalsIgnoreCase(type)) {
            return new PeriodDimensionMeta(dt);
        }
        if ("year".equalsIgnoreCase(type)) {
            return new YearDimensionMeta(dt);
        }
        if (!StringUtil.isEmpty(innerType)) {
            if ("time".equalsIgnoreCase(innerType)) {
                return new TimeDimensionMeta(dt);
            }
            if ("general".equalsIgnoreCase(innerType)) {
                try {
                    return new GeneralDimensionMeta(dt, ctx);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                catch (JDOMException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static DimensionMeta createDimensionMeta(IManagementFacade facade, DimensionType dt) {
        String type = dt.getName();
        String innerType = dt.getInnerType();
        if ("measure".equalsIgnoreCase(type)) {
            return new MeasureDimensionMeta(dt);
        }
        if ("metric".equalsIgnoreCase(type)) {
            return new MetricDimensionMeta(dt);
        }
        if ("org".equalsIgnoreCase(type)) {
            return new OrgDimensionMeta(dt);
        }
        if ("period".equalsIgnoreCase(type)) {
            return new PeriodDimensionMeta(dt);
        }
        if ("year".equalsIgnoreCase(type)) {
            return new YearDimensionMeta(dt);
        }
        if (!StringUtil.isEmpty(innerType)) {
            if ("time".equalsIgnoreCase(innerType)) {
                return new TimeDimensionMeta(dt);
            }
            if ("general".equalsIgnoreCase(innerType)) {
                try {
                    return new GeneralDimensionMeta(dt, facade);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                catch (JDOMException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

