/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.dim.measure;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.formularengine.FormularParser;
import com.kingdee.bos.bi.model.common.formularengine.FormularsLevelSortor;
import com.kingdee.bos.bi.model.common.formularengine.exception.StringParsingException;
import com.kingdee.bos.bi.model.common.formularengine.expr.AbstractExpr;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.security.SecureUtil;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MeasureDimension
extends Dimension {
    private static Logger log = CommonLogger.getLogger(MeasureDimension.class);

    public MeasureDimension(AppModel appmodel, DimensionMeta df) {
        super(appmodel, df);
    }

    @Override
    protected int getMaxCacheSize() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getMembers(Connection cn, Context ctx, boolean bSecureFilter, boolean bTreeFilter) throws SQLException {
        String pubnumber = this.appmodel.getPubnumber();
        List lstRet = new ArrayList();
        try {
            FormularParser parser = new FormularParser();
            FormularsLevelSortor sorter = new FormularsLevelSortor();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String tablename = this.dm.getTablename(pubnumber);
            try {
                String sqlPermission;
                String sql = "select FNumber, FFormula from " + tablename + " where FFlag is null or FFlag = 0";
                if (bSecureFilter && !StringUtils.isEmpty((String)(sqlPermission = SecureUtil.getRowSecureSQL(ctx, this)))) {
                    sql = "select * from (" + sql + ") as xxx where " + sqlPermission;
                }
                stmt = cn.prepareStatement(sql);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String number = rs.getObject(1).toString();
                    String formula = (String)rs.getObject(2);
                    AbstractExpr a = null;
                    if (!StringUtils.isEmpty((String)formula)) {
                        a = parser.parse(formula);
                    }
                    sorter.addVar(number, a);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sorter.sort();
            lstRet = Arrays.asList((Object[])sorter.getSortedVars());
        }
        catch (Exception ex) {
            log.error((Object)"\u83b7\u53d6\u6240\u6709\u5ea6\u91cf\u65f6\u51fa\u9519\uff01", (Throwable)ex);
        }
        return lstRet;
    }

    public List sortByFormular(List l, Connection cn) throws SQLException {
        FormularParser parser = new FormularParser();
        FormularsLevelSortor sorter = new FormularsLevelSortor();
        int len = l.size();
        for (int i = 0; i < len; ++i) {
            String number = (String)l.get(i);
            String formula = (String)this.findProperty(number, "FFormula", cn);
            AbstractExpr a = null;
            if (!StringUtils.isEmpty((String)formula)) {
                try {
                    a = parser.parse(formula);
                }
                catch (StringParsingException e) {
                    e.printStackTrace();
                }
            }
            sorter.addVar(number, a);
        }
        sorter.sort();
        return Arrays.asList((Object[])sorter.getSortedVars());
    }
}

