/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.fact;

import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.DB.Field;
import com.kingdee.bos.bi.model.rt.appmodel.DimensionViewRef;
import com.kingdee.bos.bi.model.rt.dim.DimensionView;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Fact {
    private DimensionViewRef drf;
    private String index;
    private static final String NO_FACT = "000";
    private static final String TABLE_PREFIX_FACT = "T_BI_F_";
    private static final String FIELD_NAME_TIMESTAMP = "FTimeStamp";
    private static final Field COMMON_APPMODEL_TIMESTAMP_FIELD = new Field("FTimeStamp", "dateTime", true, null);

    public Fact(DimensionViewRef drf) {
        this.drf = drf;
    }

    public static String getTablename(String pubnumber) {
        return TABLE_PREFIX_FACT + pubnumber;
    }

    public static String getTimeStampField() {
        return FIELD_NAME_TIMESTAMP;
    }

    public void publish(String appModelType, String pubnumber, Connection cn) throws SQLException {
        String tablename = Fact.getTablename(pubnumber);
        DimensionView dv = this.drf.getDimensionView("measure");
        String view_id = dv.getId();
        DBUtil.createTable(tablename, view_id, this.getFields(appModelType, view_id, this.drf, cn), false, cn);
        String indexname = this.getIndexName(pubnumber);
        DBUtil.createIndex(tablename, this.index, indexname, cn);
    }

    private String getNo() {
        return NO_FACT;
    }

    public String getIndexName(String pubNumber) {
        return "I" + this.getNo() + pubNumber;
    }

    public void unpublish(String pubnumber, Connection cn) throws SQLException {
        DBUtil.dropTable(false, Fact.getTablename(pubnumber), cn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getFields(String appModelType, String viewid, DimensionViewRef drf, Connection cn) throws SQLException {
        ArrayList<Field> lstFields = new ArrayList<Field>();
        int size = drf.getSize();
        StringBuffer sbIndex = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            DimensionView dv = drf.getDimensionView(i);
            if (dv.isMeasure()) continue;
            String name = "F" + dv.getDimensionDef().getType() + "ID";
            String type = dv.getDimensionDef().findFieldType(dv.getDimensionDef().getPK());
            boolean isnull = false;
            String value = null;
            Field f = new Field(name, type, isnull, value);
            f.setFK(dv.getDimensionDef().getType());
            lstFields.add(f);
            sbIndex.append(name);
            sbIndex.append(" ASC,");
        }
        sbIndex.deleteCharAt(sbIndex.length() - 1);
        this.index = sbIndex.toString();
        String sql = "select FNumber, FDataType from T_BI_MM_Measure where FVIEWID='" + viewid + "'";
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String measureNumber = rs.getString("FNumber");
                String name = "FM_" + measureNumber;
                String type = rs.getString("FDataType");
                boolean isnull = false;
                String value = null;
                Field f = new Field(name, type, isnull, value);
                f.setMeasureNumber(measureNumber);
                f.setDefaultValue("0.0");
                lstFields.add(f);
                name = name + "_Flag";
                type = "int";
                isnull = true;
                value = "0";
                f = new Field(name, type, isnull, value);
                lstFields.add(f);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)stmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        if ("common".equals(appModelType)) {
            lstFields.add(COMMON_APPMODEL_TIMESTAMP_FIELD);
        }
        return lstFields;
    }

    public void synModel(String pubNumber, Connection cn) throws SQLException {
        String indexname;
        String tablename = Fact.getTablename(pubNumber);
        if (this.index != null) {
            indexname = this.getIndexName(pubNumber);
            DBUtil.dropIndex(tablename, indexname, cn);
        }
        this.synData(pubNumber, cn);
        if (this.index != null) {
            indexname = this.getIndexName(pubNumber);
            DBUtil.createIndex(tablename, this.index, indexname, cn);
        }
    }

    private void synData(String pubNumber, Connection cn) throws SQLException {
        DimensionView dv = this.drf.getDimensionView("measure");
        String measure_view_id = dv.getId();
        String measure_view_table = dv.getTablename();
        String tablename = Fact.getTablename(pubNumber);
        String fnumber = "FNumber";
        String where = "FNumber not in (select " + fnumber + " from " + dv.getDimensionDef().getTablename(pubNumber) + ") and FViewID='" + measure_view_id + "'";
        String sql = "select FNumber,FDataType from " + measure_view_table + " where " + where;
        RDRowSet rs = DBUtil.executeQuery(sql, cn);
        while (rs.next()) {
            boolean isnull = false;
            String value = null;
            String name = "FM_" + rs.getString("FNumber");
            String type = rs.getString("FDataType");
            Field f = new Field(name, type, isnull, value);
            sql = "alter table " + tablename + " add " + f.name + " " + f.type;
            DBUtil.executeUpdate(sql, cn);
            name = name + "_Flag";
            type = "int";
            isnull = true;
            value = "0";
            f = new Field(name, type, isnull, value);
            sql = "alter table " + tablename + " add " + f.name + " " + f.type;
            DBUtil.executeUpdate(sql, cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateFactData(String pubNumber, Number value, Map dimKeyValue, int dataSrcFlag, Connection cn, Map dataPropCache, Map mapStatement, boolean batchFlag) throws SQLException {
        int oldFlag;
        String table = Fact.getTablename(pubNumber);
        String key = this.getDataKey(pubNumber, dimKeyValue);
        boolean isNew = false;
        String sql = "select * from " + table + " " + this.getUpdateSqlWhere(dimKeyValue, true);
        boolean bl = isNew = !DBUtil.existRecord(sql, cn);
        if (!isNew && dataPropCache.containsKey(key) && (oldFlag = ((Integer)dataPropCache.get(key)).intValue()) == 0 && dataSrcFlag == 1) {
            return;
        }
        String stmtKey = (isNew ? "I" : "U") + (String)dimKeyValue.get("measure");
        PreparedStatement stmt = null;
        try {
            if (batchFlag) {
                if (mapStatement.containsKey(stmtKey)) {
                    stmt = (PreparedStatement)mapStatement.get(stmtKey);
                } else {
                    stmt = cn.prepareStatement(this.getUpdateSql(isNew, table, dimKeyValue));
                    mapStatement.put(stmtKey, stmt);
                }
            } else {
                stmt = cn.prepareStatement(this.getUpdateSql(isNew, table, dimKeyValue));
            }
            if (isNew) {
                Iterator it = dimKeyValue.keySet().iterator();
                int counter = 1;
                while (it.hasNext()) {
                    String type = (String)it.next();
                    if (type.equalsIgnoreCase("measure")) {
                        stmt.setObject(counter++, value);
                        stmt.setInt(counter++, dataSrcFlag);
                        continue;
                    }
                    stmt.setObject(counter++, dimKeyValue.get(type));
                }
            } else {
                stmt.setObject(1, value);
                stmt.setInt(2, dataSrcFlag);
                Iterator it = dimKeyValue.keySet().iterator();
                int counter = 3;
                while (it.hasNext()) {
                    String type = (String)it.next();
                    if (type.equalsIgnoreCase("measure")) continue;
                    Object objValue = dimKeyValue.get(type);
                    stmt.setObject(counter++, objValue);
                }
            }
            if (batchFlag) {
                stmt.addBatch();
                dataPropCache.put(key, new Integer(dataSrcFlag));
            } else {
                stmt.execute();
            }
            if (batchFlag) return;
        }
        catch (Throwable throwable) {
            if (batchFlag) throw throwable;
            SQLUtils.cleanup(stmt);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stmt);
    }

    private String getDataKey(String pubNumber, Map dimKeyValue) {
        Iterator it = dimKeyValue.keySet().iterator();
        StringBuffer sbKey = new StringBuffer();
        while (it.hasNext()) {
            Object objValue;
            String type = (String)it.next();
            if (!type.equalsIgnoreCase("measure")) {
                objValue = dimKeyValue.get(type);
                sbKey.append(objValue);
                sbKey.append("_");
                continue;
            }
            objValue = dimKeyValue.get(type);
            sbKey.append(objValue);
            sbKey.append("_");
        }
        sbKey.deleteCharAt(sbKey.length() - 1);
        return sbKey.toString();
    }

    private String getUpdateSql(boolean isNew, String tablename, Map dimKeyValue) {
        StringBuffer sb = new StringBuffer();
        if (isNew) {
            sb.append("insert into " + tablename + "(");
            for (String type : dimKeyValue.keySet()) {
                if (!type.equalsIgnoreCase("measure")) {
                    sb.append("F" + type + "ID,");
                    continue;
                }
                sb.append("FM_" + dimKeyValue.get(type) + ",");
                sb.append("FM_" + dimKeyValue.get(type) + "_flag,");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(") values(");
            for (String type : dimKeyValue.keySet()) {
                if (!type.equalsIgnoreCase("measure")) {
                    sb.append("?");
                    sb.append(",");
                    continue;
                }
                sb.append("?");
                sb.append(",");
                sb.append("?");
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
        } else {
            sb.append("update " + tablename);
            String mv = (String)dimKeyValue.get("measure");
            sb.append(" set FM_" + mv);
            sb.append("=? ");
            sb.append(",FM_" + mv + "_flag");
            sb.append("=? ");
            sb.append(this.getUpdateSqlWhere(dimKeyValue, false));
        }
        return sb.toString();
    }

    private String getUpdateSqlWhere(Map dimKeyValue, boolean flag) {
        StringBuffer sb = new StringBuffer();
        sb.append(" where ");
        Iterator it = dimKeyValue.keySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            String type = (String)it.next();
            if (type.equalsIgnoreCase("measure")) continue;
            if (first) {
                first = false;
            } else {
                sb.append(" and ");
            }
            if (flag) {
                sb.append("F" + type + "ID=");
                Object objValue = dimKeyValue.get(type);
                sb.append(objValue);
                continue;
            }
            sb.append("F" + type + "ID=?");
        }
        return sb.toString();
    }
}

