/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.kpimonitor;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.mm.kpi.KPIModel;
import com.kingdee.bos.bi.model.common.mm.measure.MeasureDimensionNode;
import com.kingdee.bos.bi.model.common.mm.monitor.MetricMonitorModel;
import com.kingdee.bos.bi.model.common.mm.monitor.MetricMonitorXmlModel;
import com.kingdee.bos.bi.model.common.mm.org.OrgDimensionNode;
import com.kingdee.bos.bi.model.common.mm.period.PeriodDimensionNode;
import com.kingdee.bos.bi.model.common.mm.year.YearDimensionNode;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.appmodel.AppModelView;
import com.kingdee.bos.bi.model.rt.kpimonitor.KPIMonitorUtil;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.bi.model.util.ModelIOHelper;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractTreeNode;
import com.kingdee.bos.ctrl.analysis.web.kpimonitor.IKPIMonitor;
import com.kingdee.bos.ctrl.analysis.web.kpimonitor.KPIMonitorException;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class KPIMonitor
implements IKPIMonitor {
    private static final Logger log = LogUtil.getPackageLogger(KPIMonitor.class);
    private MetricMonitorModel monitorModel = null;
    private KPIModel kpiModel = null;
    private AppModel appModel = null;
    private String kpiMonitorId = null;
    private String currMonitorType = null;
    private Map baseInfo = null;
    private Map mapConditionParms = new HashMap();
    private Map mapConditionIds = new HashMap();
    private Map _mapYearFilterTree = null;
    private Map _mapMeasureFilterTree = null;
    private Map _mapPeriodFilterTree = null;
    private Map _mapOrgFilterTree = null;
    List metricNodeList = null;
    private TreeMap _mapYearFilter = null;
    private TreeMap _mapPeriodFilter = null;
    private TreeMap _mapOrgFilter = null;
    private TreeMap _mapMeasureFilter = null;
    private TreeMap _mapMetricFilter = null;
    private String globalMessage = null;
    private static final String PARAM_MEMBERS = "members";
    private static final String PARAM_DIMENSION = "dimension";
    private static final String CONDITION_KEY_ORG = "org";
    private static final String CONDITION_KEY_YEAR = "year";
    private static final String CONDITION_KEY_PERIOD = "period";
    private static final String CONDITION_KEY_METRIC = "metric";
    private static final String[] CONDITION_TYPE = new String[]{"org", "year", "period", "metric"};
    private static final String BEGIN_WITH_QUOTE = "('";
    private static final String END__WITH_QUOTE = "')";
    private static final String BEGIN_NO_QUOTE = "(";
    private static final String END_NO_QUOTE = ")";
    public static final String GLOBAL_MESSAGE = "globalMessage";

    public KPIMonitor(HttpServletRequest request, String kpiMonitorId, Map baseInfo) {
        this.kpiMonitorId = kpiMonitorId;
        this.baseInfo = baseInfo;
        this.currMonitorType = (String)baseInfo.get("monitorType");
    }

    public void init(HttpServletRequest request) throws BIReportException {
        this.initKPIMonitorModels(request);
        this.initDimensionCache(request);
        this.initCondition(request);
    }

    private void initKPIMonitorModels(HttpServletRequest request) throws BIReportException {
        Connection con = null;
        try {
            con = BISystem.getJdbcConnection((HttpServletRequest)request);
            Context ctx = BISystem.getContext((HttpServletRequest)request);
            this.monitorModel = KPIMonitorUtil.getMonitorModel(con, this.kpiMonitorId);
            this.kpiModel = KPIMonitorUtil.getKPIModel(con, this.monitorModel.getKPIId());
            this.appModel = new AppModel(AppModelView.fromDB(this.kpiModel.getFAMID(), ctx), ctx);
        }
        catch (SQLException e) {
            log.error((Object)("\u8bfb\u53d6\u6570\u636e\u5e93\u51fa\u9519\uff1a" + e.getMessage()));
            throw new BIReportException((Throwable)e);
        }
        catch (KPIMonitorException e) {
            log.error((Object)("\u53d6\u5f97\u6a21\u578b\u51fa\u9519\uff1a" + e.getMessage()));
            throw new BIReportException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private String getAppModelId() {
        return this.kpiModel.getFAMID();
    }

    public void initDimensionCache(HttpServletRequest request) throws BIReportException {
        try {
            String appModelId = this.getAppModelId();
            ModelIOHelper modelIOHelper = new ModelIOHelper(request);
            OrgDimensionNode root1 = modelIOHelper.getRTOrgTree(appModelId);
            TreeMap mapOrgFilter = new TreeMap();
            HashMap mapOrgFilterTree = new HashMap();
            KPIMonitor.keepTurbo(true, root1, mapOrgFilter, mapOrgFilterTree);
            this._mapOrgFilter = mapOrgFilter;
            this._mapOrgFilterTree = mapOrgFilterTree;
            YearDimensionNode root2 = modelIOHelper.getRTYearTree(appModelId);
            TreeMap mapYearFilter = new TreeMap();
            HashMap mapYearFilterTree = new HashMap();
            KPIMonitor.keepTurbo(false, root2, mapYearFilter, mapYearFilterTree);
            this._mapYearFilter = mapYearFilter;
            this._mapYearFilterTree = mapYearFilterTree;
            PeriodDimensionNode root3 = modelIOHelper.getRTPeriodTree(appModelId);
            TreeMap mapPeriodFilter = new TreeMap();
            HashMap mapPeriodFilterTree = new HashMap();
            KPIMonitor.keepTurbo(false, root3, mapPeriodFilter, mapPeriodFilterTree);
            this._mapPeriodFilterTree = mapPeriodFilterTree;
            this._mapPeriodFilter = mapPeriodFilter;
            this.metricNodeList = new ModelIOHelper(request).getRTMetricList(appModelId);
            Iterator it = this.metricNodeList.iterator();
            while (it.hasNext()) {
                if (this._mapMetricFilter == null) {
                    this._mapMetricFilter = new TreeMap();
                }
                AbstractTreeNode node = (AbstractTreeNode)it.next();
                this._mapMetricFilter.put(node.getModel().getNumber(), node.getModel().getName());
            }
            MeasureDimensionNode root5 = modelIOHelper.getRTMeasureTree(appModelId);
            TreeMap mapMeasureFilter = new TreeMap();
            HashMap mapMeasureFilterTree = new HashMap();
            KPIMonitor.keepTurbo(false, root5, mapMeasureFilter, mapMeasureFilterTree);
            this._mapMeasureFilter = mapMeasureFilter;
            this._mapMeasureFilterTree = mapMeasureFilterTree;
        }
        catch (BIReportException e) {
            log.error((Object)e);
            throw e;
        }
        catch (BIModelRemoteException e) {
            log.error((Object)e);
            throw new BIReportException((Throwable)((Object)e));
        }
    }

    private static void keepTurbo(boolean isWithRoot, AbstractTreeNode node, Map mapKeepCaption, Map mapKeepParent) {
        if (isWithRoot || node.getParentNode() != null) {
            String parnetNumber;
            ArrayList<AbstractTreeNode> list;
            String name = node.getModel().getName();
            String number = node.getModel().getNumber();
            if (node.canSelect()) {
                mapKeepCaption.put(number, name);
            }
            if ((list = (ArrayList<AbstractTreeNode>)mapKeepParent.get(parnetNumber = isWithRoot ? (node.getParentNode() == null ? null : node.getParentNode().getModel().getNumber()) : (node.getParentNode().getParentNode() == null ? null : node.getParentNode().getModel().getNumber()))) == null) {
                list = new ArrayList<AbstractTreeNode>();
                mapKeepParent.put(parnetNumber, list);
            }
            list.add(node);
        }
        int c = node.getChildCount();
        for (int i = 0; i < c; ++i) {
            KPIMonitor.keepTurbo(isWithRoot, node.getChildNode(i), mapKeepCaption, mapKeepParent);
        }
    }

    public void close(HttpServletRequest request) {
    }

    public List getConditions() {
        ArrayList<Object> list = new ArrayList<Object>();
        Object obj = null;
        int n = CONDITION_TYPE.length;
        for (int i = 0; i < n; ++i) {
            obj = this.mapConditionParms.get(CONDITION_TYPE[i]);
            if (obj != null) {
                list.add(obj);
            }
            obj = null;
        }
        return list;
    }

    public Map getConditionParam(MetricMonitorXmlModel xmlModel) {
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("paramOrg", BEGIN_WITH_QUOTE + this.mapConditionIds.get("paramOrg") + END__WITH_QUOTE);
        filterMap.put("paramYear", BEGIN_NO_QUOTE + this.mapConditionIds.get("paramYear") + END_NO_QUOTE);
        filterMap.put("paramPeriod", BEGIN_NO_QUOTE + this.mapConditionIds.get("paramPeriod") + END_NO_QUOTE);
        filterMap.put("paramMetric", BEGIN_WITH_QUOTE + this.mapConditionIds.get("paramMetric") + END__WITH_QUOTE);
        Object showList = this.baseInfo.get("showList");
        if (showList == null) {
            ArrayList<String> orderList = new ArrayList<String>();
            StringBuffer sb = new StringBuffer();
            sb.append(BEGIN_NO_QUOTE);
            MetricMonitorXmlModel.Metric metric2 = null;
            String metricNumber = null;
            List metricList = xmlModel.getMetricList();
            for (MetricMonitorXmlModel.Metric metric2 : metricList) {
                metricNumber = metric2.getMetricNumber();
                sb.append("'").append(metricNumber).append("',");
                orderList.add(metricNumber);
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(END_NO_QUOTE);
            filterMap.put("paramShowList", sb.toString());
            filterMap.put("paramMetricOrder", orderList);
        } else {
            filterMap.put("paramShowList", showList);
        }
        return filterMap;
    }

    public Map handleConditions() {
        HashMap filterMap = new HashMap();
        if (this.mapConditionParms.get(CONDITION_KEY_ORG) != null) {
            filterMap.put("defaultOrg", ((Map)this.mapConditionParms.get(CONDITION_KEY_ORG)).get("defaultValue"));
        }
        filterMap.put("defaultYear", ((Map)this.mapConditionParms.get(CONDITION_KEY_YEAR)).get("defaultValue"));
        filterMap.put("defaultPeriod", ((Map)this.mapConditionParms.get(CONDITION_KEY_PERIOD)).get("defaultValue"));
        if (this.mapConditionParms.get(CONDITION_KEY_METRIC) != null) {
            filterMap.put("defaultMetric", ((Map)this.mapConditionParms.get(CONDITION_KEY_METRIC)).get("defaultValue"));
        }
        return filterMap;
    }

    public void setCondition(HttpServletRequest req, String conditionItem, String[] numbers) {
        Map mapMetric;
        if (CONDITION_KEY_ORG.equals(conditionItem)) {
            Map mapOrg = (Map)this.mapConditionParms.get(CONDITION_KEY_ORG);
            if (mapOrg != null) {
                mapOrg.put("defaultValue", numbers[0]);
                mapOrg.put("defaultCaption", numbers[0] == null ? "ERROR" : this._mapOrgFilter.get(numbers[0]));
                this.mapConditionIds.put("paramOrg", numbers[0]);
            }
        } else if (CONDITION_KEY_YEAR.equals(conditionItem)) {
            Map mapYear = (Map)this.mapConditionParms.get(CONDITION_KEY_YEAR);
            if (mapYear != null) {
                mapYear.put("defaultValue", numbers[0]);
                mapYear.put("defaultCaption", numbers[0] == null ? "ERROR" : this._mapYearFilter.get(numbers[0]));
                this.mapConditionIds.put("paramYear", numbers[0]);
            }
        } else if (CONDITION_KEY_PERIOD.equals(conditionItem)) {
            Map mapPeriod = (Map)this.mapConditionParms.get(CONDITION_KEY_PERIOD);
            if (mapPeriod != null) {
                mapPeriod.put("defaultValue", numbers[0]);
                mapPeriod.put("defaultCaption", numbers[0] == null ? "ERROR" : this._mapPeriodFilter.get(numbers[0]));
                this.mapConditionIds.put("paramPeriod", numbers[0]);
            }
        } else if (CONDITION_KEY_METRIC.equals(conditionItem) && (mapMetric = (Map)this.mapConditionParms.get(CONDITION_KEY_METRIC)) != null) {
            mapMetric.put("defaultValue", numbers[0]);
            this.mapConditionIds.put("paramMetric", numbers[0]);
        }
    }

    private MetricMonitorXmlModel getXmlModel() {
        return this.monitorModel.getXmlModel();
    }

    /*
     * Exception decompiling
     */
    public String getContent(HttpServletRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String service(HttpServletRequest request, String action, Map parameters) throws BIReportException {
        if ("getDimensionChildren".equalsIgnoreCase(action)) {
            return this.getDimensionChildren(request);
        }
        if ("changeDimensionMember".equalsIgnoreCase(action)) {
            this.changeDimensionMember(request);
            return "";
        }
        if ("drillDown".equalsIgnoreCase(action)) {
            return this.drillDown(request);
        }
        throw new BIReportException("\u672a\u77e5\u8bf7\u6c42\uff1a" + action);
    }

    public String[] enumTypes() {
        return CONDITION_TYPE;
    }

    private String drillDown(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer();
        List dimList = null;
        try {
            String kpiMonitorId = request.getParameter("kpiMonitorId");
            String kpiMonitorType = request.getParameter("kpiMonitorType");
            String kpiMonitorNumber = request.getParameter("kpiMonitorNumber");
            dimList = KPIMonitorUtil.getShowList(this._mapOrgFilterTree, kpiMonitorId, kpiMonitorType, kpiMonitorNumber);
        }
        catch (KPIMonitorException e) {
            log.error((Object)"\u67e5\u8be2\u6570\u636e\u5e93\u51fa\u9519\uff01", (Throwable)e);
        }
        sb.append(BEGIN_NO_QUOTE);
        int n = dimList.size();
        for (int i = 0; i < n; ++i) {
            sb.append("'").append(dimList.get(i)).append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        if (dimList.size() > 0) {
            sb.append(END_NO_QUOTE);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDimensionChildren(HttpServletRequest request) {
        String dimType = request.getParameter(PARAM_DIMENSION);
        String nodeValue = request.getParameter("nodeValue");
        StringBuffer sb = new StringBuffer();
        if (CONDITION_KEY_ORG.equalsIgnoreCase(dimType)) {
            String dimInfo = null;
            try {
                dimInfo = KPIMonitorUtil.getDimInfo(this._mapOrgFilterTree, dimType, nodeValue);
            }
            catch (KPIMonitorException e) {
                log.error((Object)"\u67e5\u8be2\u6570\u636e\u5e93\u51fa\u9519\uff01", (Throwable)e);
            }
            return dimInfo;
        }
        if (CONDITION_KEY_YEAR.equalsIgnoreCase(dimType)) {
            String dimInfo = null;
            try {
                dimInfo = KPIMonitorUtil.getDimInfo(this._mapYearFilterTree, dimType, nodeValue);
            }
            catch (KPIMonitorException e) {
                log.error((Object)"\u67e5\u8be2\u6570\u636e\u5e93\u51fa\u9519\uff01", (Throwable)e);
            }
            return dimInfo;
        }
        if (CONDITION_KEY_PERIOD.equalsIgnoreCase(dimType)) {
            String dimInfo = null;
            try {
                dimInfo = KPIMonitorUtil.getDimInfo(this._mapPeriodFilterTree, dimType, nodeValue);
            }
            catch (KPIMonitorException e) {
                log.error((Object)"\u67e5\u8be2\u6570\u636e\u5e93\u51fa\u9519\uff01", (Throwable)e);
            }
            return dimInfo;
        }
        return sb.toString();
    }

    private void changeDimensionMember(HttpServletRequest request) throws BIReportException {
        String dim = null;
        String[] numbers = null;
        String[] filter = request.getParameterValues("filter");
        if (filter != null) {
            List<String> filterList = Arrays.asList(filter);
            String dimConditionString2 = null;
            String[] dimConditionArray = null;
            String dimCondition2 = null;
            for (String dimConditionString2 : filterList) {
                for (String dimCondition2 : dimConditionString2.split(" and ")) {
                    int index = dimCondition2.indexOf("=");
                    if (index <= 0) continue;
                    dim = dimCondition2.substring(0, index).trim();
                    String temp = dimCondition2.substring(index + 1, dimCondition2.length()).trim();
                    numbers = new String[]{temp};
                    if (temp.indexOf(",") > 0) {
                        this.globalMessage = "\u6307\u6807\u76d1\u63a7\u4e0d\u652f\u6301\u591a\u9009\uff01";
                        return;
                    }
                    this.setCondition(request, dim, numbers);
                }
            }
        } else {
            dim = request.getParameter(PARAM_DIMENSION);
            numbers = request.getParameterValues(PARAM_MEMBERS);
            this.setCondition(request, dim, numbers);
        }
    }

    private Map getDefaultConditionMap(HttpServletRequest request) throws BIReportException {
        HashMap<String, TreeMap> caches = new HashMap<String, TreeMap>();
        caches.put(CONDITION_KEY_ORG, this._mapOrgFilter);
        caches.put(CONDITION_KEY_YEAR, this._mapYearFilter);
        caches.put(CONDITION_KEY_PERIOD, this._mapPeriodFilter);
        Map DefaultConditionMap = null;
        try {
            String currentOrg = BISystem.getCurrentOrgUnit((HttpServletRequest)request).getNumber();
            DefaultConditionMap = KPIMonitorUtil.getDefaultCondition(request, caches, this.appModel, this.kpiMonitorId, this.getXmlModel(), currentOrg);
        }
        catch (KPIMonitorException e) {
            log.error((Object)("\u6307\u6807\u76d1\u63a7\u6761\u4ef6\u533a\u53d6\u5f97\u7ef4\u5ea6\u540d\u51fa\u9519\uff1a" + e.getMessage()));
            throw new BIReportException((Throwable)e);
        }
        catch (BIReportException e) {
            log.error((Object)("\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u7f16\u7801\u51fa\u9519\uff1a" + e.getMessage()));
            throw e;
        }
        return DefaultConditionMap == null ? new HashMap() : DefaultConditionMap;
    }

    private void initCondition(HttpServletRequest request) throws BIReportException {
        Map DefaultConditionMap = this.getDefaultConditionMap(request);
        String monitorType = request.getParameter("kpiMonitorType");
        String paramOrgId = (String)DefaultConditionMap.get("paramOrg");
        String paramYearId = (String)DefaultConditionMap.get("paramYear");
        String paramPeriodId = (String)DefaultConditionMap.get("paramPeriod");
        String paramMetricId = request.getParameter(CONDITION_KEY_METRIC);
        if (StringUtils.isEmpty((String)monitorType) || !CONDITION_KEY_ORG.equals(monitorType)) {
            HashMap<String, Object> mapOrg = new HashMap<String, Object>();
            mapOrg.put("title", "\u7ec4\u7ec7");
            mapOrg.put(PARAM_DIMENSION, CONDITION_KEY_ORG);
            mapOrg.put("type", "single");
            mapOrg.put("canChange", this.getXmlModel().getCanShowOrgFilter());
            mapOrg.put("canDisplay", this.getXmlModel().getCanDispalyOrg());
            mapOrg.put("defaultValue", paramOrgId);
            mapOrg.put("defaultCaption", this._mapOrgFilter.get(paramOrgId));
            this.mapConditionParms.put(CONDITION_KEY_ORG, mapOrg);
            this.mapConditionIds.put("paramOrg", paramOrgId);
        }
        HashMap<String, Object> mapYear = new HashMap<String, Object>();
        mapYear.put("title", "\u5e74");
        mapYear.put(PARAM_DIMENSION, CONDITION_KEY_YEAR);
        mapYear.put("type", "single");
        mapYear.put("canChange", this.getXmlModel().getCanShowYearFilter());
        mapYear.put("canDisplay", this.getXmlModel().getCanDispalyYear());
        mapYear.put("defaultValue", paramYearId);
        mapYear.put("defaultCaption", this._mapYearFilter.get(paramYearId));
        this.mapConditionParms.put(CONDITION_KEY_YEAR, mapYear);
        this.mapConditionIds.put("paramYear", paramYearId);
        HashMap<String, Object> mapPeriod = new HashMap<String, Object>();
        mapPeriod.put("title", "\u671f\u95f4");
        mapPeriod.put(PARAM_DIMENSION, CONDITION_KEY_PERIOD);
        mapPeriod.put("type", "single");
        mapPeriod.put("canChange", this.getXmlModel().getCanShowPeriodFilter());
        mapPeriod.put("canDisplay", this.getXmlModel().getCanDispalyPeriod());
        mapPeriod.put("defaultValue", paramPeriodId);
        mapPeriod.put("defaultCaption", this._mapPeriodFilter.get(paramPeriodId));
        this.mapConditionParms.put(CONDITION_KEY_PERIOD, mapPeriod);
        this.mapConditionIds.put("paramPeriod", paramPeriodId);
        if (!StringUtils.isEmpty((String)monitorType) && !StringUtils.isEmpty((String)paramMetricId)) {
            HashMap<String, String> mapMetric = new HashMap<String, String>();
            mapMetric.put("title", "\u6307\u6807");
            mapMetric.put(PARAM_DIMENSION, CONDITION_KEY_METRIC);
            mapMetric.put("type", "single");
            mapMetric.put("canChange", "false");
            mapMetric.put("canDisplay", "true");
            mapMetric.put("defaultValue", paramMetricId);
            mapMetric.put("defaultCaption", (String)this._mapMetricFilter.get(paramMetricId));
            this.mapConditionParms.put(CONDITION_KEY_METRIC, mapMetric);
            this.mapConditionIds.put("paramMetric", paramMetricId);
        }
    }
}

