/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.schedule;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.rt.appmodel.DataRuleSchema;
import com.kingdee.bos.bi.model.rt.log.ScheduleLogger;
import com.kingdee.bos.bi.model.rt.schedule.ScheduleItem;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.JDOMException;

public class Schedule {
    private static final Logger log = CommonLogger.getLogger(Schedule.class);
    private String id;
    private List scheduleItems = new ArrayList();

    private Schedule(String id, List l) {
        this.id = id;
        this.scheduleItems = l;
    }

    public static Schedule fromScheduleItems(List lstItems, Connection cn, Context ctx) throws SQLException, IOException, JDOMException {
        Iterator it = lstItems.iterator();
        ArrayList<ScheduleItem> items = new ArrayList<ScheduleItem>();
        while (it.hasNext()) {
            Map map = (Map)it.next();
            String failtStrategy = (String)map.get("FailStrategy");
            String periodCalcRule = (String)map.get("PeriodCalcRule");
            String amid = (String)map.get("amid");
            String drsid = (String)map.get("drschemaid");
            DataRuleSchema drs = DataRuleSchema.fromDB(amid, drsid, cn, ctx);
            ScheduleItem scheduleItem = new ScheduleItem(drs, failtStrategy, "", periodCalcRule);
            items.add(scheduleItem);
        }
        return new Schedule("", items);
    }

    public static Schedule fromDB(String id, Connection cn, Context ctx) throws SQLException, IOException, JDOMException {
        ArrayList<ScheduleItem> items = new ArrayList<ScheduleItem>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "select FAMID,FDRSchemaID,FFailStrategy,FQuartsExp,FPeriodCalcRule from T_BI_Schedule_Detail where FID='" + id + "' order by FOrder ASC";
        stmt = cn.prepareStatement(sql);
        rs = stmt.executeQuery();
        while (rs.next()) {
            String failtStrategy = rs.getString("FFailStrategy");
            String quartsExp = rs.getString("FQuartsExp");
            String periodCalcRule = rs.getString("FPeriodCalcRule");
            String amid = rs.getString("FAMID");
            String drsid = rs.getString("FDRSchemaID");
            DataRuleSchema drs = DataRuleSchema.fromDB(amid, drsid, cn, ctx);
            ScheduleItem scheduleItem = new ScheduleItem(drs, failtStrategy, quartsExp, periodCalcRule);
            items.add(scheduleItem);
        }
        return new Schedule(id, items);
    }

    public void run(Date date, Connection cn, Context ctx, Map mapData, ScheduleLogger sLog) {
        for (ScheduleItem item : this.scheduleItems) {
            item.run(date, cn, ctx, mapData, sLog);
        }
    }

    public void run(String userId, Date start, Date end, Connection cn, Context ctx, ScheduleLogger sLog) {
        if (start.compareTo(end) > 0) {
            Date temp = start;
            start = end;
            end = temp;
        }
        Calendar c = Calendar.getInstance();
        Calendar cStart = Calendar.getInstance();
        cStart.setTime(start);
        Calendar cEnd = Calendar.getInstance();
        cEnd.setTime(end);
        int endMonth = cEnd.get(2);
        int startMonth = cStart.get(2);
        boolean runFlag = false;
        c.setTime(start);
        while (c.getTime().compareTo(end) <= 0) {
            Date calcDate = c.getTime();
            int month = c.get(2);
            if (month == endMonth && c.get(1) == cEnd.get(1)) {
                calcDate = end;
            } else if (month == startMonth && c.get(1) == cStart.get(1)) {
                calcDate = start;
            } else {
                calcDate.setDate(1);
            }
            HashMap mapData = new HashMap();
            runFlag = true;
            this.run(calcDate, cn, ctx, mapData, sLog);
            c.add(2, 1);
        }
        try {
            if (runFlag) {
                sLog.commit(cn);
            }
        }
        catch (SQLException e) {
            log.error((Object)"\u5199\u65e5\u5fd7\u4e0d\u6210\u529f", (Throwable)e);
        }
    }
}

