/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.security;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.EnumObj;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.security.Logic;
import com.kingdee.bos.bi.model.security.SecureFilterItem;
import com.kingdee.bos.bi.model.security.ui.ExprException;
import com.kingdee.bos.bi.model.util.Calculator;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;

public class SecureFilterItems
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List filterItems;

    public SecureFilterItems(List l) {
        this.filterItems = l;
    }

    public List getItems() {
        return this.filterItems;
    }

    public String toString() {
        StringBuffer xb = new StringBuffer();
        Iterator it = this.filterItems.iterator();
        boolean isFirst = true;
        while (it.hasNext()) {
            SecureFilterItem item = (SecureFilterItem)it.next();
            if (isFirst) {
                isFirst = false;
            } else {
                xb.append("\n");
            }
            xb.append(item.getInfo());
        }
        return xb.toString();
    }

    public Object clone() {
        ArrayList<Object> newList = new ArrayList<Object>();
        for (SecureFilterItem item : this.filterItems) {
            newList.add(item.clone());
        }
        return new SecureFilterItems(newList);
    }

    public static SecureFilterItems fromNode(Element e, DimensionMeta dm) {
        ArrayList<SecureFilterItem> filterItems = new ArrayList<SecureFilterItem>();
        List lstItem = e.getChildren("item");
        for (Element ele : lstItem) {
            SecureFilterItem filterItem = SecureFilterItem.fromNode(ele, dm);
            filterItems.add(filterItem);
        }
        return new SecureFilterItems(filterItems);
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        for (SecureFilterItem sfi : this.filterItems) {
            sb.append(sfi.toXML());
        }
        return sb.toString();
    }

    public String toSql(Context ctx) {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.filterItems.iterator();
        EnumObj logic = null;
        while (it.hasNext()) {
            if (logic != null && !StringUtils.isEmpty((String)logic.getName())) {
                sb.append(" " + logic.getName() + " ");
            }
            SecureFilterItem item = (SecureFilterItem)it.next();
            sb.append(item.toSql(ctx));
            logic = item.getLogic();
        }
        return sb.toString();
    }

    public void verify() throws ExprException {
        Iterator it = this.filterItems.iterator();
        int matchP = 0;
        while (it.hasNext()) {
            SecureFilterItem item = (SecureFilterItem)it.next();
            matchP += item.leftP.getCount();
            if ((matchP -= item.rightP.getCount()) >= 0) continue;
            throw new ExprException("\u5de6\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff01");
        }
        if (matchP != 0) {
            throw new ExprException("\u5de6\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff01");
        }
    }

    public boolean match(Object value, Dimension dm, Connection cn) throws SQLException {
        Iterator it = this.filterItems.iterator();
        StringBuffer sbExpr = new StringBuffer();
        boolean isFirstItem = true;
        Logic logicOld = null;
        while (it.hasNext()) {
            if (isFirstItem) {
                isFirstItem = false;
            } else if (logicOld != null) {
                String opr = "";
                opr = logicOld.equals(Logic.and) ? "*" : "+";
                sbExpr.append(opr);
            }
            SecureFilterItem item = (SecureFilterItem)it.next();
            sbExpr.append(item.getLeftP().toString());
            if (item.match(value, dm, cn)) {
                sbExpr.append("1");
            } else {
                sbExpr.append("0");
            }
            sbExpr.append(item.getRightP().toString());
            logicOld = item.getLogic();
        }
        double ret = new Calculator(sbExpr.toString()).Calc();
        return ret > 0.0;
    }

    public boolean matchMeasure(Number value) {
        if (this.filterItems == null || this.filterItems.size() == 0 || value == null) {
            return true;
        }
        Iterator it = this.filterItems.iterator();
        StringBuffer sbExpr = new StringBuffer();
        boolean isFirstItem = true;
        Logic logicOld = null;
        while (it.hasNext()) {
            if (isFirstItem) {
                isFirstItem = false;
            } else if (logicOld != null) {
                String opr = "";
                opr = logicOld.equals(Logic.and) ? "*" : "+";
                sbExpr.append(opr);
            }
            SecureFilterItem item = (SecureFilterItem)it.next();
            sbExpr.append(item.getLeftP().toString());
            BigDecimal v = new BigDecimal(item.value.toString());
            if (item.op.match(value, v)) {
                sbExpr.append("1");
            } else {
                sbExpr.append("0");
            }
            sbExpr.append(item.getRightP().toString());
            logicOld = item.getLogic();
        }
        double ret = new Calculator(sbExpr.toString()).Calc();
        return ret > 0.0;
    }
}

