/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.bireport.property.tree;

import com.kingdee.bos.bi.model.common.bireport.layout.ComponentProperty;
import com.kingdee.bos.bi.model.common.bireport.property.bean.BIReportBean;
import com.kingdee.bos.bi.model.common.bireport.property.config.factory.BIReportPropertyConfigFactory;
import com.kingdee.bos.bi.model.commonui.contentree.panel.content.impl.DefaultLeafContent;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.BeanInfoFactory;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.ExtendedPropertyDescriptor;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.IProperty;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.PropertyDescriptorAdapter;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.PropertySheetPanel;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.PropertySheetTable;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Component;
import java.awt.Container;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class AbstractBIReportContent
extends DefaultLeafContent {
    protected PropertySheetPanel propertySheetPanel = null;
    protected DefaultKingdeeTreeNode node = null;
    protected String componentType = null;
    protected BIReportBean bean = null;

    public AbstractBIReportContent(BIReportBean bean, String componentType) {
        super("BIReport");
        this.componentType = componentType;
        this.bean = bean;
    }

    public void setNode(DefaultKingdeeTreeNode node) {
        this.node = node;
    }

    @Override
    public void installComponents(Container panel) {
        if (StringUtil.equalsIgnoreCase("bireport", this.componentType) || StringUtil.equalsIgnoreCase("chart", this.componentType) || StringUtil.equalsIgnoreCase("worksheet", this.componentType)) {
            panel.add(this.getPropertySheetPanel());
        } else {
            super.installComponents(panel);
        }
    }

    public BIReportBean getBean() {
        return this.bean;
    }

    protected Component getPropertySheetPanel() {
        if (this.propertySheetPanel == null) {
            final PropertySheetTable table = new PropertySheetTable();
            table.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    int col = table.getSelectedColumn();
                    int row = table.getSelectedRow();
                    table.editCellAt(row, col);
                }
            });
            this.propertySheetPanel = new PropertySheetPanel(table);
            this.propertySheetPanel.setMode(1);
            this.propertySheetPanel.setDescriptionVisible(true);
            PropertySheetPanelListener l = new PropertySheetPanelListener();
            l.propertySheetPanel = this.propertySheetPanel;
            this.propertySheetPanel.addPropertySheetChangeListener(l);
            l.bean = this.bean;
            BeanInfo info = new BeanInfoFactory().getBeanInfo(BIReportBean.class, this.componentType);
            this.propertySheetPanel.setBeanInfo(info);
            this.propertySheetPanel.readFromObject(this.getBean());
        }
        return this.propertySheetPanel;
    }

    public void initBean() {
        try {
            List cpList = BIReportPropertyConfigFactory.getBIReportPropertyList(this.componentType);
            if (null != cpList) {
                for (ComponentProperty property : cpList) {
                    String key = property.getName();
                    this.bean.containsKey(key);
                    this.bean.putProp(key, property.getDefaultValue());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return StringUtil.isEmpty(this.bean.toString()) ? "\u672a\u547d\u540d" : this.bean.toString();
    }

    private class PropertySheetPanelListener
    implements PropertyChangeListener {
        PropertySheetPanel propertySheetPanel;
        Object bean;

        private PropertySheetPanelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            IProperty prop = (IProperty)evt.getSource();
            try {
                prop.writeToObject(this.bean);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof PropertyVetoException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(this.propertySheetPanel);
                    prop.setValue(evt.getOldValue());
                }
                throw e;
            }
            PropertyDescriptorAdapter propAdapter = (PropertyDescriptorAdapter)evt.getSource();
            ExtendedPropertyDescriptor propDescriptor = (ExtendedPropertyDescriptor)((Object)propAdapter.getDescriptor());
            propDescriptor.fireEditValueChanged(this.bean);
            AbstractBIReportContent.this.node.setText(this.bean.toString());
        }
    }
}

