/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.commonfilter;

import com.kingdee.bos.bi.model.common.mm.ComboBoxObject;
import com.kingdee.bos.bi.model.common.mm.commonfilter.CommonFilterEnum;
import com.kingdee.bos.bi.model.common.mm.commonfilter.CommonFilterModel;
import com.kingdee.bos.bi.model.common.mm.general.db.Column;
import com.kingdee.bos.bi.model.common.mm.general.importscheme.SchemeChecking;
import com.kingdee.bos.bi.model.common.mm.time.TimeUtil;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class CommonFilterPane {
    private static final Logger log = LogUtil.getPackageLogger(CommonFilterPane.class);
    private List commonFilterModelList = null;
    private KDTabbedPane tabMain;
    private KDPanel filterPan;
    private KDTable filterTbl;
    private KDButton filterBtnAdd;
    private KDButton filterBtnDel;
    private KDPanel filterTopLeftCornerPan;
    private KDPanel sortPan;
    private KDTable sortTbl;
    private KDButton sortBtnUp;
    private KDButton sortBtnDown;
    private Vector leftParenthesisVector;
    private Vector filterFieldVector;
    private Vector compareOperatorVector_charType;
    private Vector compareOperatorVector_scalarType;
    private Vector rightParenthesisVector;
    private Vector logicOperatorVector;
    public boolean isAutoResize = true;
    private Vector sortOptionVector;
    private int currFilterRow = -1;
    private Map initParms;

    public Component getFilterPane(boolean isSortEnable) {
        this.loadAllComboBoxIteams();
        if (isSortEnable) {
            return this.getTabMain();
        }
        return this.getFilterPan();
    }

    public void initCommonFilterTable(List commonFilterModelList) {
        this.setCommonFilterModelList(commonFilterModelList);
        if (commonFilterModelList != null) {
            this.getFilterTbl().removeRows();
            int n = commonFilterModelList.size();
            for (int i = 0; i < n; ++i) {
                this.currFilterRow = i;
                this.action_AddFilter((CommonFilterModel)commonFilterModelList.get(i));
                this.action_filterFieldChanged((CommonFilterModel)commonFilterModelList.get(i));
            }
        }
    }

    public String getCommonCondition() {
        StringBuffer condition = new StringBuffer();
        if (this.checkFilterTblBeforeCall()) {
            String filterParams = this.getFilterParameters();
            String sortrParams = this.getSortParameters();
            if (filterParams != null && filterParams.length() > 0) {
                condition.append(" where ").append(filterParams);
            }
            if (sortrParams != null && sortrParams.length() > 0) {
                condition.append(" order by ").append(sortrParams);
            }
        }
        return condition.toString();
    }

    public boolean checkBeforReturn() {
        return this.checkFilterTblBeforeCall();
    }

    public List getCommonFilterModelList() {
        ArrayList<CommonFilterModel> list = new ArrayList<CommonFilterModel>();
        IRow row = null;
        String left = null;
        Column field = null;
        String compare = null;
        String value = null;
        String right = null;
        String logic = null;
        boolean isNumeric = false;
        int n = this.filterTbl.getRowCount();
        for (int r = 0; r < n; ++r) {
            row = this.filterTbl.getRow(r);
            left = ((ComboBoxObject)row.getCell("left").getValue()).getCode();
            field = (Column)row.getCell("filterIteam").getValue();
            compare = ((ComboBoxObject)row.getCell("compareOperator").getValue()).getCode();
            value = SchemeChecking.matcheToDateTime(field.getJdbcType()) == 1 ? TimeUtil.getTime((Date)row.getCell("compareValue").getValue()) : (String)row.getCell("compareValue").getValue();
            isNumeric = SchemeChecking.matcheToInt(field.getJdbcType()) == 1 || SchemeChecking.matcheToDecimal(field.getJdbcType()) == 1;
            right = ((ComboBoxObject)row.getCell("right").getValue()).getCode();
            logic = ((ComboBoxObject)row.getCell("logicOperator").getValue()).getCode();
            list.add(new CommonFilterModel(left, field.getName(), compare, value, right, logic, isNumeric));
        }
        return list;
    }

    private void setCommonFilterModelList(List commonFilterModelList) {
        this.commonFilterModelList = commonFilterModelList;
    }

    public void setFilterFieldVector(Vector filterFieldIteams) {
        this.filterFieldVector = filterFieldIteams;
    }

    public Container geTopLeftCornerPan() {
        return this.getFilterTopLeftCornerPan();
    }

    public void SetAutoResize(boolean isAutoResize) {
        this.isAutoResize = isAutoResize;
    }

    private void loadAllComboBoxIteams() {
        if (this.filterFieldVector == null) {
            this.filterFieldVector = new Vector();
            this.filterFieldVector.add(new ComboBoxObject("AppModelEnum.PUBLISH_FILTER_YEAR", "\u5b57\u6bb51"));
            this.filterFieldVector.add(new ComboBoxObject("AppModelEnum.PUBLISH_FILTER_PERIOD", "\u5b57\u6bb52"));
            this.filterFieldVector.add(new ComboBoxObject("AppModelEnum.PUBLISH_FILTER_ORG", "\u5b57\u6bb53"));
            this.filterFieldVector.add(new ComboBoxObject("AppModelEnum.PUBLISH_FILTER_METRIC", "\u5b57\u6bb54"));
        }
        this.leftParenthesisVector = CommonFilterEnum.getLeftParenthesisVector();
        this.compareOperatorVector_charType = CommonFilterEnum.getComparisonOperatorVector("varchar");
        this.compareOperatorVector_scalarType = CommonFilterEnum.getComparisonOperatorVector("scalar");
        this.logicOperatorVector = CommonFilterEnum.getLogicalOperatorVector();
        this.rightParenthesisVector = CommonFilterEnum.getRightParenthesisVector();
        this.sortOptionVector = CommonFilterEnum.getSortOptionVector();
    }

    private Component getTabMain() {
        if (this.tabMain == null) {
            this.tabMain = new KDTabbedPane();
            this.tabMain.setViewStyle(1);
            this.tabMain.addTab("\u8fc7\u6ee4", this.getFilterPan());
            this.tabMain.addTab("\u6392\u5e8f", this.getSortPan());
        }
        return this.tabMain;
    }

    private Component getFilterPan() {
        if (this.filterPan == null) {
            this.filterPan = new KDPanel();
            TableLayout2 tly = new TableLayout2(2, 3);
            tly.setRowsSpacing(TableLayout2.ALL, 8);
            tly.setColsSpacing(TableLayout2.ALL, 8);
            tly.setFixedWidth(new int[]{1, 2}, 73);
            tly.setRatableWidth(0, 100);
            tly.setFixedHeight(0, 21);
            tly.setRatableHeight(1, 100);
            this.filterPan.setLayout((LayoutManager)tly);
            this.filterPan.add((Component)this.getFilterTopLeftCornerPan(), (Object)TableLayout2.param((int)0, (int)0));
            this.filterPan.add(this.getFilterBtnAdd(), (Object)TableLayout2.param((int)0, (int)1));
            this.filterPan.add(this.getFilterBtnDel(), (Object)TableLayout2.param((int)0, (int)2));
            this.filterPan.add((Component)this.getFilterTbl(), (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)2));
        }
        return this.filterPan;
    }

    private KDTable getFilterTbl() {
        if (this.filterTbl == null) {
            this.filterTbl = new KDTable();
            String[] columnKeys = new String[]{"left", "filterIteam", "compareOperator", "compareValue", "right", "logicOperator"};
            Object[] headNames = new String[]{"\u5de6\u62ec\u53f7", "\u8fc7\u6ee4\u5b57\u6bb5", "\u6bd4\u8f83\u7b26", "\u6bd4\u8f83\u503c", "\u53f3\u62ec\u53f7", "\u903b\u8f91\u7b26"};
            Object[][] bodyDatas = null;
            KDTableHelper.initTable((KDTable)this.filterTbl, (String[])columnKeys, (Object[])headNames, (Object[][])bodyDatas);
            KDTableHelper.updateEnterWithTab((KDTable)this.filterTbl, (boolean)false);
            this.handleFilterWidth();
            this.filterTbl.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                public void editStarting(KDTEditEvent e) {
                    CommonFilterPane.this.currFilterRow = e.getRowIndex();
                }
            });
        }
        return this.filterTbl;
    }

    private void handleFilterWidth() {
        if (this.isAutoResize) {
            this.filterTbl.setAutoResize(true);
        } else {
            IColumn column = null;
            int n = this.filterTbl.getColumnCount();
            for (int i = 0; i < n; ++i) {
                column = this.filterTbl.getColumn(i);
                if ("filterIteam".equalsIgnoreCase(column.getKey())) {
                    column.setWidth(100);
                    continue;
                }
                if ("compareValue".equalsIgnoreCase(column.getKey())) {
                    column.setWidth(90);
                    continue;
                }
                column.setWidth(45);
            }
        }
    }

    private Container getFilterTopLeftCornerPan() {
        if (this.filterTopLeftCornerPan == null) {
            this.filterTopLeftCornerPan = new KDPanel();
        }
        return this.filterTopLeftCornerPan;
    }

    private Component getFilterBtnAdd() {
        if (this.filterBtnAdd == null) {
            this.filterBtnAdd = new KDButton("\u589e\u52a0");
            this.filterBtnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CommonFilterPane.this.action_AddFilter(null);
                }
            });
        }
        return this.filterBtnAdd;
    }

    private void action_AddFilter(CommonFilterModel commonFilterModel) {
        IRow row = this.getFilterTbl().addRow();
        KDComboBox leftCbxIteam = new KDComboBox(this.leftParenthesisVector);
        if (commonFilterModel != null) {
            for (ComboBoxObject obj : this.leftParenthesisVector) {
                if (!obj.getCode().equalsIgnoreCase(commonFilterModel.getLeft())) continue;
                leftCbxIteam.setSelectedItem((Object)obj);
                break;
            }
        }
        row.getCell("left").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)leftCbxIteam));
        row.getCell("left").setValue(leftCbxIteam.getSelectedItem());
        KDComboBox rightCbxIteam = new KDComboBox(this.rightParenthesisVector);
        if (commonFilterModel != null) {
            for (ComboBoxObject obj : this.rightParenthesisVector) {
                if (!obj.getCode().equalsIgnoreCase(commonFilterModel.getRight())) continue;
                rightCbxIteam.setSelectedItem((Object)obj);
                break;
            }
        }
        row.getCell("right").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)rightCbxIteam));
        row.getCell("right").setValue(rightCbxIteam.getSelectedItem());
        KDComboBox filterCbxLogic = new KDComboBox(this.logicOperatorVector);
        if (commonFilterModel != null) {
            for (ComboBoxObject obj : this.logicOperatorVector) {
                if (!obj.getCode().equalsIgnoreCase(commonFilterModel.getLogic())) continue;
                filterCbxLogic.setSelectedItem((Object)obj);
                break;
            }
        }
        row.getCell("logicOperator").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)filterCbxLogic));
        row.getCell("logicOperator").setValue(filterCbxLogic.getSelectedItem());
        KDComboBox filterCbxIteam = new KDComboBox(this.filterFieldVector);
        if (commonFilterModel != null) {
            for (Column obj : this.filterFieldVector) {
                if (!obj.getName().equalsIgnoreCase(commonFilterModel.getField())) continue;
                filterCbxIteam.setSelectedItem((Object)obj);
                break;
            }
        }
        row.getCell("filterIteam").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)filterCbxIteam));
        row.getCell("filterIteam").setValue(filterCbxIteam.getSelectedItem());
        filterCbxIteam.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CommonFilterPane.this.action_filterFieldChanged(null);
                }
            }
        });
    }

    private void action_filterFieldChanged(CommonFilterModel commonFilterModel) {
        Column field;
        IRow row = this.filterTbl.getRow(this.currFilterRow);
        Object obj = ((KDComboBox)row.getCell("filterIteam").getEditor().getComponent()).getSelectedItem();
        KDComboBox filterCbxCompareOperator = new KDComboBox();
        Vector compareOperatorVector = this.compareOperatorVector_scalarType;
        if (obj instanceof Column && SchemeChecking.matcheToInt((field = (Column)obj).getJdbcType()) == -1 && SchemeChecking.matcheToDecimal(field.getJdbcType()) == -1 && SchemeChecking.matcheToDateTime(field.getJdbcType()) == -1) {
            compareOperatorVector = this.compareOperatorVector_charType;
        }
        filterCbxCompareOperator.addItems(compareOperatorVector);
        if (commonFilterModel != null) {
            for (ComboBoxObject o : compareOperatorVector) {
                if (!o.getCode().equalsIgnoreCase(commonFilterModel.getCompare())) continue;
                filterCbxCompareOperator.setSelectedItem((Object)o);
                break;
            }
        }
        row.getCell("compareOperator").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)filterCbxCompareOperator));
        row.getCell("compareOperator").setValue(filterCbxCompareOperator.getSelectedItem());
        if (commonFilterModel != null) {
            row.getCell("compareValue").setValue((Object)commonFilterModel.getValue());
        }
        if (obj instanceof Column) {
            field = (Column)obj;
            if (SchemeChecking.matcheToDateTime(field.getJdbcType()) == 1) {
                KDDatePicker datePicker = new KDDatePicker();
                datePicker.setTimeEnabled(true);
                row.getCell("compareValue").setEditor((ICellEditor)new KDTDefaultCellEditor(datePicker));
                StyleAttributes style = Styles.getSA((StyleAttributes)row.getCell("compareValue").getStyleAttributes());
                style.setNumberFormat("yyyy-MM-dd HH:mm:ss.sss");
                row.getCell("compareValue").setStyleAttributes(style);
                if (commonFilterModel != null) {
                    Date date = null;
                    try {
                        date = TimeUtil.parse(commonFilterModel.getValue());
                    }
                    catch (ParseException e) {
                        log.error((Object)e);
                    }
                    row.getCell("compareValue").getEditor().setValue((Object)date);
                    row.getCell("compareValue").setValue((Object)date);
                }
            } else {
                row.getCell("compareValue").setEditor(null);
                row.getCell("compareValue").setValue(null);
                if (commonFilterModel != null) {
                    row.getCell("compareValue").setValue((Object)commonFilterModel.getValue());
                }
            }
        }
    }

    private Component getFilterBtnDel() {
        if (this.filterBtnDel == null) {
            this.filterBtnDel = new KDButton("\u5220\u9664");
            this.filterBtnDel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CommonFilterPane.this.action_DelFilter();
                }
            });
        }
        return this.filterBtnDel;
    }

    private void action_DelFilter() {
        if (!this.checkSelectFilterTbl(this.filterTbl)) {
            return;
        }
        ArrayList selectBlocks = this.filterTbl.getSelectManager().getBlocks();
        KDTSelectBlock selectBlock = null;
        int n = selectBlocks.size();
        for (int i = 0; i < n; ++i) {
            selectBlock = (KDTSelectBlock)selectBlocks.get(i);
            if (selectBlock.getTop() != selectBlock.getBottom()) {
                WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55\u5220\u9664\uff01", (String)this.getTitle(), (Component)this.getTabMain());
                return;
            }
            this.filterTbl.removeRow(selectBlock.getTop());
        }
    }

    private boolean checkSelectFilterTbl(KDTable table) {
        if (table.getRowCount() == 0 || table.getSelectManager().size() == 0) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\uff01", (String)this.getTitle(), (Component)table);
            return false;
        }
        return true;
    }

    private Component getSortPan() {
        if (this.sortPan == null) {
            this.sortPan = new KDPanel();
            TableLayout2 tly = new TableLayout2(2, 3);
            tly.setRowsSpacing(TableLayout2.ALL, 10);
            tly.setColsSpacing(TableLayout2.ALL, 10);
            tly.setFixedWidth(new int[]{1, 2}, 73);
            tly.setRatableWidth(0, 100);
            tly.setFixedHeight(0, 21);
            tly.setRatableHeight(1, 100);
            this.sortPan.setLayout((LayoutManager)tly);
            this.sortPan.add(this.getSortBtnUp(), (Object)TableLayout2.param((int)0, (int)1));
            this.sortPan.add(this.getSortBtnDown(), (Object)TableLayout2.param((int)0, (int)2));
            this.sortPan.add(this.getSortTbl(), (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)2));
        }
        return this.sortPan;
    }

    private Component getSortTbl() {
        if (this.sortTbl == null) {
            this.sortTbl = new KDTable();
            String[] columnKeys = new String[]{"sortCondition", "isSort", "sortOption"};
            Object[] headNames = new String[]{"\u6392\u5e8f\u5b57\u6bb5", "\u662f\u5426\u6392\u5e8f", "\u6392\u5e8f\u9009\u9879"};
            Object[][] bodyDatas = null;
            KDTableHelper.initTable((KDTable)this.sortTbl, (String[])columnKeys, (Object[])headNames, (Object[][])bodyDatas);
            this.sortTbl.setAutoResize(true);
            KDTableHelper.updateEnterWithTab((KDTable)this.sortTbl, (boolean)false);
            this.sortTbl.getColumn(1).setWidth(10);
            this.sortTbl.getColumn(2).setWidth(10);
            this.initSortTbl();
        }
        return this.sortTbl;
    }

    private void initSortTbl() {
        IRow row = null;
        Iterator it = this.filterFieldVector.iterator();
        ComboBoxObject obj = null;
        while (it.hasNext()) {
            obj = (ComboBoxObject)it.next();
            row = this.sortTbl.addRow();
            row.getCell("sortCondition").setValue((Object)obj);
            KDCheckBox sortChekBox = new KDCheckBox();
            row.getCell("isSort").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)sortChekBox));
            row.getCell("isSort").setValue((Object)false);
            KDComboBox sortComBox = new KDComboBox(this.sortOptionVector);
            row.getCell("sortOption").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)sortComBox));
            row.getCell("sortOption").setValue(sortComBox.getSelectedItem());
        }
        this.sortTbl.getColumn(0).getStyleAttributes().setLocked(true);
    }

    private Component getSortBtnUp() {
        if (this.sortBtnUp == null) {
            this.sortBtnUp = new KDButton("\u4e0a\u79fb");
            this.sortBtnUp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CommonFilterPane.this.action_UpSort();
                }
            });
        }
        return this.sortBtnUp;
    }

    private void action_UpSort() {
        if (!this.checkSelectFilterTbl(this.sortTbl)) {
            return;
        }
        ArrayList selectBlocks = this.sortTbl.getSelectManager().getBlocks();
        KDTSelectBlock selectBlock = null;
        int rowIndex = -1;
        IRow row = null;
        for (int i = 0; i < selectBlocks.size(); ++i) {
            selectBlock = (KDTSelectBlock)selectBlocks.get(i);
            if (selectBlock.getTop() != selectBlock.getBottom()) {
                WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55\u79fb\u52a8\uff01", (String)this.getTitle(), (Component)this.getTabMain());
                break;
            }
            if (this.sortTbl.getRowCount() == rowIndex) {
                return;
            }
            rowIndex = selectBlock.getTop();
            if (rowIndex == -1 || rowIndex == 0) {
                return;
            }
            int targetRowIndex = rowIndex - 1;
            row = this.sortTbl.removeRow(rowIndex);
            this.sortTbl.addRow(targetRowIndex, row);
            this.sortTbl.getSelectManager().setActiveRowIndex(targetRowIndex);
            this.sortTbl.getSelectManager().select(targetRowIndex, 0);
        }
    }

    private Component getSortBtnDown() {
        if (this.sortBtnDown == null) {
            this.sortBtnDown = new KDButton("\u4e0b\u79fb");
            this.sortBtnDown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CommonFilterPane.this.action_DownSort();
                }
            });
        }
        return this.sortBtnDown;
    }

    private void action_DownSort() {
        if (!this.checkSelectFilterTbl(this.sortTbl)) {
            return;
        }
        ArrayList selectBlocks = this.sortTbl.getSelectManager().getBlocks();
        KDTSelectBlock selectBlock = null;
        int rowIndex = -1;
        IRow row = null;
        int n = selectBlocks.size();
        for (int i = 0; i < n; ++i) {
            selectBlock = (KDTSelectBlock)selectBlocks.get(i);
            if (selectBlock.getTop() != selectBlock.getBottom()) {
                WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55\u79fb\u52a8\uff01", (String)this.getTitle(), (Component)this.getTabMain());
                break;
            }
            if (this.sortTbl.getRowCount() == rowIndex) {
                return;
            }
            rowIndex = selectBlock.getTop();
            if (rowIndex == -1 || rowIndex == this.sortTbl.getRowCount() - 1) {
                return;
            }
            int targetRowIndex = rowIndex + 1;
            row = this.sortTbl.removeRow(rowIndex);
            this.sortTbl.addRow(targetRowIndex, row);
            this.sortTbl.getSelectManager().setActiveRowIndex(targetRowIndex);
            this.sortTbl.getSelectManager().select(targetRowIndex, 0);
        }
    }

    private boolean checkFilterTblBeforeCall() {
        int r;
        IRow row = null;
        Object obj = null;
        Column field = null;
        StringBuffer parenthesisChecker = new StringBuffer();
        int n = r = this.filterTbl.getRowCount() - 1;
        while (r >= 0) {
            row = this.filterTbl.getRow(r);
            obj = row.getCell("left").getValue();
            parenthesisChecker.append(((ComboBoxObject)obj).getCode());
            obj = row.getCell("right").getValue();
            parenthesisChecker.append(((ComboBoxObject)obj).getCode());
            obj = row.getCell("filterIteam").getValue();
            field = (Column)obj;
            if (obj == null) {
                WindowUtil.msgboxInfo((Object)("\u7b2c" + (r + 1) + "\u884c\uff0c\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u5b8c\u6574\uff0c\u8fc7\u6ee4\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (String)this.getTitle(), (Component)this.getFilterPan());
                return false;
            }
            obj = row.getCell("compareOperator").getValue();
            if (obj == null) {
                WindowUtil.msgboxInfo((Object)("\u7b2c" + (r + 1) + "\u884c\uff0c\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u5b8c\u6574\uff0c\u6bd4\u8f83\u7b26\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (String)this.getTitle(), (Component)this.getFilterPan());
                return false;
            }
            obj = row.getCell("compareValue").getValue();
            if (obj == null) {
                WindowUtil.msgboxInfo((Object)("\u7b2c" + (r + 1) + "\u884c\uff0c\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u5b8c\u6574\uff0c\u6bd4\u8f83\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (String)this.getTitle(), (Component)this.getFilterPan());
                return false;
            }
            if (SchemeChecking.matcheToInt(field.getJdbcType()) == 1) {
                if (!StringUtil.isInteger((String)obj)) {
                    WindowUtil.msgboxInfo((Object)("\u7b2c" + (r + 1) + "\u884c\uff0c\u6bd4\u8f83\u503c\u53ea\u80fd\u662f\u6574\u6570\uff01"), (String)this.getTitle(), (Component)this.getFilterPan());
                    return false;
                }
            } else if (SchemeChecking.matcheToDecimal(field.getJdbcType()) == 1 && !StringUtil.isDecimal((String)obj)) {
                WindowUtil.msgboxInfo((Object)("\u7b2c" + (r + 1) + "\u884c\uff0c\u6bd4\u8f83\u503c\u53ea\u80fd\u662f\u5c0f\u6570\uff01"), (String)this.getTitle(), (Component)this.getFilterPan());
                return false;
            }
            obj = row.getCell("logicOperator").getValue();
            if (r == n) {
                if (CommonFilterEnum.BLANK_COMBOBOXOBJECT != obj) {
                    WindowUtil.msgboxInfo((Object)("\u7b2c" + (r + 1) + "\u884c\uff0c\u903b\u8f91\u7b26\u591a\u4f59\uff01"), (String)this.getTitle(), (Component)this.getFilterPan());
                    return false;
                }
            } else if (CommonFilterEnum.BLANK_COMBOBOXOBJECT == obj) {
                WindowUtil.msgboxInfo((Object)("\u7b2c" + (r + 1) + "\u884c\uff0c\u7f3a\u5c11\u903b\u8f91\u7b26\uff01"), (String)this.getTitle(), (Component)this.getFilterPan());
                return false;
            }
            --r;
        }
        if (parenthesisChecker.length() > 0) {
            if (parenthesisChecker.indexOf("(") != 0) {
                WindowUtil.msgboxInfo((Object)"\u5de6\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff1a\u4e0d\u80fd\u4ee5\u3010)\u3011\u5f00\u5934\uff01", (String)this.getTitle(), (Component)this.getFilterPan());
                return false;
            }
            if (parenthesisChecker.lastIndexOf(")") != parenthesisChecker.length() - 1) {
                WindowUtil.msgboxInfo((Object)"\u5de6\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff1a\u4e0d\u80fd\u4ee5\u3010(\u3011\u7ed3\u5c3e\uff01", (String)this.getTitle(), (Component)this.getFilterPan());
                return false;
            }
            if (parenthesisChecker.lastIndexOf("(") != parenthesisChecker.length() - 1) {
                int l = 0;
                int r2 = 0;
                for (int i = 0; i < parenthesisChecker.length(); ++i) {
                    if (parenthesisChecker.substring(i, i + 1).endsWith("(")) {
                        ++l;
                        continue;
                    }
                    ++r2;
                }
                if (l != r2) {
                    WindowUtil.msgboxInfo((Object)"\u5de6\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff1a\u3010(\u3011\u4e0e\u3010)\u3011\u4e2a\u6570\u4e0d\u7b49\uff01", (String)this.getTitle(), (Component)this.getFilterPan());
                    return false;
                }
            }
        }
        return true;
    }

    public String getFilterParameters() {
        StringBuffer filterParams = new StringBuffer();
        IRow row = null;
        ICell cell = null;
        ComboBoxObject obj = null;
        String type = null;
        int n = this.filterTbl.getRowCount();
        for (int r = 0; r < n; ++r) {
            row = this.filterTbl.getRow(r);
            cell = row.getCell("filterIteam");
            obj = (ComboBoxObject)cell.getValue();
            type = obj.getCode();
            filterParams.append(type);
            cell = row.getCell("compareOperator");
            obj = (ComboBoxObject)cell.getValue();
            String compare = obj.getCode();
            filterParams.append(compare);
            cell = row.getCell("compareValue");
            String value = ((String)cell.getValue()).trim();
            if (compare.equals(" like ") || compare.equals(" not like ")) {
                filterParams.append("'%").append(value).append("%'");
            } else if (compare.equals(" in ")) {
                filterParams.append(" (");
                StringBuffer temp = new StringBuffer(value.trim());
                if (temp.charAt(0) == ',') {
                    temp.deleteCharAt(0);
                }
                if (temp.charAt(temp.length() - 1) == ',') {
                    temp.deleteCharAt(temp.length() - 1);
                }
                if (type.equals("T_F.FYEARID") || type.equals("T_F.FPERIODID")) {
                    filterParams.append(temp.toString().replaceAll("\uff0c", ","));
                } else {
                    filterParams.append("'" + temp.toString().replaceAll("\uff0c", ",").replaceAll(",", "','") + "'");
                }
                filterParams.append(") ");
            } else if (type.equals("T_F.FYEARID") || type.equals("T_F.FPERIODID")) {
                filterParams.append(" ").append(value).append(" ");
            } else {
                filterParams.append("'").append(value).append("'");
            }
            cell = row.getCell("logicOperator");
            if (cell.getValue() == null) break;
            obj = (ComboBoxObject)cell.getValue();
            filterParams.append(obj.getCode());
        }
        return filterParams.toString();
    }

    public String getSortParameters() {
        StringBuffer sort = new StringBuffer();
        IRow row = null;
        ICell cell = null;
        int n = this.sortTbl.getRowCount();
        for (int r = 0; r < n; ++r) {
            row = this.sortTbl.getRow(r);
            cell = row.getCell("isSort");
            if (cell.getValue().toString().equals("false")) continue;
            ComboBoxObject obj0 = (ComboBoxObject)row.getCell("sortCondition").getValue();
            ComboBoxObject obj2 = (ComboBoxObject)row.getCell("sortOption").getValue();
            sort.append(obj0.getCode()).append(obj2.getCode()).append(" ,");
        }
        if (sort.length() > 0) {
            sort.deleteCharAt(sort.length() - 1);
        }
        return sort.toString();
    }

    public void setInitParms(Map initParms) {
        this.initParms = initParms;
    }

    private Map getInitParms() {
        this.initParms.put("filterParameters", this.getFilterParameters());
        this.initParms.put("sortParameters", this.getSortParameters());
        this.initParms.put("requery", "isRequery");
        return this.initParms;
    }

    private String getTitle() {
        return "\u901a\u7528\u8fc7\u6ee4";
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        test dlg = new CommonFilterPane().new test();
        dlg.showDialog();
    }

    class test
    extends TypicalDialog {
        public test() {
        }

        public test(Frame owner) {
            super(owner);
        }

        public test(Dialog owner) {
            super(owner);
        }

        protected void todoInit() {
            this.setTitle("\u6d4b\u8bd5");
            this.setSize(500, 600);
        }

        protected void todoAddControls(Container parent, Cell thisCell) {
            CommonFilterPane cp = new CommonFilterPane();
            parent.add(cp.getFilterPane(true), thisCell);
        }
    }
}

