/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.general;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bi.model.common.mm.general.GeneralDimensionNode;
import com.kingdee.bos.bi.model.common.mm.general.GeneralModel;
import com.kingdee.bos.bi.model.common.mm.general.importscheme.SchemeDataProvider;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.dialog.general.AbstractGeneralDimensionDialog;
import com.kingdee.bos.bi.model.ui.dialog.general.ImportDataScheme;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GeneralDimensionDialog
extends AbstractGeneralDimensionDialog {
    private static final long serialVersionUID = 4841317560449798794L;
    private GeneralDimensionNode model = null;
    private IManagementFacade facade = null;
    private String viewId = null;

    public GeneralDimensionDialog() {
    }

    public GeneralDimensionDialog(Frame owner) {
        super(owner);
    }

    public GeneralDimensionDialog(Dialog owner) {
        super(owner);
    }

    @Override
    protected void todoAddControls(Container parent, Cell thisCell) {
        super.todoAddControls(parent, thisCell);
        this.loadModel();
    }

    private void loadModel() {
        DefaultKingdeeTreeNode root = this.modelToCtrl(this.model);
        KDTree tree = this.treeMain.getTree();
        KingdeeTreeModel treeModel = new KingdeeTreeModel((TreeNode)root);
        tree.setModel((TreeModel)treeModel);
        tree.setNodeText(root, "/");
        GeneralDimensionNode node = (GeneralDimensionNode)root.getUserObject();
        node.getGeneralModel().setName("");
    }

    private DefaultKingdeeTreeNode modelToCtrl(GeneralDimensionNode moNode) {
        DefaultKingdeeTreeNode ctrlNode = new DefaultKingdeeTreeNode();
        GeneralDimensionDialog.initCtrlNode(ctrlNode, moNode);
        int n = moNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            GeneralDimensionNode moChild = moNode.getChild(i);
            DefaultKingdeeTreeNode ctrlChild = this.modelToCtrl(moChild);
            ctrlNode.add((MutableTreeNode)ctrlChild);
        }
        return ctrlNode;
    }

    private static void initCtrlNode(DefaultKingdeeTreeNode ctrlNode, GeneralDimensionNode moNode) {
        ctrlNode.setUserObject((Object)moNode);
        ctrlNode.setText(moNode.getGeneralModel().getName());
    }

    public GeneralDimensionNode getModel() {
        KDTree tree = this.treeMain.getTree();
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
        if (rootNode.getChildCount() == 0) {
            return null;
        }
        return this.modelFromCtrl(rootNode);
    }

    private GeneralDimensionNode modelFromCtrl(DefaultKingdeeTreeNode ctrlNode) {
        GeneralDimensionNode moNode = (GeneralDimensionNode)ctrlNode.getUserObject();
        moNode.removeAllChildren();
        int n = ctrlNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultKingdeeTreeNode ctrlChild = (DefaultKingdeeTreeNode)ctrlNode.getChildAt(i);
            GeneralDimensionNode moChild = this.modelFromCtrl(ctrlChild);
            moNode.addChild(moChild);
        }
        return moNode;
    }

    public void setModel(GeneralDimensionNode model) {
        this.model = model;
    }

    public void setFacade(IManagementFacade facade) {
        this.facade = facade;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    @Override
    protected void action_Import() {
        DefaultKingdeeTreeNode ctrlParentNode;
        boolean isChaos;
        KDTree tree = this.treeMain.getTree();
        DefaultKingdeeTreeNode realCtrlRoot = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
        boolean bl = isChaos = realCtrlRoot.getChildCount() == 0;
        if (isChaos) {
            ctrlParentNode = realCtrlRoot;
        } else {
            TreePath path = tree.getSelectionPath();
            if (path == null) {
                WindowUtil.msgboxInfo((Object)"\u8bf7\u5148\u9009\u4e2d\u4e00\u4e2a\u8282\u70b9\u505a\u4e3a\u5bfc\u5165\u5b50\u6811\u7684\u6839\u3002", (String)"\u5bfc\u5165", (Component)((Object)this));
                return;
            }
            ctrlParentNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        }
        String selectNodeNumber = ((GeneralDimensionNode)ctrlParentNode.getUserObject()).getGeneralModel().getNumber();
        ImportDataScheme dlg = (ImportDataScheme)((Object)WindowUtil.createWindow(ImportDataScheme.class, (Component)((Object)this)));
        dlg.setFacade(this.facade);
        dlg.setDimNumber(this.dimNumber);
        dlg.setDimId(this.dimId);
        String schemeId = null;
        if (dlg.showDialog()) {
            schemeId = dlg.getSelectedSchemeId();
            HashMap<String, String> updateParams = new HashMap<String, String>();
            updateParams.put("viewId", this.viewId);
            updateParams.put("selectNodeNumber", selectNodeNumber);
            GeneralDimensionNode[] subTrees = null;
            try {
                subTrees = SchemeDataProvider.getSchemeData(schemeId, this.dimNumber, updateParams, this.facade);
            }
            catch (BIModelRemoteException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                WindowUtil.msgboxError((Object)e.getMessage(), (String)"\u9519\u8bef\u4fe1\u606f", (Component)((Object)this));
                log.error((Object)e);
            }
            if (subTrees == null || subTrees.length == 0) {
                WindowUtil.msgboxInfo((Object)"\u6240\u9009\u62e9\u7684\u65b9\u6848\u4e2d\u6ca1\u6709\u53ef\u7528\u6570\u636e\uff01", (String)"\u5bfc\u5165", (Component)((Object)this));
                return;
            }
            DefaultKingdeeTreeNode ctrlChildNode = null;
            int c = subTrees.length;
            for (int i = 0; i < c; ++i) {
                ctrlChildNode = this.modelToCtrl(subTrees[i]);
                this.updateNodeModel(tree, ctrlParentNode, ctrlChildNode);
            }
            if (ctrlChildNode != null) {
                tree.setSelectionNode(ctrlChildNode);
            }
        }
    }

    private boolean updateNodeModel(KDTree tree, DefaultKingdeeTreeNode parentNode, DefaultKingdeeTreeNode newNode) {
        if (newNode == null || parentNode == null) {
            return false;
        }
        GeneralDimensionNode newNodeModel = (GeneralDimensionNode)newNode.getUserObject();
        GeneralModel newGeneralModel = newNodeModel.getGeneralModel();
        String newNumber = newGeneralModel.getNumber();
        int n = parentNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultKingdeeTreeNode parentNodeChild = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            GeneralDimensionNode parentNodeChildModel = (GeneralDimensionNode)parentNodeChild.getUserObject();
            GeneralModel parentChildGeneralModel = parentNodeChildModel.getGeneralModel();
            String oldNumber = parentChildGeneralModel.getNumber();
            if (!StringUtil.equals(newNumber, oldNumber)) continue;
            parentNodeChildModel.setGeneralModel(newGeneralModel);
            tree.setNodeText(parentNodeChild, newGeneralModel.getName());
            this.attrbutePanel.loadModel(newGeneralModel);
            int k = 0;
            int m = newNode.getChildCount();
            while (k < m) {
                DefaultKingdeeTreeNode newNodeChild = (DefaultKingdeeTreeNode)newNode.getChildAt(k);
                boolean flag = this.updateNodeModel(tree, parentNodeChild, newNodeChild);
                if (!flag) {
                    m = newNode.getChildCount();
                    continue;
                }
                ++k;
            }
            return true;
        }
        tree.addNodeInto((MutableTreeNode)newNode, (MutableTreeNode)parentNode);
        return false;
    }

    protected boolean verify() {
        HashMap<String, String> mapForCheck = new HashMap<String, String>();
        String number = null;
        Enumeration e = ((DefaultKingdeeTreeNode)this.treeMain.getTree().getModel().getRoot()).breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultKingdeeTreeNode ctrlNode = (DefaultKingdeeTreeNode)e.nextElement();
            Object moNode = ctrlNode.getUserObject();
            if (!(moNode instanceof GeneralDimensionNode)) continue;
            GeneralModel m = ((GeneralDimensionNode)moNode).getGeneralModel();
            number = m.getNumber();
            if (mapForCheck.get(number) != null) {
                WindowUtil.msgboxInfo((Object)("\u8282\u70b9\u3010 " + m.getName() + "\u3011\u4e0e\u8282\u70b9\u3010" + mapForCheck.get(number) + "\u3011\u7684\u7f16\u7801 \u3010" + number + "\u3011\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002"), (String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u5c5e\u6027", (Component)((Object)this));
                return false;
            }
            mapForCheck.put(number, m.getName());
        }
        return true;
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        GeneralDimensionDialog aTest = new GeneralDimensionDialog();
        aTest.showDialog();
    }
}

