/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.org;

import com.kingdee.bos.bi.model.common.mm.org.OrgDimensionNode;
import com.kingdee.bos.bi.model.common.mm.org.OrgModel;
import com.kingdee.bos.bi.model.common.mm.org.OuQuery;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.dialog.EditableTree;
import com.kingdee.bos.bi.model.ui.dialog.org.OrgImportDialog;
import com.kingdee.bos.bi.model.ui.dialog.org.OrgType;
import com.kingdee.bos.bi.model.ui.exception.BIModelBizException;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class OrgDimensionDialog
extends TypicalDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogUtil.getPackageLogger(OrgDimensionDialog.class);
    private InnerUI _ui;
    private boolean _isReadOnly;

    public OrgDimensionDialog() {
    }

    public OrgDimensionDialog(Frame owner) {
        super(owner);
    }

    public OrgDimensionDialog(Dialog owner) {
        super(owner);
    }

    protected void todoInit() {
        this._ui = new InnerUI();
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        parent.add((Component)this._ui.getCtrl(), thisCell);
    }

    public void setModel(OrgDimensionNode root) {
        this._ui.setModel(root);
    }

    public OrgDimensionNode getModel() {
        return this._ui.getModel();
    }

    public void setReadOnly(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
        this._ui.getTreeWrapper().setReadOnly(isReadOnly);
        this._ui.txaDiscription.setEnabled(!isReadOnly);
        if (isReadOnly) {
            this.btnOk.setVisible(false);
            this.btnCancel.setText("\u5173\u95ed");
        }
    }

    protected boolean verify() {
        if (this.getDiscriptionTxt().length() > 2000) {
            WindowUtil.msgboxWarning((Object)"\u8bf4\u660e\u6587\u5b57\u7684\u6700\u5927\u957f\u5ea6\u4e3a2000\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        OrgDimensionNode moRoot = this.getModel();
        if (moRoot == null) {
            WindowUtil.msgboxWarning((Object)"\u4e0d\u5141\u8bb8\u6a21\u578b\u6ca1\u6709\u5185\u5bb9\u3002\u5982\u679c\u60a8\u60f3\u6e05\u9664\u6240\u6709\u5185\u5bb9\uff0c\u8bf7\u5728\u89c6\u56fe\u5217\u8868\u4e2d\u901a\u8fc7\u5220\u9664\u64cd\u4f5c\u6765\u5b8c\u6210\u3002", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        return !this.checkNumberExist(new HashMap(), moRoot);
    }

    private boolean checkNumberExist(Map numberExistMap, OrgDimensionNode moNode) {
        String number = moNode.getOrgModel().getNumber();
        String name = moNode.getOrgModel().getName();
        String existName = (String)numberExistMap.get(number);
        if (existName != null) {
            WindowUtil.msgboxInfo((Object)("\u8282\u70b9\u3016" + existName + "\u3017\u548c\u3016" + name + "\u3017\u7f16\u7801\u91cd\u590d\uff0c\u90fd\u662f\u3010" + number + "\u3011\u3002"), (String)this.getTitle(), (Component)((Object)this));
            return true;
        }
        numberExistMap.put(number, name);
        int c = moNode.getChildCount();
        for (int i = 0; i < c; ++i) {
            if (!this.checkNumberExist(numberExistMap, moNode.getChild(i))) continue;
            return true;
        }
        return false;
    }

    protected void onCancel() {
        if (!this._isReadOnly && this._ui.isDirty()) {
            int askResult = WindowUtil.msgboxYesNoCancel((Component)((Object)this), (Object)"\u662f\u5426\u4fdd\u5b58\u5bf9\u5f53\u524d\u7684\u4fee\u6539\uff1f", (String)this.getTitle());
            if (askResult == 2) {
                return;
            }
            if (askResult == 0) {
                this.onOk();
                return;
            }
        }
        super.onCancel();
    }

    public void setImportSourceFactory(IImportSourceFactory importSourceFactory) {
        this._ui.setImportSourceFactory(importSourceFactory);
    }

    private static void initCtrlNode(DefaultKingdeeTreeNode ctrlNode, OrgDimensionNode moNode) {
        ctrlNode.setUserObject((Object)moNode);
        ctrlNode.setText(moNode.getOrgModel().getName());
    }

    private static String checkModel(OrgModel model) {
        if (StringUtil.isEmptyString((String)model.getNumber())) {
            return "\u672a\u8bbe\u7f6e\u7f16\u7801\u3002";
        }
        if (StringUtil.isEmptyString((String)model.getName())) {
            return "\u672a\u8bbe\u7f6e\u540d\u79f0\u3002";
        }
        if (!Pattern.matches("[^!]+", model.getNumber())) {
            return "\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5141\u8bb8\u5305\u542b!\uff08\u611f\u53f9\u53f7\uff09\u3002";
        }
        if (model.getNumber().length() > 80) {
            return "\u7f16\u7801\u592a\u957f\uff0c\u4e0d\u80fd\u8d85\u8fc780\u4e2a\u5b57\u7b26\u3002";
        }
        if (model.getName().length() > 255) {
            return "\u540d\u79f0\u592a\u957f\uff0c\u4e0d\u80fd\u8d85\u8fc7255\u4e2a\u5b57\u7b26\u3002";
        }
        if (model.getDescription().length() > 2000) {
            return "\u5907\u6ce8\u592a\u957f\uff0c\u4e0d\u80fd\u8d85\u8fc72000\u4e2a\u5b57\u7b26\u3002";
        }
        return null;
    }

    public void setFacade(IManagementFacade facade) {
        this._ui.setFacade(facade);
    }

    public String getDiscriptionTxt() {
        return this._ui.getDiscriptionTxt();
    }

    public void setDiscriptionTxt(String discription) {
        this._ui.setDiscriptionTxt(discription);
    }

    private static class DetailUI
    extends KDPanel
    implements SimpleDialog.PanelOfSimpleDialog {
        private static final long serialVersionUID = 1L;
        private KDTextField _txtNumber;
        private KDTextField _txtName;
        private KDTextArea _txaDescription;
        private KDTree _editingTree;
        private String _selfNumber;

        public DetailUI() {
            this.init();
        }

        private void init() {
            this._txtNumber = new KDTextField();
            this._txtName = new KDTextField();
            this._txaDescription = new KDTextArea();
            KDLabelContainer lbcId = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtNumber, (String)"\u7ec4\u7ec7\u7f16\u7801", (int)80);
            KDLabelContainer lbcName = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtName, (String)"\u7ec4\u7ec7\u540d\u79f0", (int)80);
            TableLayout2 layout = new TableLayout2(4, 1);
            layout.setRowsSpacing(new int[]{0, 1}, 3);
            layout.setFixedHeight(new int[]{0, 1, 2}, 20);
            layout.setRatableHeight(3, 100);
            this.setLayout((LayoutManager)layout);
            this.add((Component)lbcId, TableLayout2.param((int)0, (int)0));
            this.add((Component)lbcName, TableLayout2.param((int)1, (int)0));
            this.add((Component)new KDLabel("\u5907\u6ce8\uff1a"), TableLayout2.param((int)2, (int)0));
            this.add((Component)new KDScrollPane((Component)this._txaDescription), TableLayout2.param((int)3, (int)0));
        }

        public void setEditable(boolean isEditable) {
            this._txtNumber.setEnabled(isEditable);
            this._txtName.setEnabled(isEditable);
            this._txaDescription.setEnabled(isEditable);
        }

        public void prepareCtrlValue(OrgModel model) {
            this._txtNumber.setText(model == null ? "" : model.getNumber());
            this._txtName.setText(model == null ? "" : model.getName());
            this._txaDescription.setText(model == null ? "" : model.getDescription());
        }

        public void updateModel(OrgModel model) {
            model.setNumber(this._txtNumber.getText().trim());
            model.setName(this._txtName.getText());
            model.setDescription(this._txaDescription.getText());
        }

        public boolean verify() {
            OrgModel model = new OrgModel();
            this.updateModel(model);
            String errInfo = OrgDimensionDialog.checkModel(model);
            if (errInfo != null) {
                WindowUtil.msgboxInfo((Object)errInfo, (String)"\u7ec4\u7ec7\u5c5e\u6027", (Component)((Object)this));
                return false;
            }
            if (!StringUtil.equalsIgnoreCase((String)this._selfNumber, (String)model.getNumber())) {
                Enumeration e = ((DefaultKingdeeTreeNode)this._editingTree.getModel().getRoot()).breadthFirstEnumeration();
                while (e.hasMoreElements()) {
                    DefaultKingdeeTreeNode ctrlNode = (DefaultKingdeeTreeNode)e.nextElement();
                    Object moNode = ctrlNode.getUserObject();
                    if (!(moNode instanceof OrgDimensionNode)) continue;
                    OrgModel m = ((OrgDimensionNode)moNode).getOrgModel();
                    if (!StringUtil.equalsIgnoreCase((String)model.getNumber(), (String)m.getNumber())) continue;
                    WindowUtil.msgboxInfo((Object)("\u7f16\u7801 " + model.getNumber() + " \u5df2\u5b58\u5728\u3002"), (String)"\u6307\u6807\u5c5e\u6027", (Component)((Object)this));
                    return false;
                }
            }
            return true;
        }

        public void setEditing(KDTree editingTree, String selfNumber) {
            this._editingTree = editingTree;
            this._selfNumber = selfNumber;
        }
    }

    public static class DefaultImportSourceFactory
    implements IImportSourceFactory {
        @Override
        public OrgDimensionNode loadEnvOrgTree(IManagementFacade facade, Map params) throws BIModelBizException {
            try {
                RDRowSet rowSet = OuQuery.buildOURowSet(facade);
                return DefaultImportSourceFactory.buildImportSupplyTree(rowSet);
            }
            catch (Exception ex) {
                throw new BIModelBizException(ex);
            }
        }

        private static OrgDimensionNode buildImportSupplyTree(RDRowSet rowSet) {
            OrgDimensionNode moRoot = null;
            HashMap<String, ArrayList<OrgDimensionNode>> map = new HashMap<String, ArrayList<OrgDimensionNode>>();
            while (rowSet.next()) {
                ArrayList<OrgDimensionNode> children;
                String id = rowSet.getString("id");
                String parentId = rowSet.getString("parent.id");
                OrgModel model = new OrgModel();
                model.setNumber(rowSet.getString("number"));
                model.setName(rowSet.getString("name"));
                model.setId(id);
                OrgType[] orgTypes = OrgType.getAll();
                for (int i = 0; i < orgTypes.length; ++i) {
                    String field = orgTypes[i].getName();
                    if (StringUtil.isEmptyString((String)field)) continue;
                    model.setExtProps(orgTypes[i], DefaultImportSourceFactory.object2BooleanString(rowSet.getObject(field)));
                }
                model.setExtProps("isOUSealUp", DefaultImportSourceFactory.object2BooleanString(rowSet.getObject("isOUSealUp")));
                model.setExtProps("partAdmin.isVirtual", DefaultImportSourceFactory.object2BooleanString(rowSet.getObject("partAdmin.isVirtual")));
                OrgDimensionNode moNode = new OrgDimensionNode();
                moNode.setOrgModel(model);
                if (moRoot == null && (StringUtil.isEmptyString((String)parentId) || StringUtil.equals((String)id, (String)parentId))) {
                    moRoot = moNode;
                }
                if ((children = (ArrayList<OrgDimensionNode>)map.get(parentId)) == null) {
                    children = new ArrayList<OrgDimensionNode>();
                    map.put(parentId, children);
                }
                children.add(moNode);
            }
            DefaultImportSourceFactory.buildImportSupplyTree(map, moRoot);
            return moRoot;
        }

        private static String object2BooleanString(Object obj) {
            boolean result = false;
            if (obj != null) {
                result = StringUtil.equalsIgnoreCase((String)obj.toString(), (String)"1");
            }
            return Boolean.toString(result);
        }

        private static OrgDimensionNode buildImportSupplyTree(IRowSet rowSet) throws SQLException {
            OrgDimensionNode moRoot = null;
            HashMap<String, ArrayList<OrgDimensionNode>> map = new HashMap<String, ArrayList<OrgDimensionNode>>();
            while (rowSet.next()) {
                ArrayList<OrgDimensionNode> children;
                String id = rowSet.getString("id");
                String parentId = rowSet.getString("parent.id");
                OrgModel model = new OrgModel();
                model.setNumber(rowSet.getString("number"));
                model.setName(rowSet.getString("name"));
                model.setId(id);
                OrgType[] orgTypes = OrgType.getAll();
                for (int i = 0; i < orgTypes.length; ++i) {
                    String field = orgTypes[i].getName();
                    if (StringUtil.isEmptyString((String)field)) continue;
                    model.setExtProps(orgTypes[i], rowSet.getString(field));
                }
                model.setExtProps("isOUSealUp", rowSet.getString("isOUSealUp"));
                model.setExtProps("partAdmin.isVirtual", rowSet.getString("partAdmin.isVirtual"));
                OrgDimensionNode moNode = new OrgDimensionNode();
                moNode.setOrgModel(model);
                if (moRoot == null && (StringUtil.isEmptyString((String)parentId) || StringUtil.equals((String)id, (String)parentId))) {
                    moRoot = moNode;
                }
                if ((children = (ArrayList<OrgDimensionNode>)map.get(parentId)) == null) {
                    children = new ArrayList<OrgDimensionNode>();
                    map.put(parentId, children);
                }
                children.add(moNode);
            }
            DefaultImportSourceFactory.buildImportSupplyTree(map, moRoot);
            return moRoot;
        }

        private static void buildImportSupplyTree(Map map, OrgDimensionNode moNode) {
            String id = moNode.getOrgModel().getId();
            ArrayList children = (ArrayList)map.get(id);
            if (children == null) {
                return;
            }
            for (int i = 0; i < children.size(); ++i) {
                OrgDimensionNode moChild = (OrgDimensionNode)children.get(i);
                moNode.addChild(moChild);
                DefaultImportSourceFactory.buildImportSupplyTree(map, moChild);
            }
        }
    }

    public static interface IImportSourceFactory {
        public OrgDimensionNode loadEnvOrgTree(IManagementFacade var1, Map var2) throws BIModelBizException;
    }

    private static class InnerUI {
        private KDPanel _panel;
        private EditableTree _treeWrapper;
        private DetailUI _detailUI;
        private boolean _isDirty;
        private IImportSourceFactory _importSourceFactory;
        private KDTextArea txaDiscription;
        private IManagementFacade facade = null;

        public InnerUI() {
            this.init();
            this.installListener();
        }

        private void init() {
            this._treeWrapper = new EditableTree();
            KDWorkButton btnImport = new KDWorkButton("\u5bfc\u5165");
            btnImport.addActionListener((ActionListener)new ImportActionHandler());
            this._treeWrapper.addCustomOperate(btnImport);
            this._treeWrapper.setCustomTailor(new TreeCustomTailor());
            KDTreeView treeView = this._treeWrapper.createTreeView();
            treeView.setTitle("\u7ec4\u7ec7\u7ef4\u5ea6\u6a21\u578b");
            this._detailUI = new DetailUI();
            this._detailUI.setEditable(false);
            this._detailUI.setOpaque(false);
            this._detailUI.setCustomInsets(new Insets(8, 8, 0, 8));
            KDContainer ctnEdit = new KDContainer();
            ctnEdit.setTitle("\u7ec4\u7ec7\u5c5e\u6027");
            ctnEdit.setEnableActive(false);
            ctnEdit.getContentPane().setLayout(new BorderLayout());
            ctnEdit.getContentPane().add((Component)((Object)this._detailUI), "Center");
            TableLayout2 layout = new TableLayout2(3, 1);
            layout.setRowSpacing(0, 10);
            layout.setRatableHeight(0, 100);
            layout.setFixedHeight(1, 160);
            layout.setFixedHeight(2, 70);
            this._panel = new KDPanel((LayoutManager)layout);
            this._panel.add((Component)treeView, (Object)TableLayout2.param((int)0, (int)0));
            this._panel.add((Component)ctnEdit, (Object)TableLayout2.param((int)1, (int)0));
            this._panel.add((Component)this.getDiscriptionPanel(), (Object)TableLayout2.param((int)2, (int)0));
        }

        public String getDiscriptionTxt() {
            return this.txaDiscription.getText().trim();
        }

        public void setDiscriptionTxt(String discription) {
            if (discription != null) {
                this.txaDiscription.setText(discription);
            }
        }

        private KDPanel getDiscriptionPanel() {
            KDPanel panDiscription = new KDPanel();
            TableLayout2 tly = new TableLayout2(3, 1);
            tly.setRowSpacing(0, 3);
            tly.setRatableHeight(2, 100);
            tly.setFixedHeight(1, 21);
            panDiscription.setLayout((LayoutManager)tly);
            KDLabel lblDiscription = new KDLabel("\u8bf4\u660e");
            this.txaDiscription = new KDTextArea();
            KDScrollPane scrpDiscription = new KDScrollPane((Component)this.txaDiscription);
            panDiscription.add((Component)lblDiscription, (Object)TableLayout2.param((int)1, (int)0));
            panDiscription.add((Component)scrpDiscription, (Object)TableLayout2.param((int)2, (int)0));
            return panDiscription;
        }

        private void installListener() {
            KDTree tree = this._treeWrapper.getTree();
            tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DefaultKingdeeTreeNode ctrlNode;
                    OrgDimensionNode moNode;
                    TreePath path = e.getNewLeadSelectionPath();
                    OrgModel orgModel = null;
                    if (path != null && (moNode = (OrgDimensionNode)(ctrlNode = (DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject()) != null) {
                        orgModel = moNode.getOrgModel();
                    }
                    _detailUI.prepareCtrlValue(orgModel);
                }
            });
        }

        public JComponent getCtrl() {
            return this._panel;
        }

        public EditableTree getTreeWrapper() {
            return this._treeWrapper;
        }

        public void setModel(OrgDimensionNode moRoot) {
            if (moRoot != null) {
                DefaultKingdeeTreeNode ctrlRoot = this.modelToCtrl(moRoot);
                KDTree tree = this._treeWrapper.getTree();
                DefaultKingdeeTreeNode realCtrlRoot = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
                tree.removeAllChildrenFromParent((MutableTreeNode)realCtrlRoot);
                tree.addNodeInto((MutableTreeNode)ctrlRoot, (MutableTreeNode)realCtrlRoot);
                tree.setSelectionNode(ctrlRoot);
            }
        }

        private DefaultKingdeeTreeNode modelToCtrl(OrgDimensionNode moNode) {
            DefaultKingdeeTreeNode ctrlNode = new DefaultKingdeeTreeNode();
            OrgDimensionDialog.initCtrlNode(ctrlNode, moNode);
            int c = moNode.getChildCount();
            for (int i = 0; i < c; ++i) {
                OrgDimensionNode moChild = moNode.getChild(i);
                DefaultKingdeeTreeNode ctrlChild = this.modelToCtrl(moChild);
                ctrlNode.add((MutableTreeNode)ctrlChild);
            }
            return ctrlNode;
        }

        public OrgDimensionNode getModel() {
            KDTree tree = this._treeWrapper.getTree();
            DefaultKingdeeTreeNode realCtrlRoot = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
            if (realCtrlRoot.getChildCount() == 0) {
                return null;
            }
            DefaultKingdeeTreeNode ctrlRoot = (DefaultKingdeeTreeNode)realCtrlRoot.getChildAt(0);
            return this.modelFromCtrl(ctrlRoot);
        }

        private OrgDimensionNode modelFromCtrl(DefaultKingdeeTreeNode ctrlNode) {
            OrgDimensionNode moNode = (OrgDimensionNode)ctrlNode.getUserObject();
            moNode.removeAllChildren();
            int c = ctrlNode.getChildCount();
            for (int i = 0; i < c; ++i) {
                DefaultKingdeeTreeNode ctrlChild = (DefaultKingdeeTreeNode)ctrlNode.getChildAt(i);
                OrgDimensionNode moChild = this.modelFromCtrl(ctrlChild);
                moNode.addChild(moChild);
            }
            return moNode;
        }

        public boolean isDirty() {
            return this._isDirty;
        }

        private IImportSourceFactory getImportSourceFactory() {
            if (this._importSourceFactory == null) {
                this._importSourceFactory = new DefaultImportSourceFactory();
            }
            return this._importSourceFactory;
        }

        public void setImportSourceFactory(IImportSourceFactory importSourceFactory) {
            this._importSourceFactory = importSourceFactory;
        }

        public void setFacade(IManagementFacade facade) {
            this.facade = facade;
        }

        private class ImportActionHandler
        implements ActionListener {
            private ImportActionHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                OrgDimensionNode root;
                DefaultKingdeeTreeNode ctrlParentNode;
                boolean isChaos;
                KDTree tree = InnerUI.this._treeWrapper.getTree();
                DefaultKingdeeTreeNode realCtrlRoot = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
                boolean bl = isChaos = realCtrlRoot.getChildCount() == 0;
                if (isChaos) {
                    ctrlParentNode = realCtrlRoot;
                } else {
                    TreePath path = tree.getSelectionPath();
                    if (path == null) {
                        WindowUtil.msgboxInfo((Object)"\u8bf7\u5148\u9009\u4e2d\u4e00\u4e2a\u8282\u70b9\u505a\u4e3a\u5bfc\u5165\u5b50\u6811\u7684\u6839\u3002", (String)"\u5bfc\u5165", (Component)InnerUI.this.getCtrl());
                        return;
                    }
                    ctrlParentNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                }
                try {
                    HashMap todoParams = new HashMap();
                    root = InnerUI.this.getImportSourceFactory().loadEnvOrgTree(InnerUI.this.facade, todoParams);
                }
                catch (BIModelBizException ex) {
                    log.error((Object)"", (Throwable)((Object)ex));
                    WindowUtil.msgboxError((Object)("\u6784\u9020\u5bfc\u5165\u5907\u9009\u6570\u636e\u51fa\u9519\u3002\r\n" + ex.getMessage()), (String)"\u5bfc\u5165", (Component)InnerUI.this.getCtrl());
                    return;
                }
                OrgImportDialog dlg = (OrgImportDialog)((Object)WindowUtil.createWindow(OrgImportDialog.class, (Component)InnerUI.this.getCtrl()));
                dlg.setTitle("\u5bfc\u5165\u7ec4\u7ec7");
                dlg.setSize(480, 600);
                dlg.setSupply(root);
                if (dlg.showDialog()) {
                    int c;
                    OrgDimensionNode[] subTrees = dlg.getSelected();
                    DefaultKingdeeTreeNode ctrlChildNode = null;
                    int n = c = isChaos ? Math.min(1, subTrees.length) : subTrees.length;
                    for (int i = 0; i < c; ++i) {
                        ctrlChildNode = InnerUI.this.modelToCtrl(subTrees[i]);
                        tree.addNodeInto((MutableTreeNode)ctrlChildNode, (MutableTreeNode)ctrlParentNode);
                    }
                    if (ctrlChildNode != null) {
                        tree.setSelectionNode(ctrlChildNode);
                    }
                }
            }
        }

        private class TreeCustomTailor
        implements EditableTree.ITreeCustomTailor {
            private DetailUI detailUI;

            private TreeCustomTailor() {
            }

            @Override
            public void initNewNode(KDTree tree, DefaultKingdeeTreeNode ctrlNode) {
                OrgModel orgModel = new OrgModel();
                orgModel.setName("\u65b0\u8282\u70b9");
                OrgDimensionNode moNode = new OrgDimensionNode();
                moNode.setOrgModel(orgModel);
                OrgDimensionDialog.initCtrlNode(ctrlNode, moNode);
            }

            @Override
            public boolean modifyNode(KDTree tree, DefaultKingdeeTreeNode ctrlNode) {
                OrgDimensionNode moNode = (OrgDimensionNode)ctrlNode.getUserObject();
                OrgModel model = moNode.getOrgModel();
                if (this.detailUI == null) {
                    this.detailUI = new DetailUI();
                    this.detailUI.setEditable(true);
                }
                this.detailUI.setEditing(tree, model.getNumber());
                this.detailUI.prepareCtrlValue(model);
                SimpleDialog dlg = SimpleDialog.create((Component)tree);
                dlg.setComponent((Component)((Object)this.detailUI));
                dlg.setSize(480, 240);
                dlg.setTitle("\u7ec4\u7ec7\u5c5e\u6027");
                if (dlg.showDialog()) {
                    this.detailUI.updateModel(model);
                    tree.setNodeText(ctrlNode, model.getName());
                    InnerUI.this._detailUI.prepareCtrlValue(model);
                    return true;
                }
                return false;
            }

            @Override
            public boolean isMultiRootSupported() {
                return false;
            }

            @Override
            public void modelChanged(String operateType) {
                InnerUI.this._isDirty = true;
            }
        }
    }
}

