/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.olap.Filter;
import com.kingdee.bos.ctrl.analysis.olap.ModelFactory;
import com.kingdee.bos.ctrl.analysis.olap.NonEmpty;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.Driver;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.app.IORMRPCBIOlapService;
import com.kingdee.eas.framework.bireport.app.servo.OlapConnectionServo;
import com.kingdee.eas.framework.bireport.util.BIReportException;
import com.kingdee.eas.framework.bireport.util.EASDataSource;
import com.kingdee.eas.framework.bireport.util.KSQLTempTableManager;
import com.kingdee.eas.framework.bireport.util.OlapParams;
import com.kingdee.eas.framework.report.util.RptParams;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ORMRPCBIOlapService
extends ORMObject
implements IORMRPCBIOlapService {
    private Logger logger = CommonLogger.getLogger(ORMRPCBIOlapService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OlapParams _executeModel(Map dataMap, String filter, String mdx, List notVisibleMeasures, SchemaDef schemaDef, boolean useSQLDataReduction, OlapParams olapParams, boolean useNonEmpty, boolean nonEmptyForRow, boolean nonEmptyForColumn, Context ctx, RptParams params, boolean remoteConnection, int caller) throws BOSException, EASBizException {
        try {
            long startTime = System.currentTimeMillis();
            this.logger.info((Object)"start _executeModel...");
            Connection con = this.getConnection(dataMap, params.getString("OLAP_USEMODE"), notVisibleMeasures, useSQLDataReduction, schemaDef, ctx);
            if (remoteConnection) {
                this.registConnection(con, caller, ctx);
            } else {
                olapParams.setConnection(con);
            }
            OlapModel model = ModelFactory.makeKDOlapModel((Connection)con, (String)mdx);
            try {
                model.disableModelChangedEvent();
                NonEmpty nonEmpty = (NonEmpty)model.getExtension("nonEmpty");
                nonEmpty.setUseNonEmpty(useNonEmpty);
                nonEmpty.setNonEmptyForColumn(nonEmptyForColumn);
                nonEmpty.setNonEmptyForRow(nonEmptyForRow);
                if (filter != null && filter.trim().length() > 0) {
                    ((Filter)model.getExtension("filter")).setCondition(filter);
                }
            }
            finally {
                model.enableModelChangedEvent();
            }
            model.getResult();
            olapParams.setResult(model.getKDResult());
            olapParams.setDefaultCubeName(con.getDefaultCubeName());
            olapParams.setSchemaReader(con.getRemoteSchemaReader());
            this.logger.info((Object)("end _executeModel, cost time " + (System.currentTimeMillis() - startTime)));
            return olapParams;
        }
        catch (OLAPException e) {
            BIReportException be = new BIReportException(e);
            throw be;
        }
        catch (OlapException e) {
            BIReportException be = new BIReportException(e);
            throw be;
        }
    }

    @Override
    public Object _invokeConnectionAction(Context ctx, String method, Class[] argTypes, Object[] argValues, int caller) throws BOSException, EASBizException {
        if (method.startsWith("OLAP_BATCH_INVOKE")) {
            method = method.substring("OLAP_BATCH_INVOKE".length() + 1);
            String[] methods = StringUtil.splitString((String)method, (String)",");
            Class[][] clazzs = (Class[][])argValues[0];
            Object[][] valuess = (Object[][])argValues[1];
            Object[] ret = new Object[methods.length];
            for (int i = 0; i < methods.length; ++i) {
                ret[i] = this._invokeConnectionAction(ctx, methods[i], clazzs[i], valuess[i], caller);
            }
            return ret;
        }
        long startTime = System.currentTimeMillis();
        this.logger.info((Object)("start _invokeConnectionAction " + method + " ..."));
        try {
            OlapConnectionServo cm = OlapConnectionServo.getInstance();
            if (method.equals("close")) {
                cm.remove(ctx, caller, true);
                return null;
            }
            Connection con = cm.get(ctx, caller);
            Method mm = cm.getMethod(Connection.class, method, argTypes);
            Object ret = mm.invoke((Object)con, argValues);
            this.logger.info((Object)("end _invokeConnectionAction " + method + ", cost time " + (System.currentTimeMillis() - startTime)));
            return ret;
        }
        catch (Exception e) {
            Throwable te = e;
            if (e instanceof InvocationTargetException) {
                te = ((InvocationTargetException)te).getTargetException();
            }
            BIReportException be = new BIReportException(te);
            be.setStackTrace(te.getStackTrace());
            throw be;
        }
    }

    private Connection getConnection(Map paramMap, String useMode, List notVisibleMeasures, boolean useSQLDataReduction, SchemaDef schemaDef, Context ctx) throws OLAPException, EASBizException {
        paramMap.put("JdbcDataSource", new EASDataSource(ctx));
        paramMap.put("OLAP_KEY_KSQL", Boolean.TRUE);
        paramMap.put("OLAP_KEY_MEASURE_VISIBLES", notVisibleMeasures);
        paramMap.put("ITempTableManager.ID", new KSQLTempTableManager(ctx));
        if (useSQLDataReduction) {
            paramMap.put("OLAP_KEY_SQLDATAREDUCTION", Boolean.TRUE);
        }
        boolean rolap = true;
        Connection con = Driver.openConnection((SchemaDef)schemaDef, (Map)paramMap, (boolean)rolap);
        return con;
    }

    protected Connection registConnection(Connection con, int uiCaller, Context ctx) throws OLAPException, EASBizException {
        OlapConnectionServo cm = OlapConnectionServo.getInstance();
        cm.remove(ctx, uiCaller, true);
        cm.put(ctx, uiCaller, con);
        return con;
    }
}

