/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class BireportDBUtil {
    private static Connection getConnection(Context ctx) throws SQLException {
        return EJBFactory.getConnection((Context)ctx);
    }

    private static void close(Connection con) throws SQLException {
        if (con != null) {
            con.close();
        }
    }

    private static void close(ResultSet rs, Statement stmt, Connection con) throws SQLException {
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        if (con != null) {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRowSet executeQuery(String sql, SqlParams sp, Context ctx) throws SQLException {
        JdbcRowSet jdbcRowSet;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection con = BireportDBUtil.getConnection(ctx);
        try {
            ps = con.prepareStatement(sql);
            if (sp != null) {
                sp.putToStatement(ps);
            }
            rs = ps.executeQuery();
            JdbcRowSet rowSet = new JdbcRowSet();
            rowSet.populate(rs);
            jdbcRowSet = rowSet;
        }
        catch (Throwable throwable) {
            BireportDBUtil.close(rs, ps, con);
            throw throwable;
        }
        BireportDBUtil.close(rs, ps, con);
        return jdbcRowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(String sql, SqlParams sp, Context ctx) throws SQLException {
        PreparedStatement ps = null;
        Connection con = BireportDBUtil.getConnection(ctx);
        try {
            ps = con.prepareStatement(sql);
            if (sp != null) {
                sp.putToStatement(ps);
            }
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            BireportDBUtil.close(null, ps, con);
        }
    }
}

