/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.util;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FormatUtil {
    private static final SimpleDateFormat date_sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final long A_DAY_TIME = 86400000L;
    public static final Color ROW_COLOR_TOTAL = new Color(0xFFFFE8);

    private FormatUtil() {
    }

    public static boolean isPowerOfTen(float value) {
        if (value < 1.0f) {
            return false;
        }
        if (value == 1.0f) {
            return true;
        }
        return value % 10.0f == 0.0f;
    }

    public static String formatDateTitle(Date dt) {
        return date_sdf.format(dt);
    }

    public static String formatDateTitle(Date from, Date to) {
        StringBuffer sb = new StringBuffer();
        if (Math.abs(to.getTime() - from.getTime()) < 86400000L) {
            sb.append(date_sdf.format(from));
        } else {
            sb.append(date_sdf.format(from)).append(" \u81f3 ").append(date_sdf.format(to));
        }
        return sb.toString();
    }

    public static String getCurrentUnit(float value) {
        int n = 0;
        int v = (int)value;
        if (v > 10) {
            ++n;
            while (v > 10) {
                v /= 10;
                ++n;
            }
        }
        String unit = null;
        switch (n) {
            case 0: {
                unit = "\u5143";
                break;
            }
            case 1: {
                unit = "\u5341\u5143";
                break;
            }
            case 2: {
                unit = "\u767e\u5143";
                break;
            }
            case 3: {
                unit = "\u5343\u5143";
                break;
            }
            case 4: {
                unit = "\u4e07\u5143";
                break;
            }
            case 5: {
                unit = "\u5341\u4e07\u5143";
                break;
            }
            case 6: {
                unit = "\u767e\u4e07\u5143";
                break;
            }
            case 7: {
                unit = "\u5343\u4e07\u5143";
                break;
            }
            case 8: {
                unit = "\u4ebf\u5143";
                break;
            }
            case 9: {
                unit = "\u5341\u4ebf\u5143";
                break;
            }
            case 10: {
                unit = "\u767e\u4ebf\u5143";
                break;
            }
            case 11: {
                unit = "\u5343\u4ebf\u5143";
                break;
            }
            default: {
                unit = "\u989d\u5ea6\u9519\u8bef";
            }
        }
        return unit;
    }

    public static void markSumRow(KDTable tbl, String pattern) {
        int r = tbl.getRowCount();
        int c = tbl.getColumnCount();
        for (int i = 0; i < r; ++i) {
            IRow row = tbl.getRow(i);
            for (int j = 0; j < c; ++j) {
                if (!String.valueOf(row.getCell(j).getValue()).matches(pattern)) continue;
                row.getStyleAttributes().setBackground(ROW_COLOR_TOTAL);
                tbl.getColumn(j).getStyleAttributes().setBackground(ROW_COLOR_TOTAL);
            }
        }
        tbl.getCell(0, 0).getStyleAttributes().setBackground(Color.WHITE);
    }
}

