/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.eas.common.IVersionManager;
import com.kingdee.eas.common.VersionInfo;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class VersionManager
extends ORMObject
implements IVersionManager {
    private static String versionInfo = null;
    private static String SERVER_PATH_NAME = "EAS_HOME";
    private static String CONFIG_FILE_NAME = "version.data";
    private static Logger logger = Logger.getLogger(VersionManager.class);

    public VersionManager() {
        super.registerInterface(IVersionManager.class, (Object)this);
    }

    @Override
    public String getMetadataVersion() throws Exception {
        if (StringUtils.isEmpty((String)versionInfo)) {
            Context ctx = new Context(null, "eas", null, new Locale("L1"));
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            SolutionInfo slnInfo = loader.getSolution();
            versionInfo = slnInfo.getVersion();
        }
        return versionInfo;
    }

    @Override
    public String getCommonLibVersion() throws Exception {
        return "8.2.0.0";
    }

    @Override
    public VersionInfo getServerVersion() {
        HashMap<String, String> vers = new HashMap<String, String>();
        try {
            vers.put("MetadataVersion", this.getMetadataVersion());
        }
        catch (Exception e) {
            vers.put("MetadataVersion", "Unknown");
        }
        try {
            vers.put("CommonLibVersion", this.getCommonLibVersion());
        }
        catch (Exception e) {
            vers.put("CommonLibVersion", "Unknown");
        }
        return new VersionInfo(vers);
    }

    @Override
    public String getComponentsVersion() throws Exception {
        return this.getCommonLibVersion();
    }

    private InputStream getVersionDataFile() {
        InputStream inputFile = this.getNewWay();
        if (inputFile == null) {
            return this.getOldWay();
        }
        return inputFile;
    }

    private InputStream getNewWay() {
        String serverPath = System.getProperty(SERVER_PATH_NAME);
        String configPath = serverPath + File.separator + "server" + File.separator + "deploy" + File.separator + CONFIG_FILE_NAME;
        File tempFile = new File(configPath);
        if (tempFile != null && tempFile.exists()) {
            try {
                return new FileInputStream(tempFile);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"fileNotFound!", (Throwable)e);
            }
        }
        return null;
    }

    private InputStream getOldWay() {
        return this.getClass().getResourceAsStream("/com/kingdee/eas/common/version.data");
    }

    public static void main(String[] args) {
        VersionManager vm = new VersionManager();
        try {
            logger.info((Object)("comlib is:" + vm.getCommonLibVersion()));
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

