/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.calc.express;

import com.kingdee.eas.common.calc.CalcResource;
import com.kingdee.eas.common.calc.express.IllegalParameterException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class FunctionUtil {
    private double[] listToDoubleArray(List list) {
        int len = list.size();
        double[] dd = new double[len];
        for (int i = 0; i < len; ++i) {
            dd[i] = (Double)list.get(i);
        }
        return dd;
    }

    public double abs(double value) {
        return Math.abs(value);
    }

    public double acos(double value) {
        return Math.acos(value);
    }

    public double asin(double value) {
        return Math.asin(value);
    }

    public double atan(double value) {
        return Math.atan(value);
    }

    public double ceil(double value) {
        return Math.ceil(value);
    }

    public double cos(double value) {
        return Math.cos(value);
    }

    public double dms(double value) {
        boolean neg = value < 0.0;
        double n = Math.abs(value);
        double d = Math.floor(value);
        double m = Math.floor(60.0 * (n - d));
        double s = (n - d) * 60.0 - m;
        double dms = d + m / 100.0 + s * 0.006;
        if (neg) {
            dms = -dms;
        }
        return dms;
    }

    public double exp(double value) {
        return Math.exp(value);
    }

    public double floor(double value) {
        return Math.floor(value);
    }

    public double log(double value) {
        return Math.log(value);
    }

    public double max(List list) {
        double[] dd = this.listToDoubleArray(list);
        double max = dd[0];
        for (int i = 1; i < dd.length; ++i) {
            if (!(max < dd[i])) continue;
            max = dd[i];
        }
        return max;
    }

    public double min(List list) {
        double[] dd = this.listToDoubleArray(list);
        double min = dd[0];
        for (int i = 1; i < dd.length; ++i) {
            if (!(min > dd[i])) continue;
            min = dd[i];
        }
        return min;
    }

    public double mod(double a, double b) throws IllegalParameterException {
        if (b == 0.0) {
            throw new IllegalParameterException(CalcResource.getRes("divisor_cannotbe_zero"));
        }
        return a % b;
    }

    public double pow(double a, double b) {
        return Math.pow(a, b);
    }

    public double round(double value) {
        return Math.round(value);
    }

    public double sin(double value) {
        return Math.sin(value);
    }

    public double sqrt(double value) {
        return Math.sqrt(value);
    }

    public double tan(double value) {
        return Math.tan(value);
    }

    public double todegrees(double value) {
        return Math.toDegrees(value);
    }

    public double toradians(double value) {
        return Math.toRadians(value);
    }

    public double year() {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(new Date());
        return g.get(1);
    }

    public double month() {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(new Date());
        return g.get(2) + 1;
    }

    public double day() {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(new Date());
        return g.get(5);
    }

    public double hour() {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(new Date());
        return g.get(11);
    }

    public double minute() {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(new Date());
        return g.get(12);
    }

    public double second() {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(new Date());
        return g.get(13);
    }

    public double week() {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(new Date());
        return g.get(7);
    }

    public double timestamp() {
        return new Date().getTime();
    }

    public double sign(double value) {
        return value > 0.0 ? 1.0 : (double)(value == 0.0 ? 0 : -1);
    }

    public double decode(double a, double b, double c, double d) {
        if (a > b) {
            return c;
        }
        return d;
    }

    public double avg(List list) {
        return this.sum(list) / (double)list.size();
    }

    public double sum(List list) {
        double[] dd = this.listToDoubleArray(list);
        double sum = 0.0;
        for (int i = 0; i < dd.length; ++i) {
            sum += dd[i];
        }
        return sum;
    }

    public double sumsq(List list) {
        double[] dd = this.listToDoubleArray(list);
        double sum = 0.0;
        for (int i = 0; i < dd.length; ++i) {
            sum += dd[i] * dd[i];
        }
        return sum;
    }

    public static double fact(double value) throws IllegalParameterException {
        return FunctionUtil.fact(value, 0.0);
    }

    public static double fact(double value, double fix) throws IllegalParameterException {
        if (value > 20.0) {
            throw new IllegalParameterException(CalcResource.getRes("factorial_radix_tolarge") + "(>20)");
        }
        int stageValue = (int)Math.round(value);
        if (value != (double)stageValue && fix != 1.0) {
            throw new IllegalParameterException(CalcResource.getRes("factorial_radix_autofix2int") + "(" + CalcResource.getRes("round") + ")" + CalcResource.getRes("factorial_radix_with") + "\"!\"" + CalcResource.getRes("use_sign") + "1");
        }
        if (stageValue < 0) {
            return -FunctionUtil.fact(-stageValue);
        }
        return FunctionUtil.fact(stageValue);
    }

    private static long fact(int value) throws IllegalParameterException {
        if (value < 1) {
            return 1L;
        }
        return (long)value * FunctionUtil.fact(value - 1);
    }

    public double pi() {
        return Math.PI;
    }

    public double trunc(double value) {
        return (long)value;
    }

    public double fv(double dblRate, double dblNPer, double dblPMT, double dblPv, boolean bType) {
        double dblRet;
        if (dblRate == 0.0) {
            dblRet = -dblPv - dblPMT * dblNPer;
        } else {
            double dblTemp = bType ? 1.0 + dblRate : 1.0;
            double dblTemp3 = 1.0 + dblRate;
            double dblTemp2 = Math.pow(dblTemp3, dblNPer);
            dblRet = -dblPv * dblTemp2 - dblPMT * dblTemp * (dblTemp2 - 1.0) / dblRate;
        }
        return dblRet;
    }

    public double db(double cost, double salvage, double life, double period, double month) throws IllegalParameterException {
        return this.db(cost, salvage, life, period, month, period);
    }

    public double db(double cost, double salvage, double life, double period, double month, double pickPeriod) throws IllegalParameterException {
        double dd;
        if (pickPeriod < 1.0 || pickPeriod > period) {
            throw new IllegalParameterException(CalcResource.getRes("depreciation_period_uncorrect"));
        }
        double rate = 1.0 - Math.pow(salvage / cost, 1.0 / life);
        rate = (double)Math.round(rate * 1000.0) / 1000.0;
        double dbsum = dd = cost * rate * month / 12.0;
        int i = 1;
        while ((double)i < period - 1.0) {
            if (pickPeriod == (double)i) {
                return dd;
            }
            dd = (cost - dbsum) * rate;
            dbsum += dd;
            ++i;
        }
        dd = (cost - dbsum) * rate * (12.0 - month) / 12.0;
        return dd;
    }

    public double ddb(double cost, double salvage, double life, double period) {
        return this.ddb(cost, salvage, life, period, 2.0);
    }

    public double ddb(double cost, double salvage, double life, double period, double factor) {
        double dd = 0.0;
        dd = (cost - salvage - dd) * (factor / life);
        return dd;
    }

    public double npv(List list) {
        double[] dd = this.listToDoubleArray(list);
        double rate = dd[0];
        double sum = 0.0;
        for (int i = 1; i < dd.length; ++i) {
            sum += dd[i] / Math.pow(1.0 + rate, i);
        }
        return sum;
    }

    public double sln(double cost, double salvage, double life) {
        return (cost - salvage) / life;
    }

    public double syd(double cost, double salvage, double life, double per) {
        return (cost - salvage) * (life - per + 1.0) * 2.0 / (life * (life + 1.0));
    }
}

