/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util.client;

import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.LocaleUtils;
import java.awt.Image;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class EASResource {
    private static Logger logger = Logger.getLogger(EASResource.class);

    private EASResource() {
    }

    private static Locale getLocale() {
        try {
            return SysContext.getSysContext().getOriginLocale();
        }
        catch (Throwable e) {
            logger.error((Object)("Get Locale fail!" + e.getMessage()));
            return LocaleUtils.locale_zh_CN;
        }
    }

    public static String getString(String resName) {
        return EASCommonResource.getString(resName, EASResource.getLocale());
    }

    public static String getString(String resName, Object[] params) {
        String s = EASResource.getString(resName);
        MessageFormat mf = new MessageFormat(s);
        String result = mf.format(params);
        return result;
    }

    private static String getStringWithDefaultText(String resName, String defaultText) {
        String strTemp = EASResource.getString(resName);
        if (strTemp.equals("Missing Resource")) {
            return defaultText;
        }
        return strTemp;
    }

    public static String getString(String resClassName, String resName) {
        return EASCommonResource.getString(resClassName, resName, EASResource.getLocale());
    }

    public static String getString(String resClassName, String resName, Object[] params) {
        String s = EASResource.getString(resClassName, resName);
        MessageFormat mf = new MessageFormat(s);
        String result = mf.format(params);
        return result;
    }

    private static String getStringWithDefaultText(String resClassName, String resName, String defaultText) {
        String strTemp = EASResource.getString(resName);
        if (strTemp.equals("Missing Resource")) {
            return defaultText;
        }
        return strTemp;
    }

    public static Image getImage(String resName) {
        return EASCommonResource.getImage(resName, EASResource.getLocale());
    }

    public static Image getImage4Login(String resName) {
        return EASCommonResource.getImage4Login(resName, EASResource.getLocale());
    }

    public static Icon getIcon(String resName) {
        return EASCommonResource.getIcon(resName, EASResource.getLocale());
    }

    public static Icon getIcon4Login(String resName) {
        return EASCommonResource.getIcon4Login(resName, EASResource.getLocale());
    }
}

