/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.util.client.KDTableColumnItem;
import java.awt.Font;

public class KDTableUtil {
    public static void setHeaderFont(KDTable table) {
        table.getHeadStyleAttributes().setFont(new Font("\u5b8b\u4f53", 0, 12));
    }

    public static void setBodyFont(KDTable table) {
        table.getStyleAttributes().setFont(new Font("\u5b8b\u4f53", 0, 12));
    }

    public static void setHeaderFont(KDTable table, Font font) {
        table.getHeadStyleAttributes().setFont(font);
    }

    public static void setBodyFont(KDTable table, Font font) {
        table.getStyleAttributes().setFont(font);
    }

    public static void setFont(KDTable table) {
        KDTableUtil.setHeaderFont(table);
        KDTableUtil.setBodyFont(table);
    }

    public static void setFont(KDTable table, Font font) {
        KDTableUtil.setHeaderFont(table, font);
        KDTableUtil.setBodyFont(table, font);
    }

    public static void addHeaderRow(KDTable table, String[] key, String[] text) {
        int i;
        IColumn col = null;
        IRow row = null;
        for (i = 0; i < key.length; ++i) {
            col = table.addColumn(i);
            col.setKey(key[i]);
        }
        row = table.addHeadRow();
        for (i = 0; i < key.length; ++i) {
            row.getCell(i).setValue((Object)text[i]);
        }
    }

    public static void addHeaderRow(KDTable table, KDTableColumnItem[] items) {
        int i;
        IColumn col = null;
        IRow row = null;
        for (i = 0; i < items.length; ++i) {
            col = table.addColumn(i);
            col.setKey(items[i].getKey());
        }
        row = table.addHeadRow();
        for (i = 0; i < items.length; ++i) {
            row.getCell(i).setValue((Object)items[i].getText());
        }
    }

    public static int getSelectedRow(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            return -1;
        }
        return table.getSelectManager().get().getBottom();
    }

    public static int getSelectedRowCount(KDTable table) {
        int count = 0;
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            KDTSelectBlock block = table.getSelectManager().get(i);
            count += block.getBottom() - block.getTop() + 1;
        }
        return count;
    }

    public static int[] getSelectedRows(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            return new int[0];
        }
        int count = KDTableUtil.getSelectedRowCount(table);
        int[] rows = new int[count];
        int k = 0;
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            KDTSelectBlock block = table.getSelectManager().get(i);
            int j = block.getTop();
            while (j <= block.getBottom()) {
                rows[k] = j++;
                ++k;
            }
        }
        return rows;
    }

    public static void removeAllRow(KDTable table) {
        for (int i = table.getRowCount() - 1; i >= 0; --i) {
            table.removeRow(i);
        }
    }
}

