/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.DownloadLogsFacadeFactory;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.HttpClientUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import sun.misc.BASE64Encoder;

public class KsmUtil {
    private static String prefixUrl = System.getProperty("KSM.PrefixUrl");
    public static final String emailReg = "^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$";
    public static final String phoneReg = "^\\d{11}$";
    public static final String failedFlag = "failed!";
    private static final String SYSTEM_SOURCE = "EASGUI";
    private static final String submitFail = "submitFeedbackFail";

    public static String join(String[] strAry) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strAry.length; ++i) {
            sb.append(strAry[i]);
        }
        return new String(sb);
    }

    public static void main(String[] args) {
        String[] sa = new String[]{"a", "b", "c"};
        String s1 = KsmUtil.join(sa);
    }

    public static String shaHex(String ... data) throws UnsupportedEncodingException {
        Arrays.sort(data);
        String join = KsmUtil.join(data);
        String sign = DigestUtils.md5Hex((byte[])join.getBytes("utf-8"));
        return sign;
    }

    public static String getAccessToken(String productno, String user, String email) throws UnsupportedEncodingException {
        String nonce = UUID.randomUUID().toString();
        String stamp = String.valueOf((int)(System.currentTimeMillis() / 1000L));
        String sign = KsmUtil.shaHex(productno, user, nonce, email, HttpClientUtil.SIGN_KEY, stamp, SYSTEM_SOURCE);
        String params = String.format("productno=%s&user=%s&email=%s&nonce=%s&sign=%s&timestamp=%s&systemSource=%s", productno, URLEncoder.encode(user, "utf-8"), email, nonce, sign, stamp, SYSTEM_SOURCE);
        String result = HttpClientUtil.sendPost(prefixUrl + "oauth", params);
        System.out.print(result);
        JSONObject obj = JSONObject.fromObject((Object)result);
        if (obj.getInt("errCode") == 0) {
            String access_token = obj.getJSONObject("data").getString("access_token");
            return access_token;
        }
        return AdvMsgBox.getResString(submitFail) + obj.get("msg").toString();
    }

    public static String saveFeedBack(String productno, String user, String phone, String email, String title, String desc) throws UnsupportedEncodingException, BOSException {
        String accessToken = KsmUtil.getAccessToken(productno, user, email);
        if (accessToken == null) {
            throw new BOSException("\u83b7\u53d6Token\u5931\u8d25");
        }
        String type = "1";
        String troubleLevel = "4";
        String productModule = "\u62a5\u8868\u7cfb\u7edf";
        String timestamp = String.valueOf((int)(System.currentTimeMillis() / 1000L));
        String nonce = UUID.randomUUID().toString();
        String sign = KsmUtil.shaHex(timestamp, accessToken, HttpClientUtil.SIGN_KEY, nonce);
        String params = String.format("title=%s&desc=%s&phone=%s&type=%s&troubleLevel=%s&productModule=%s&linkman=%s&access_token=%s&timestamp=%s&sign=%s&nonce=%s", URLEncoder.encode(title, "utf-8"), URLEncoder.encode(desc, "utf-8"), phone, type, troubleLevel, URLEncoder.encode(productModule, "utf-8"), URLEncoder.encode(user, "utf-8"), accessToken, timestamp, sign, nonce);
        String result = HttpClientUtil.sendPost(prefixUrl + "saveFeedback", params);
        JSONObject obj = JSONObject.fromObject((Object)result);
        if (obj.getInt("errCode") == 0) {
            String feedBackNumber = ((JSONObject)obj.get("data")).get("feedbackNumber").toString();
            return feedBackNumber;
        }
        return AdvMsgBox.getResString(submitFail) + obj.get("msg").toString();
    }

    public static String toBase64String(byte[] file) {
        return new BASE64Encoder().encode(file);
    }

    public static String upload(String access_token, String objID, String fileData, String filename) throws IOException, BOSException {
        String timestamp = String.valueOf((int)(System.currentTimeMillis() / 1000L));
        String nonce = UUID.randomUUID().toString();
        String sign = KsmUtil.shaHex(access_token, timestamp, HttpClientUtil.SIGN_KEY, nonce);
        String params = String.format("filename=%s&fileData=%s&access_token=%s&timestamp=%s&sign=%s&objID=%s&nonce=%s", filename, fileData, access_token, timestamp, sign, objID, nonce);
        String result = HttpClientUtil.sendPost(prefixUrl + "fileupload", params);
        JSONObject obj = JSONObject.fromObject((Object)result);
        if (obj.getInt("errCode") == 0) {
            return obj.get("result").toString();
        }
        return AdvMsgBox.getResString(submitFail) + obj.get("msg").toString();
    }

    public static String saveFeedBackWithFiles(String productno, String user, String phone, String email, String title, String desc, String detail, String screenShot) throws BOSException, IOException {
        String access_token = KsmUtil.getAccessToken(productno, user, email);
        if (access_token.startsWith(failedFlag)) {
            return access_token;
        }
        String objId = UUID.randomUUID().toString();
        byte[] logs = DownloadLogsFacadeFactory.getRemoteInstance().getLogFiles("apusic.log.0,BotpTrace.log");
        String serverFileData = URLEncoder.encode(KsmUtil.toBase64String(logs), "utf-8");
        String clientFileData = URLEncoder.encode(KsmUtil.toBase64String(detail.getBytes()), "utf-8");
        String screenShotData = URLEncoder.encode(screenShot, "utf-8");
        String flag = KsmUtil.upload(access_token, objId, serverFileData, "serverLogs.zip");
        if (flag.startsWith(failedFlag)) {
            return flag;
        }
        flag = KsmUtil.upload(access_token, objId, clientFileData, "client.txt");
        if (flag.startsWith(failedFlag)) {
            return flag;
        }
        flag = KsmUtil.upload(access_token, objId, screenShotData, "screen.jpg");
        if (flag.startsWith(failedFlag)) {
            return flag;
        }
        String nonce = UUID.randomUUID().toString();
        String timestamp = String.valueOf((int)(System.currentTimeMillis() / 1000L));
        String sign = KsmUtil.shaHex(timestamp, access_token, HttpClientUtil.SIGN_KEY, nonce);
        String type = "0";
        String params = String.format("title=%s&desc=%s&phone=%s&type=%s&linkman=%s&access_token=%s&timestamp=%s&sign=%s&objID=%s&nonce=%s&mobile=%s", URLEncoder.encode(title, "utf-8"), URLEncoder.encode(desc, "utf-8"), phone, type, URLEncoder.encode(user, "utf-8"), access_token, timestamp, sign, objId, nonce, phone);
        String result = HttpClientUtil.sendPost(prefixUrl + "saveFeedback", params);
        JSONObject obj = JSONObject.fromObject((Object)result);
        if (obj.getInt("errCode") == 0) {
            String feedBackNumber = ((JSONObject)obj.get("data")).get("feedbackNumber").toString();
            return feedBackNumber;
        }
        return AdvMsgBox.getResString(submitFail) + obj.get("msg");
    }

    public static boolean matcheInfomation(String str, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    static {
        if (StringUtils.isEmpty((String)prefixUrl)) {
            prefixUrl = "http://172.19.76.39:8080/openaccess/";
        }
    }
}

