/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class PropFileUtil {
    private static final Logger logger = Logger.getLogger(PropFileUtil.class);

    public static void loadConfigureProp(String configureFile, String[] syspropkeys) {
        try {
            FileInputStream is = new FileInputStream(new File(configureFile));
            PropFileUtil.loadConfigureProp(is, syspropkeys);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"file not found", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadConfigureProp(InputStream is, String[] syspropkeys) {
        Properties prop = new Properties();
        try {
            int i;
            prop.load(is);
            String[] keys = null;
            if (syspropkeys == null || syspropkeys.length <= 0) {
                keys = new String[prop.size()];
                i = 0;
                Enumeration<?> enumn = prop.propertyNames();
                while (enumn.hasMoreElements()) {
                    keys[i++] = (String)enumn.nextElement();
                }
            } else {
                keys = syspropkeys;
            }
            for (i = 0; i < keys.length; ++i) {
                String content = prop.getProperty(keys[i]);
                PropFileUtil.loadOneProp(content, keys[i]);
            }
        }
        catch (Exception e) {
            logger.error((Object)"load server env error", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void loadOneProp(String content, String key) {
        String value = content;
        value = PropFileUtil.getInfactValue(value);
        System.setProperty(key, value);
    }

    private static String getInfactValue(String value) {
        String regexp = "%[^%]+%";
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            String var = matcher.group();
            value = value.replaceAll(var, PropFileUtil.getSysPropWithPercent(var));
        }
        return value;
    }

    private static String getSysPropWithPercent(String prop) {
        if (prop != null && prop.length() > 2) {
            String factprop = prop.substring(1, prop.length() - 1);
            return System.getProperty(factprop) == null ? "" : System.getProperty(factprop);
        }
        return "";
    }

    public static void main(String[] args) {
        PropFileUtil.getInfactValue("%EAS_HOME%CLIENT/BIN/%1EAS_HOME%/%asdf");
    }
}

