/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db2.MakeSql;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db2.bean.FileInfoBean;
import com.kingdee.eas.common.app.AbstractPrintConfigFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PrintConfigFacadeControllerBean
extends AbstractPrintConfigFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.common.app.PrintConfigFacadeControllerBean");
    private static final String INSERT_DEFAULT_TEMPLATE_SQL = "insert into t_rpt_defTemplate values({0},{1},{2})";
    private static final String UPDATE_DEFAULT_TEMPLATE_SQL = "update t_rpt_defTemplate set fdeftemplate = {2} where forguser = {0} and ftemppath = {1}";
    private static final String GET_DEFAULT_TEMPLATE_SQL = "select fdeftemplate from t_rpt_defTemplate where forguser = {0} and ftemppath = {1}";
    private static final String GET_DEFAULT_TEMPLATE_SQL_PRE = "select fdeftemplate from t_rpt_defTemplate where forguser = ? and ftemppath = ?";
    private static final String DELETE_DEFALUT_TEMPLATE_SQL = "delete from t_rpt_defTemplate where forguser = {0} and ftemppath = {1}";

    @Override
    protected void _setDefalutTemplate(Context ctx, String orgUser, String templatePath, String defaultTemplateName) throws BOSException {
        String sql1 = MessageFormat.format(GET_DEFAULT_TEMPLATE_SQL, "'" + orgUser + "'", "'" + templatePath + "'");
        IRowSet defaultTemplateRowSet = DbUtil.executeQuery(ctx, sql1);
        String sql = defaultTemplateRowSet.size() > 0 ? UPDATE_DEFAULT_TEMPLATE_SQL : INSERT_DEFAULT_TEMPLATE_SQL;
        DbUtil.execute(ctx, MessageFormat.format(sql, "'" + orgUser + "'", "'" + templatePath + "'", "'" + defaultTemplateName + "'"));
    }

    @Override
    protected void _deleteDefaultTemplate(Context ctx, String orgUser, String templatePath) throws BOSException {
        DbUtil.execute(ctx, MessageFormat.format(DELETE_DEFALUT_TEMPLATE_SQL, "'" + orgUser + "'", "'" + templatePath + "'"));
    }

    @Override
    protected String _getDefaultTemplate(Context ctx, String orgUser, String templatePath) throws BOSException {
        Object[] param = new Object[]{orgUser, templatePath};
        IRowSet defaultTemplateRowSet = DbUtil.executeQuery(ctx, GET_DEFAULT_TEMPLATE_SQL_PRE, param);
        String defaultTemplate = "";
        try {
            while (defaultTemplateRowSet.next()) {
                defaultTemplate = defaultTemplateRowSet.getString("fdeftemplate");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return defaultTemplate;
    }

    @Override
    protected HashMap _getPrintAttributes(Context ctx, String path) throws BOSException {
        Path directPath = Path.valueOf((String)("/eas/EAS_Note.kdrs" + path));
        FileInfoBean bean = null;
        try {
            bean = this.lookupFile(ctx, directPath);
            if (bean == null) {
                return new HashMap();
            }
            return this.getAttributes(ctx, bean.getFid());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return new HashMap();
        }
    }

    private FileInfoBean lookupFile(Context ctx, Path path) throws BOSException, SQLException {
        Object[] parm;
        IRowSet rowSet = null;
        String sql = MakeSql.lookup_file((boolean)false);
        rowSet = DbUtil.executeQuery(ctx, sql, parm = new Object[]{path.deep(), path.getPathText().toLowerCase()});
        if (rowSet.next()) {
            FileInfoBean bean = new FileInfoBean(rowSet.getString(1), Path.valueOf((String)rowSet.getString(2)), rowSet.getInt(3) == 1);
            return bean;
        }
        return null;
    }

    private HashMap getAttributes(Context ctx, String fid) throws BOSException, SQLException {
        String sql = MakeSql.load_attributes();
        Object[] parm = new Object[]{fid};
        IRowSet rowSet = null;
        HashMap<String, String> attrs = null;
        rowSet = DbUtil.executeQuery(ctx, sql, parm);
        while (rowSet.next()) {
            String attrName = rowSet.getString(1);
            String attrVal = null;
            if (rowSet.getBoolean(2)) {
                attrVal = rowSet.getString(3);
            } else {
                byte[] valBytes = rowSet.getBytes(4);
                attrVal = new String(valBytes);
            }
            if (attrs == null) {
                attrs = new HashMap<String, String>();
            }
            attrs.put(attrName, attrVal);
        }
        return attrs;
    }

    @Override
    protected String _getGuideUrl(Context ctx, String part) throws BOSException {
        String sql = "SELECT FGUIDEURL FROM T_RPT_GUIDEDOC WHERE FGUIDEPART =?";
        Object[] params = new Object[]{part};
        IRowSet rowSet = null;
        String guideUrl = null;
        rowSet = DbUtil.executeQuery(ctx, sql, params);
        try {
            while (rowSet.next()) {
                guideUrl = rowSet.getString("FGUIDEURL");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return guideUrl;
    }

    @Override
    public IRowSet readPaperSettingConfig(Context ctx, String tempplatePath, String userId) throws BOSException {
        String selectsql = "SELECT * FROM T_RPTS_USERCUSTOMPAPERCONFIG WHERE FTEMPLATEPATH =? AND FUSERID=?";
        Object[] selectparams = new Object[]{tempplatePath, userId};
        IRowSet rowSet = null;
        rowSet = DbUtil.executeQuery(ctx, selectsql, selectparams);
        return rowSet;
    }

    @Override
    public void writePaperSettingConfig(Context ctx, String tempplatePath, String paperSettingConfig, String userId, byte[] image) throws BOSException {
        String selectsql = "SELECT 1 FROM T_RPTS_USERCUSTOMPAPERCONFIG WHERE FTEMPLATEPATH =? AND FUSERID=?";
        String updatesql = "UPDATE T_RPTS_USERCUSTOMPAPERCONFIG set FCONFIGXML=?,FIMAGE=? WHERE FTEMPLATEPATH =? AND FUSERID=?";
        String insertsql = "INSERT INTO T_RPTS_USERCUSTOMPAPERCONFIG(FUSERID,FTEMPLATEPATH ,FCONFIGXML,FIMAGE) VALUES(?,?,?,?)";
        Object[] selectparams = new Object[]{tempplatePath, userId};
        Object[] updateparams = new Object[]{paperSettingConfig, image, tempplatePath, userId};
        Object[] insertparams = new Object[]{userId, tempplatePath, paperSettingConfig, image};
        IRowSet rowSet = null;
        rowSet = DbUtil.executeQuery(ctx, selectsql, selectparams);
        try {
            if (rowSet.next()) {
                DbUtil.execute(ctx, updatesql, updateparams);
            } else {
                DbUtil.execute(ctx, insertsql, insertparams);
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql\u5f02\u5e38:", (Throwable)e);
        }
    }
}

