/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.view.BusinessObjectBriefView;
import com.kingdee.bos.metadata.view.MetaDataBriefViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemEnum;
import com.kingdee.eas.common.app.AbstractSubSystemFacadeControllerBean;
import com.kingdee.eas.common.app.cluster.FileClusterFactory;
import com.kingdee.eas.common.app.cluster.IFileCluster;
import com.kingdee.eas.common.subsystemhelper.BusinessObjectBriefViewHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class SubSystemFacadeControllerBean
extends AbstractSubSystemFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.common.app.SubSystemFacadeControllerBean");

    @Override
    protected void _delAllSubSystemFile(Context ctx) throws BOSException, EASBizException {
        List subSystemList = SubSystemEnum.getEnumList();
        int size = subSystemList.size();
        for (int i = 0; i < size; ++i) {
            SubSystemEnum subSystemTemp = (SubSystemEnum)((Object)subSystemList.get(i));
            String fileName = subSystemTemp.getValue();
            IFileCluster iFileCluster = FileClusterFactory.getFileCluster(ctx);
            iFileCluster.delFile(fileName);
        }
    }

    private String getUserCustomFileName(String fileName) {
        return fileName + "_custom.mdbview";
    }

    @Override
    protected BusinessObjectBriefView _getSubSystemByName(Context ctx, String subSystemFileName) throws BOSException, EASBizException {
        IFileCluster iFileCluster = FileClusterFactory.getFileCluster(ctx);
        IObjectValue iov = null;
        try {
            iov = iFileCluster.getFileVo(subSystemFileName);
        }
        catch (DataAccessException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (iov != null && iov instanceof MetaDataBriefViewInfo) {
            BusinessObjectBriefViewHelper helper = new BusinessObjectBriefViewHelper();
            return helper.getBusinessObjectBriefView((MetaDataBriefViewInfo)iov);
        }
        return null;
    }

    @Override
    protected void _saveSubSystem(Context ctx, String subSystemName, MetaDataBriefViewInfo viewInfo) throws BOSException, EASBizException {
        IFileCluster iFileCluster = FileClusterFactory.getFileCluster(ctx);
        try {
            iFileCluster.saveMdbView(ctx, subSystemName, MetaDataTypeList.METADATABRIEFVIEW, (AbstractMetaDataValue)viewInfo);
        }
        catch (DataAccessException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _startUserCustom(Context ctx, String SubSystemName) throws BOSException, EASBizException {
        IFileCluster iFileCluster = FileClusterFactory.getFileCluster(ctx);
        return iFileCluster.haveThisFile(SubSystemName);
    }

    @Override
    protected void _delSubSystemFileByName(Context ctx, String subSystemName) throws BOSException, EASBizException {
        IFileCluster iFileCluster = FileClusterFactory.getFileCluster(ctx);
        iFileCluster.delFile(subSystemName);
    }
}

