/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.app.cluster;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.EASObject;
import com.kingdee.eas.common.app.cluster.IFileCluster;
import com.kingdee.eas.common.subsystemhelper.UserCustomSubSystem;
import com.kingdee.eas.common.utils.MetadataUtils;
import com.kingdee.eas.common.utils.XMLStoreHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FileClusterImpl
extends EASObject
implements IFileCluster {
    private static Logger logger = Logger.getLogger((String)FileClusterImpl.class.getName());
    private static XMLStoreHelper xmlStoreHelper = null;
    private static final String FILECLUSTERIMPL_DELFILE = "FileClusterImpl.delFile:";

    private String getUserCustomFullFileName(String subSystemName) {
        return UserCustomSubSystem.USER_CUSTOM_CONFIG_PATH + File.separator + subSystemName + "_custom.mdbview";
    }

    private String getUserCustomFileName(String subSystemName) {
        return subSystemName + "_custom.mdbview";
    }

    @Override
    public void delPermFile() {
        String fullFileName = UserCustomSubSystem.PERM_SUBSYSTEM_FULL_NAME;
        this.innerDelFile(fullFileName);
    }

    @Override
    public void delFile(String subSystemName) {
        String fullFileName = this.getUserCustomFullFileName(subSystemName);
        this.innerDelFile(fullFileName);
    }

    private void innerDelFile(String fullFileName) {
        File myFile;
        File myBakFile = new File(fullFileName + ".bak");
        if (myBakFile.exists()) {
            myBakFile.delete();
        }
        if ((myFile = new File(fullFileName)).exists()) {
            myFile.renameTo(new File(fullFileName + ".bak"));
        }
    }

    @Override
    public IObjectValue getFileVo(String subSystemName) throws DataAccessException, FileNotFoundException {
        String fullFileName = this.getUserCustomFullFileName(subSystemName);
        return this.innerGetFileVo(fullFileName, UserCustomSubSystem.USER_CUSTOM_CONFIG_PATH);
    }

    @Override
    public IObjectValue getPermFileVo() throws DataAccessException, FileNotFoundException {
        return this.innerGetFileVo(UserCustomSubSystem.PERM_SUBSYSTEM_FULL_NAME, UserCustomSubSystem.PERM_SUBSYSTEM_DIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectValue innerGetFileVo(String fullFileName, String subsystemPath) throws DataAccessException, FileNotFoundException {
        Context myCtx = new Context();
        myCtx.put((Object)"METADATAPATH", (Object)subsystemPath);
        XMLStoreHelper xmlHelper = FileClusterImpl.getXMLStoreHelper(myCtx);
        xmlHelper.setBosType(MetaDataTypeList.METADATABRIEFVIEW);
        File file = new File(fullFileName);
        if (file.exists()) {
            FileInputStream fs = new FileInputStream(file);
            try {
                IObjectValue iObjectValue = xmlHelper.load(fs);
                return iObjectValue;
            }
            finally {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static XMLStoreHelper getXMLStoreHelper(Context ctx) throws DataAccessException {
        if (xmlStoreHelper == null) {
            xmlStoreHelper = new XMLStoreHelper(ctx);
        }
        return xmlStoreHelper;
    }

    @Override
    public boolean haveThisFile(String subSystemName) {
        String fullFileName = this.getUserCustomFullFileName(subSystemName);
        return this.innerHasThisFile(fullFileName);
    }

    @Override
    public boolean havePermFile() {
        return this.innerHasThisFile(UserCustomSubSystem.PERM_SUBSYSTEM_FULL_NAME);
    }

    private boolean innerHasThisFile(String fullFileName) {
        File myFile = new File(fullFileName);
        return myFile.exists();
    }

    private void innerSaveMdbView(Context ctx, String filePath, String fileName, BOSObjectType objType, AbstractMetaDataValue data) throws IOException, DataAccessException {
        File myFile = new File(filePath);
        if (!myFile.exists()) {
            myFile.mkdir();
        }
        Context myCtx = new Context();
        if (ctx != null) {
            myCtx.setLocale(ctx.getLocale());
        }
        myCtx.put((Object)"METADATAPATH", (Object)filePath);
        MetadataUtils.saveMdbView(myCtx, filePath, fileName, objType, data);
    }

    @Override
    public void saveMdbView(Context ctx, String subSystemName, BOSObjectType objType, AbstractMetaDataValue data) throws IOException, DataAccessException {
        String subSystemPath = UserCustomSubSystem.USER_CUSTOM_CONFIG_PATH;
        String fileName = this.getUserCustomFileName(subSystemName);
        this.innerSaveMdbView(ctx, subSystemPath, fileName, objType, data);
    }

    @Override
    public void savePermMdbView(Context ctx, BOSObjectType objType, AbstractMetaDataValue data) throws IOException, DataAccessException {
        this.innerSaveMdbView(ctx, UserCustomSubSystem.PERM_SUBSYSTEM_DIR, "userCustomPerm.permission", objType, data);
    }
}

