/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.RefCheckInfo;
import com.kingdee.eas.common.RefChkFilterSet;
import com.kingdee.eas.common.ReferenceObject;
import com.kingdee.eas.common.app.dao.ReferenceCheckSqlBuilder;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.Collection2StrSuper;
import com.kingdee.eas.util.EntityCompositionBuilder;
import com.kingdee.eas.util.EntityRefBuilder;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;

public class ReferenceDAO {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.common.app.dao.ReferenceDAO");
    private static final int COUNTPERSUBMIT = 50;
    private static HashSet isUsed = new HashSet();

    protected static Connection getConnection(Context ctx) throws SQLException {
        return EJBFactory.getConnection((Context)ctx);
    }

    public static boolean isReferenced(Context ctx, BOSUuid objID) throws BizReferenceException {
        return ReferenceDAO.isReferencedNew(ctx, objID);
    }

    public static BizReference getReference(Context ctx, BOSUuid objID) throws BizReferenceException {
        return ReferenceDAO.getReferenceNew(ctx, objID);
    }

    private static StringBuffer getCheckDataSql(StringBuffer sql, ResultSet rs, String objID) throws SQLException {
        String FRefTableName = rs.getString(1);
        String FRefFieldName = rs.getString(2);
        String FRefEntityName = StringEscapeUtils.escapeSql((String)rs.getString(3));
        String FRefEntityAlias_L1 = StringEscapeUtils.escapeSql((String)rs.getString(4));
        String FRefEntityAlias_L2 = StringEscapeUtils.escapeSql((String)rs.getString(5));
        String FRefEntityAlias_L3 = StringEscapeUtils.escapeSql((String)rs.getString(6));
        if (sql.length() > 0) {
            sql.append(" union all ");
        }
        sql.append(" select ");
        sql.append("'" + FRefTableName + "',");
        sql.append("'" + FRefFieldName + "',");
        sql.append("'" + FRefEntityName + "',");
        sql.append("'" + FRefEntityAlias_L1 + "',");
        sql.append("'" + FRefEntityAlias_L2 + "',");
        sql.append("'" + FRefEntityAlias_L3 + "' ");
        sql.append(" where exists (select ");
        sql.append(FRefFieldName);
        sql.append(" from ");
        sql.append(FRefTableName);
        sql.append(" where ");
        sql.append(FRefFieldName);
        sql.append(" = '");
        sql.append(objID);
        sql.append("' ");
        sql.append(" ) ");
        return sql;
    }

    public static void removeErrorReferenced(Context ctx) {
        Connection conn = null;
        try {
            conn = ReferenceDAO.getConnection(ctx);
            ReferenceDAO.removeErrorReferenced(conn);
        }
        catch (SQLException e1) {
            logger.error((Object)"BizReferenceException", (Throwable)((Object)new BizReferenceException(BizReferenceException.SQL_ERR, e1)));
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private static void removeNotExistTableOnFirst(Context ctx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeErrorReferenced(Connection conn) {
        ArrayList list = ReferenceDAO.getErrorReferenced(conn);
        StringBuffer deleteSql = new StringBuffer("delete from T_SYS_EntityRef where 1=2 ");
        StringBuffer cond = new StringBuffer();
        Statement stat = null;
        try {
            stat = conn.createStatement();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                BizReference br = (BizReference)list.get(i);
                cond.append(" or (FRefTableName='").append(br.getRefTableName()).append("'").append(" and FRefFieldName='").append(br.getRefFieldName()).append("') ");
                if (i % 50 != 0 && i != size - 1) continue;
                String sql = deleteSql.toString() + cond.toString();
                stat.addBatch(sql);
                cond.setLength(0);
            }
            if (list.size() > 0) {
                stat.executeBatch();
            }
        }
        catch (SQLException e1) {
            logger.error((Object)"BizReferenceException", (Throwable)e1);
        }
        finally {
            SQLUtils.cleanup((Statement)stat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeErrorEntryHeadReference(Connection conn) {
        StringBuffer sql = new StringBuffer();
        boolean isSQLServer = ReferenceDAO.isSQLServer(conn);
        if (isSQLServer) {
            sql.append("/*dialect*/ ").append("DELETE FROM t_sys_entryhead WHERE NOT EXISTS (SELECT 1 FROM sysobjects sysobj ").append("WHERE FHeadTableName COLLATE Chinese_PRC_CI_AS = SYSOBJ.NAME COLLATE Chinese_PRC_CI_AS )").append("OR NOT EXISTS (SELECT 1 FROM syscolumns syscol left join sysobjects sysobj ").append("on syscol.id = sysobj.id WHERE FEntryTableName COLLATE Chinese_PRC_CI_AS = SYSOBJ.NAME COLLATE Chinese_PRC_CI_AS ").append("AND FRelationFieldName COLLATE Chinese_PRC_CI_AS = SYSCOL.NAME COLLATE Chinese_PRC_CI_AS )");
        } else {
            sql.append("delete from t_sys_entryhead where not exists").append("(select 1 from KSQL_USERTABLES ").append("where upper(FHeadTableName) = upper(KSQL_TABNAME)) ").append("or not exists(select 1 from KSQL_USERCOLUMNS ").append("where upper(FEntryTableName) = upper(KSQL_COL_TABNAME) and upper(FRelationFieldName) = upper(KSQL_COL_NAME))");
        }
        Statement ps = null;
        try {
            ps = conn.createStatement();
            ps.execute(sql.toString());
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps);
        }
    }

    public static boolean isSQLServer(Connection conn) {
        boolean isSQLServer;
        if (conn instanceof KDConnection) {
            logger.info((Object)"************conn is KDConnection**************");
            isSQLServer = ((KDConnection)conn).getDbType() == 3;
        } else {
            logger.info((Object)"************conn is not KDConnection**************");
            Context ctx = ContextUtils.getContextFromSessionNoException();
            Object dbType = ctx.get((Object)"dbType");
            isSQLServer = dbType != null && "MS SQL Server".equalsIgnoreCase(dbType.toString());
        }
        return isSQLServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getErrorReferenced(Connection conn) {
        ArrayList<BizReference> errorRef;
        block8: {
            errorRef = new ArrayList<BizReference>();
            ResultSet rs = null;
            Statement ps = null;
            try {
                boolean isSQLServer = ReferenceDAO.isSQLServer(conn);
                StringBuffer sql = new StringBuffer();
                if (isSQLServer) {
                    sql.append("/*dialect*/ ").append("SELECT a.FBosType, a.FRefTableName, a.FRefFieldName, a.FRefEntityName,").append(" a.FRefEntityAlias_L1, a.FRefEntityAlias_L2, a.FRefEntityAlias_L3 ").append("FROM t_sys_entityref a LEFT OUTER JOIN syscolumns syscol left join sysobjects sysobj ").append("on syscol.id = sysobj.id ON (a.freftablename COLLATE Chinese_PRC_CI_AS = SYSOBJ.NAME ").append("COLLATE Chinese_PRC_CI_AS AND a.freffieldname COLLATE Chinese_PRC_CI_AS = SYSCOL.NAME COLLATE Chinese_PRC_CI_AS) ").append("WHERE (a.FIsBosFK = 1 AND (SYSOBJ.NAME IS NULL)) ORDER BY a.FOrder DESC");
                } else {
                    sql.append("select a.FBosType,a.FRefTableName,a.FRefFieldName,a.FRefEntityName,a.FRefEntityAlias_L1,").append("a.FRefEntityAlias_L2,a.FRefEntityAlias_L3 from t_sys_entityref a left join  KSQL_USERCOLUMNS ").append("on upper(a.freftablename)=upper(KSQL_COL_TABNAME) and upper(a.freffieldname)=upper(KSQL_COL_NAME) ").append("where a.FIsBosFK=1 and KSQL_COL_TABNAME is  null order by a.FOrder desc");
                }
                ps = conn.createStatement();
                rs = ps.executeQuery(sql.toString());
                while (rs.next()) {
                    BizReference br = new BizReference();
                    br.setRefEntityName(rs.getString("FRefEntityName") + "[" + rs.getString("FBosType") + "]");
                    br.setRefFieldName(rs.getString("FRefFieldName"));
                    br.setRefTableName(rs.getString("FRefTableName"));
                    br.setRefEntityAlias_L2(rs.getString("FRefEntityAlias_L2"));
                    errorRef.add(br);
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
            catch (SQLException se) {
                logger.error((Object)"getErrorReferenced:", (Throwable)se);
                break block8;
            }
            finally {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(ps);
            }
            SQLUtils.cleanup((Statement)ps);
        }
        return errorRef;
    }

    public static ArrayList getErrorReferenced(Context ctx) {
        Connection conn = null;
        try {
            conn = ReferenceDAO.getConnection(ctx);
            ArrayList arrayList = ReferenceDAO.getErrorReferenced(conn);
            return arrayList;
        }
        catch (SQLException e1) {
            logger.error((Object)"BizReferenceException", (Throwable)((Object)new BizReferenceException(BizReferenceException.SQL_ERR, e1)));
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return new ArrayList();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isReferenced(Context ctx, BOSUuid objID, RefChkFilterSet fc) {
        boolean found = false;
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        Statement stat2 = null;
        ResultSet rsTemp = null;
        String sql4RefTableName = fc.getSQL4RefTableName();
        String matched = new StringBuffer().append("select ").append("FRefTableName,").append("FRefFieldName ").append("FROM T_SYS_EntityRef ").append("where FIsBosFK=1 and FBosType=? ").append(sql4RefTableName).append("order by FOrder desc").toString();
        try {
            conn = ReferenceDAO.getConnection(ctx);
            ps = conn.prepareStatement(matched);
            ps.setString(1, objID.getType().toString());
            stat2 = conn.createStatement();
            rs = ps.executeQuery();
            String id = objID.toString();
            String sql4CU = fc.getSQL4CU();
            found = ReferenceDAO.isReferencedInner(ctx, rs, id, sql4CU, stat2, rsTemp);
        }
        catch (SQLException e1) {
            try {
                logger.error((Object)"BizReferenceException", (Throwable)e1);
                throw new RuntimeException((Throwable)((Object)new BizReferenceException(BizReferenceException.REFERENCE_DATA_ERROR, e1)));
                catch (BizReferenceException e) {
                    throw new RuntimeException((Throwable)((Object)new BizReferenceException(BizReferenceException.REFERENCE_DATA_ERROR, (Throwable)((Object)e))));
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(rsTemp);
                SQLUtils.cleanup((Statement)ps);
                SQLUtils.cleanup(stat2);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup(rsTemp);
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Statement)stat2);
        SQLUtils.cleanup((Connection)conn);
        return found;
    }

    private static boolean isReferencedNew(Context ctx, BOSUuid objID) throws BizReferenceException {
        ReferenceDAO.removeNotExistTableOnFirst(ctx);
        boolean found = false;
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        Statement stat2 = null;
        ResultSet rsTemp = null;
        String matched = new StringBuffer().append("select ").append("FRefTableName,").append("FRefFieldName ").append("FROM T_SYS_EntityRef ").append("where FIsBosFK=1 and FBosType=? ").append("order by FOrder desc").toString();
        boolean step1 = false;
        try {
            conn = ReferenceDAO.getConnection(ctx);
            ps = conn.prepareStatement(matched);
            ps.setString(1, objID.getType().toString());
            stat2 = conn.createStatement();
            rs = ps.executeQuery();
            String id = objID.toString();
            found = ReferenceDAO.isReferencedInner(ctx, rs, id, null, stat2, rsTemp);
        }
        catch (SQLException e1) {
            try {
                logger.error((Object)"BizReferenceException", (Throwable)((Object)new BizReferenceException(BizReferenceException.SQL_ERR, e1)));
                throw new BizReferenceException(BizReferenceException.REFERENCE_DATA_ERROR, e1);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(rsTemp);
                SQLUtils.cleanup((Statement)ps);
                SQLUtils.cleanup(stat2);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup(rsTemp);
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Statement)stat2);
        SQLUtils.cleanup((Connection)conn);
        return found;
    }

    private static boolean isReferencedInner(Context ctx, ResultSet rs, String objID, String sql4CU, Statement stat2, ResultSet rsTemp) throws BizReferenceException {
        boolean found = false;
        try {
            if (rs == null || stat2 == null) {
                return false;
            }
            String sqlFirst = new String("select 1 where  ");
            StringBuffer sqlAll = new StringBuffer(sqlFirst);
            int i = 1;
            boolean isExecuted = false;
            boolean isFirst = true;
            while (rs.next()) {
                sqlAll = ReferenceDAO.getCheckSql(ctx, isFirst, sqlAll, rs, objID, sql4CU);
                isFirst = false;
                isExecuted = false;
                if (i % 50 == 0) {
                    rsTemp = stat2.executeQuery(sqlAll.toString());
                    isExecuted = true;
                    if (rsTemp.next()) {
                        found = true;
                        break;
                    }
                    sqlAll.setLength(0);
                    sqlAll.append(sqlFirst);
                    isFirst = true;
                }
                ++i;
            }
            if (sqlAll.length() > 0 && !isExecuted && i > 1 && (rsTemp = stat2.executeQuery(sqlAll.toString())).next()) {
                found = true;
            }
        }
        catch (SQLException se) {
            logger.error((Object)"BizReferenceException", (Throwable)((Object)new BizReferenceException(BizReferenceException.SQL_ERR, se)));
            BizReferenceException bizExc = new BizReferenceException(BizReferenceException.REFERENCE_DATA_ERROR, se);
            logger.error((Object)bizExc.getMessage(), (Throwable)((Object)bizExc));
        }
        return found;
    }

    private static StringBuffer getCheckSql(Context ctx, boolean isFirst, StringBuffer sql, ResultSet rs, String objID, String sql4CU) throws SQLException {
        if (!isFirst) {
            sql.append(" or ");
        }
        String fieldName = rs.getString("FRefFieldName");
        String tableName = rs.getString("FRefTableName");
        String partSql = ReferenceCheckSqlBuilder.getCheckSqlWithCU(ctx, tableName, fieldName, sql4CU, objID);
        sql.append(" exists ( ");
        sql.append(partSql);
        sql.append(" ) ");
        return sql;
    }

    private static List isRefenceInRefTable(Context ctx, BOSObjectType bizObjType, RefChkFilterSet refCheckFilterSet) {
        ArrayList<RefCheckInfo> retList = new ArrayList<RefCheckInfo>();
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        String matched = "select FRefTableName,FRefFieldName from T_SYS_EntityRef  where FIsBosFK=1 and FBosType=? ";
        if (refCheckFilterSet != null) {
            matched = matched + refCheckFilterSet.getSQL4RefTableName();
        }
        try {
            conn = ReferenceDAO.getConnection(ctx);
            ps = conn.prepareStatement(matched);
            ps.setString(1, bizObjType.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                RefCheckInfo refCheckInfo = new RefCheckInfo();
                refCheckInfo.setTableName(rs.getString("FRefTableName"));
                refCheckInfo.setFieldName(rs.getString("FRefFieldName"));
                retList.add(refCheckInfo);
            }
        }
        catch (SQLException e1) {
            try {
                logger.error((Object)"BizReferenceException", (Throwable)((Object)new BizReferenceException(BizReferenceException.SQL_ERR, e1)));
                throw new RuntimeException((Throwable)((Object)new BizReferenceException(BizReferenceException.REFERENCE_DATA_ERROR, e1)));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return retList;
    }

    private static BizReference getReferenceNew(Context ctx, BOSUuid objID) {
        ResultSet rsTemp;
        Statement stat2;
        PreparedStatement ps;
        ResultSet rs;
        Connection conn;
        BizReference reference;
        block9: {
            ReferenceDAO.removeNotExistTableOnFirst(ctx);
            boolean found = false;
            reference = null;
            conn = null;
            rs = null;
            ps = null;
            stat2 = null;
            rsTemp = null;
            String matched = new StringBuffer().append("select ").append("FRefTableName,").append("FRefFieldName,").append("FRefEntityName,").append("FRefEntityAlias_L1,").append("FRefEntityAlias_L2,").append("FRefEntityAlias_L3 ").append("FROM T_SYS_EntityRef ").append("where FIsBosFK=1 and FBosType=? ").append("order by FOrder desc").toString();
            try {
                conn = ReferenceDAO.getConnection(ctx);
                ps = conn.prepareStatement(matched);
                ps.setString(1, objID.getType().toString());
                stat2 = conn.createStatement();
                rs = ps.executeQuery();
                String id = objID.toString();
                StringBuffer sql = new StringBuffer();
                int i = 1;
                boolean hasExecuted = false;
                while (rs.next()) {
                    sql = ReferenceDAO.getCheckDataSql(sql, rs, id);
                    hasExecuted = false;
                    if (i % 50 == 0) {
                        rsTemp = stat2.executeQuery(sql.toString());
                        hasExecuted = true;
                        if (rsTemp.next()) {
                            found = true;
                            break;
                        }
                        sql.setLength(0);
                    }
                    ++i;
                }
                if (sql.length() > 0 && !hasExecuted && (rsTemp = stat2.executeQuery(sql.toString())).next()) {
                    found = true;
                }
                if (!found) break block9;
                reference = new BizReference();
                if (rsTemp != null) {
                    reference.setRefTableName(rsTemp.getString(1));
                    reference.setRefFieldName(rsTemp.getString(2));
                    reference.setRefEntityName(rsTemp.getString(3));
                    reference.setRefEntityAlias_L1(rsTemp.getString(4));
                    reference.setRefEntityAlias_L2(rsTemp.getString(5));
                    reference.setRefEntityAlias_L3(rsTemp.getString(6));
                }
            }
            catch (SQLException e1) {
                try {
                    logger.error((Object)"BizReferenceException", (Throwable)((Object)new BizReferenceException(BizReferenceException.SQL_ERR, e1)));
                    throw new RuntimeException((Throwable)((Object)new BizReferenceException(BizReferenceException.REFERENCE_DATA_ERROR, e1)));
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    SQLUtils.cleanup(rsTemp);
                    SQLUtils.cleanup((Statement)ps);
                    SQLUtils.cleanup(stat2);
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup(rsTemp);
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Statement)stat2);
        SQLUtils.cleanup((Connection)conn);
        return reference;
    }

    private String formSql4Ref(Context ctx, String table, String fieldName, String idParamInfoStr, RefChkFilterSet refCheckFilterSet) {
        String sql4CU = null;
        if (refCheckFilterSet != null && refCheckFilterSet.getSQL4CU() != null) {
            sql4CU = refCheckFilterSet.getSQL4CU();
        }
        return ReferenceCheckSqlBuilder.getCheckSqlWithInCU(ctx, table, fieldName, sql4CU, idParamInfoStr, false);
    }

    private String formDetailSql4Ref(Context ctx, String table, String fieldName, String idParamInfoStr, RefChkFilterSet refCheckFilterSet) {
        String sql4CU = null;
        if (refCheckFilterSet != null && refCheckFilterSet.getSQL4CU() != null) {
            sql4CU = refCheckFilterSet.getSQL4CU();
        }
        return ReferenceCheckSqlBuilder.getCheckSqlWithInCU(ctx, table, fieldName, sql4CU, idParamInfoStr, true);
    }

    private Set addRefInfo(Context ctx, String table, String fieldName, List bizObjList, RefChkFilterSet refCheckFilterSet) throws BOSException {
        HashSet<String> retSet = new HashSet<String>();
        String sqlStr = "";
        try {
            sqlStr = this.formSql4Ref(ctx, table, fieldName, ToolUtils.aryToStr(bizObjList, true), refCheckFilterSet);
            IRowSet rowSet = DbUtil.executeQuery(ctx, sqlStr);
            while (rowSet.next()) {
                retSet.add(rowSet.getString(1));
            }
        }
        catch (Exception se) {
            logger.error((Object)("check obj ref, sql of form is error,but it's not mind! sql is:" + sqlStr), (Throwable)se);
        }
        return retSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set addDetailRefInfo(Context ctx, String table, String fieldName, List bizObjList, RefChkFilterSet refCheckFilterSet) throws BOSException {
        HashSet<ReferenceObject> retSet = new HashSet<ReferenceObject>();
        String sqlStr = "";
        IRowSet rowSet = null;
        try {
            sqlStr = this.formDetailSql4Ref(ctx, table, fieldName, ToolUtils.aryToStr(bizObjList, true), refCheckFilterSet);
            rowSet = DbUtil.executeQuery(ctx, sqlStr);
        }
        catch (Exception se) {
            logger.error((Object)("check obj ref, sql of form is error,but it's not mind! sql is:" + sqlStr), (Throwable)se);
        }
        ReferenceObject ob = null;
        try {
            while (rowSet != null && rowSet.next()) {
                ob = new ReferenceObject();
                try {
                    ob.setFownerid(rowSet.getString("fid"));
                    ob.setFTableName(table);
                    ob.setFkeyid(rowSet.getString(fieldName));
                    ob.setFnumber(rowSet.getString("Fnumber"));
                    if (ctx.getLocale() == Locale.SIMPLIFIED_CHINESE) {
                        ob.setFname(rowSet.getString("Fname_l2"));
                        continue;
                    }
                    if (ctx.getLocale() != Locale.TRADITIONAL_CHINESE) continue;
                    ob.setFname(rowSet.getString("Fname_l3"));
                }
                finally {
                    retSet.add(ob);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("check obj ref, sql of form is error,but it's not mind! sql is:" + sqlStr), (Throwable)e);
        }
        return retSet;
    }

    private Set addRefInfoNoLimits(Context ctx, String table, String fieldName, List bizObjList, RefChkFilterSet refCheckFilterSet) throws BOSException, BizReferenceException {
        HashSet retSet = new HashSet();
        Collection2StrSuper superCol = new Collection2StrSuper(bizObjList);
        while (superCol.hasNext()) {
            Set partSet = this.addRefInfo(ctx, table, fieldName, ToolUtils.trans2List(superCol.next()), refCheckFilterSet);
            retSet.addAll(partSet);
        }
        return retSet;
    }

    private Set addDetailRefInfoNoLimits(Context ctx, String table, String fieldName, List bizObjList, RefChkFilterSet refCheckFilterSet) throws BOSException, BizReferenceException {
        HashSet retSet = new HashSet();
        Collection2StrSuper superCol = new Collection2StrSuper(bizObjList);
        while (superCol.hasNext()) {
            Set partSet = this.addDetailRefInfo(ctx, table, fieldName, ToolUtils.trans2List(superCol.next()), refCheckFilterSet);
            retSet.addAll(partSet);
        }
        return retSet;
    }

    private Set addRefInfoNoLimits(Context ctx, String table, String fieldName, String sql, RefChkFilterSet refCheckFilterSet) throws BOSException {
        HashSet<String> retSet = new HashSet<String>();
        String sqlStr = "";
        try {
            sqlStr = this.formSql4Ref(ctx, table, fieldName, sql, refCheckFilterSet);
            IRowSet rowSet = DbUtil.executeQuery(ctx, sqlStr);
            while (rowSet.next()) {
                retSet.add(rowSet.getString(1));
            }
        }
        catch (Exception se) {
            logger.error((Object)("check obj ref, sql of form is error,but it's not mind! sql is:" + sqlStr), (Throwable)se);
        }
        return retSet;
    }

    public Set isReferenced(Context ctx, List bizObjList) throws BOSException, BizReferenceException {
        return this.isReferenced(ctx, bizObjList, null);
    }

    public Set isReferenced(Context ctx, String bizObjSql, BOSObjectType bizObjType) throws BOSException, BizReferenceException {
        return this.isReferenced(ctx, bizObjSql, bizObjType, null);
    }

    public Set isReferenced(Context ctx, List bizObjList, RefChkFilterSet refCheckFilterSet) throws BizReferenceException, BOSException {
        ReferenceDAO.removeNotExistTableOnFirst(ctx);
        HashSet retSet = new HashSet();
        if (bizObjList == null || bizObjList.isEmpty()) {
            return retSet;
        }
        BOSObjectType bizObjType = BOSUuid.read((String)((String)bizObjList.get(0))).getType();
        List refList = ReferenceDAO.isRefenceInRefTable(ctx, bizObjType, refCheckFilterSet);
        if (refList == null || refList.isEmpty()) {
            return retSet;
        }
        int size = refList.size();
        for (int i = 0; i < size; ++i) {
            RefCheckInfo refCheckInfo = (RefCheckInfo)refList.get(i);
            Set alreadySet = this.addRefInfoNoLimits(ctx, refCheckInfo.getTableName(), refCheckInfo.getFieldName(), bizObjList, refCheckFilterSet);
            if (alreadySet == null || alreadySet.isEmpty()) continue;
            retSet.addAll(alreadySet);
        }
        return retSet;
    }

    public Set isReferenced(Context ctx, List bizObjList, RefChkFilterSet refCheckFilterSet, boolean flag) throws BizReferenceException, BOSException {
        ReferenceDAO.removeNotExistTableOnFirst(ctx);
        HashSet retSet = new HashSet();
        if (bizObjList == null || bizObjList.isEmpty()) {
            return retSet;
        }
        BOSObjectType bizObjType = BOSUuid.read((String)((String)bizObjList.get(0))).getType();
        List refList = ReferenceDAO.isRefenceInRefTable(ctx, bizObjType, refCheckFilterSet);
        if (refList == null || refList.isEmpty()) {
            return retSet;
        }
        int size = refList.size();
        for (int i = 0; i < size; ++i) {
            RefCheckInfo refCheckInfo = (RefCheckInfo)refList.get(i);
            Set alreadySet = flag ? this.addDetailRefInfoNoLimits(ctx, refCheckInfo.getTableName(), refCheckInfo.getFieldName(), bizObjList, refCheckFilterSet) : this.addRefInfoNoLimits(ctx, refCheckInfo.getTableName(), refCheckInfo.getFieldName(), bizObjList, refCheckFilterSet);
            if (alreadySet == null || alreadySet.isEmpty()) continue;
            retSet.addAll(alreadySet);
        }
        return retSet;
    }

    public Set isReferenced(Context ctx, String bizObjSql, BOSObjectType bizObjType, RefChkFilterSet refCheckFilterSet) throws BizReferenceException, BOSException {
        ReferenceDAO.removeNotExistTableOnFirst(ctx);
        HashSet retSet = new HashSet();
        List refList = ReferenceDAO.isRefenceInRefTable(ctx, bizObjType, refCheckFilterSet);
        if (refList == null || refList.isEmpty()) {
            return retSet;
        }
        int size = refList.size();
        for (int i = 0; i < size; ++i) {
            RefCheckInfo refCheckInfo = (RefCheckInfo)refList.get(i);
            Set alreadySet = this.addRefInfoNoLimits(ctx, refCheckInfo.getTableName(), refCheckInfo.getFieldName(), bizObjSql, refCheckFilterSet);
            if (alreadySet == null || alreadySet.isEmpty()) continue;
            retSet.addAll(alreadySet);
        }
        return retSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rebuildReference(Context ctx) {
        boolean bl;
        Connection conn;
        block6: {
            conn = null;
            if (ctx != null) {
                conn = ReferenceDAO.getConnection(ctx);
                break block6;
            }
            boolean bl2 = false;
            SQLUtils.cleanup((Connection)conn);
            return bl2;
        }
        try {
            bl = ReferenceDAO.rebuildReference(conn);
        }
        catch (SQLException e) {
            boolean bl3;
            try {
                logger.error((Object)"BizReferenceException", (Throwable)((Object)new BizReferenceException(BizReferenceException.SQL_ERR, e)));
                bl3 = false;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
            SQLUtils.cleanup((Connection)conn);
            return bl3;
        }
        SQLUtils.cleanup((Connection)conn);
        return bl;
    }

    public static boolean rebuildReference(Connection conn) {
        boolean result = false;
        String metaPath = System.getProperty("metadata.path");
        return ReferenceDAO.rebuildReference(conn, metaPath);
    }

    public static boolean rebuildReference(Connection conn, String metaPath) {
        System.out.println("Start rebuildReference");
        boolean result = false;
        logger.debug((Object)("metaPath:" + metaPath));
        EntityRefBuilder entityRefBuilder = new EntityRefBuilder(metaPath, conn);
        result = entityRefBuilder.buildReference();
        if (!result) {
            return result;
        }
        long start = System.currentTimeMillis();
        EntityCompositionBuilder entityCompositionBuilder = new EntityCompositionBuilder(metaPath, conn);
        result = entityCompositionBuilder.buildReference();
        System.out.println("entityCompositionBuilder.buildReference() cost:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        ReferenceDAO.removeErrorReferenced(conn);
        System.out.println("removeErrorReferenced cost:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        ReferenceDAO.removeErrorEntryHeadReference(conn);
        System.out.println("removeErrorEntryHeadReference cost:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        ReferenceCheckSqlBuilder.clear();
        ReferenceDAO.handleEntityEnName(conn);
        return result;
    }

    public static void handleEntityEnName(Connection conn) {
        Statement stat = null;
        try {
            stat = conn.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.append(" update t_sys_entityref e set fentityalias_l1 = (                  ");
            sql.append(" select top 1 m.fmlres from t_Res_EntityResource r                 ");
            sql.append(" inner join T_Res_EntityMultiLan m on m.fresid = r.fid             ");
            sql.append(" where r.fkey = 'alias' and m.flanguage = 'en_US'                  ");
            sql.append(" and e.fentityname = r.ffilename                                   ");
            sql.append(" )                                                                 ");
            sql.append(" where exists(                                                     ");
            sql.append(" select r.ffilename, r.fres, m.fmlres from t_Res_EntityResource r  ");
            sql.append(" inner join T_Res_EntityMultiLan m on m.fresid = r.fid             ");
            sql.append(" where r.fkey = 'alias' and m.flanguage = 'en_US'                  ");
            sql.append(" and e.fentityname = r.ffilename                                   ");
            sql.append(" and e.fentityalias_l1 <> m.fmlres                                 ");
            sql.append(" )                                                                 ");
            stat.addBatch(sql.toString());
            sql = new StringBuffer();
            sql.append(" update t_sys_entityref e set frefentityalias_l1 = (               ");
            sql.append(" select top 1 m.fmlres from t_Res_EntityResource r                 ");
            sql.append(" inner join T_Res_EntityMultiLan m on m.fresid = r.fid             ");
            sql.append(" where r.fkey = 'alias' and m.flanguage = 'en_US'                  ");
            sql.append(" and e.frefentityname = r.ffilename                                ");
            sql.append(" )                                                                 ");
            sql.append(" where exists(                                                     ");
            sql.append(" select r.ffilename, r.fres, m.fmlres from t_Res_EntityResource r  ");
            sql.append(" inner join T_Res_EntityMultiLan m on m.fresid = r.fid             ");
            sql.append(" where r.fkey = 'alias' and m.flanguage = 'en_US'                  ");
            sql.append(" and e.frefentityname = r.ffilename                                ");
            sql.append(" and e.frefentityalias_l1 <> m.fmlres                              ");
            sql.append(" )                                                                 ");
            stat.addBatch(sql.toString());
            sql = new StringBuffer();
            sql.append(" update t_sys_entityref e set fentityalias_l3 = (                  ");
            sql.append(" select top 1 m.fmlres from t_Res_EntityResource r                 ");
            sql.append(" inner join T_Res_EntityMultiLan m on m.fresid = r.fid             ");
            sql.append(" where r.fkey = 'alias' and m.flanguage = 'zh_TW'                  ");
            sql.append(" and e.fentityname = r.ffilename                                   ");
            sql.append(" )                                                                 ");
            sql.append(" where exists(                                                     ");
            sql.append(" select r.ffilename, r.fres, m.fmlres from t_Res_EntityResource r  ");
            sql.append(" inner join T_Res_EntityMultiLan m on m.fresid = r.fid             ");
            sql.append(" where r.fkey = 'alias' and m.flanguage = 'zh_TW'                  ");
            sql.append(" and e.fentityname = r.ffilename                                   ");
            sql.append(" and e.fentityalias_l3 <> m.fmlres                                 ");
            sql.append(" )                                                                 ");
            stat.addBatch(sql.toString());
            sql = new StringBuffer();
            sql.append(" update t_sys_entityref e set frefentityalias_l3 = (               ");
            sql.append(" select top 1 m.fmlres from t_Res_EntityResource r                 ");
            sql.append(" inner join T_Res_EntityMultiLan m on m.fresid = r.fid             ");
            sql.append(" where r.fkey = 'alias' and m.flanguage = 'zh_TW'                  ");
            sql.append(" and e.frefentityname = r.ffilename                                ");
            sql.append(" )                                                                 ");
            sql.append(" where exists(                                                     ");
            sql.append(" select r.ffilename, r.fres, m.fmlres from t_Res_EntityResource r  ");
            sql.append(" inner join T_Res_EntityMultiLan m on m.fresid = r.fid             ");
            sql.append(" where r.fkey = 'alias' and m.flanguage = 'zh_TW'                  ");
            sql.append(" and e.frefentityname = r.ffilename                                ");
            sql.append(" and e.frefentityalias_l3 <> m.fmlres                              ");
            sql.append(" )                                                                 ");
            stat.addBatch(sql.toString());
            stat.executeBatch();
        }
        catch (SQLException e1) {
            logger.error((Object)"BizReferenceException", (Throwable)e1);
        }
        finally {
            SQLUtils.cleanup((Statement)stat);
        }
    }
}

