/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util;

import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.shell.Driver;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConnectionInfo {
    private String dataSource;
    private String userName;
    private String dbName;
    private int dbType;
    private String password;

    public ConnectionInfo() {
    }

    public ConnectionInfo(int type, String source, String db, String name, String pass) {
        this.dataSource = source;
        this.dbType = type;
        this.dbName = db;
        this.userName = name;
        this.password = KSqlUtil.decodePassword((String)pass);
    }

    public ConnectionInfo(String url, String name, String password) {
        url = KSqlUtil.decodeUrl((String)url);
        String sqlserverDriverPattern = "microsoft.jdbc.";
        String db2DriverPattern = "ibm.db2.";
        String oracleDriverPattern = "oracle.jdbc.";
        if (url.toLowerCase().indexOf(sqlserverDriverPattern) != -1) {
            String serverPattern = "//(\\S+):";
            String dbPattern = "DatabaseName=([\\S]+)";
            String portPattern = ":(\\d+);";
            Pattern p = Pattern.compile(serverPattern);
            Matcher m = p.matcher(url);
            if (m.find()) {
                this.dataSource = m.group(1);
            }
            this.dataSource = (m = (p = Pattern.compile(portPattern)).matcher(url)).find() ? this.dataSource + ":" + m.group(1) : this.dataSource + ":1433";
            p = Pattern.compile(dbPattern);
            m = p.matcher(url);
            if (m.find()) {
                this.dbName = m.group(1);
            }
            this.dbType = 3;
        } else if (url.toLowerCase().indexOf(db2DriverPattern) != -1) {
            String serverPattern = "//(\\S+):";
            String dbPattern = ":\\d+/([\\S]+)";
            String portPattern = ":(\\d+)/";
            Pattern p = Pattern.compile(serverPattern);
            Matcher m = p.matcher(url);
            if (m.find()) {
                this.dataSource = m.group(1);
            }
            this.dataSource = (m = (p = Pattern.compile(portPattern)).matcher(url)).find() ? this.dataSource + ":" + m.group(1) : this.dataSource + ":50000";
            p = Pattern.compile(dbPattern);
            m = p.matcher(url);
            if (m.find()) {
                this.dbName = m.group(1);
            }
            this.dbType = 1;
        } else if (url.toLowerCase().indexOf(oracleDriverPattern) != -1) {
            String serverPattern = ":@(\\S+):\\d+:";
            String dbPattern = ":\\d+:([\\S]+)";
            String portPattern = ":(\\d+):";
            Pattern p = Pattern.compile(serverPattern);
            Matcher m = p.matcher(url);
            if (m.find()) {
                this.dataSource = m.group(1);
            }
            this.dataSource = (m = (p = Pattern.compile(portPattern)).matcher(url)).find() ? this.dataSource + ":" + m.group(1) : this.dataSource + ":1521";
            p = Pattern.compile(dbPattern);
            m = p.matcher(url);
            if (m.find()) {
                this.dbName = m.group(1);
            }
            this.dbType = 2;
        }
        this.userName = name;
        this.password = KSqlUtil.decodePassword((String)password);
    }

    public String getKsqlUrl() {
        String url = "";
        switch (this.dbType) {
            case 3: {
                url = "jdbc:ksql:com.microsoft.jdbc.sqlserver.SQLServerDriver:dbtype=mssqlserver:jdbc:microsoft:sqlserver://" + this.dataSource + ":1433;DatabaseName=" + this.dbName;
                break;
            }
            case 1: {
                url = "jdbc:ksql:COM.ibm.db2.jdbc.app.DB2Driver:dbtype=db2:jdbc:db2:" + this.dbName;
                break;
            }
            case 2: {
                url = "jdbc:ksql:oracle.jdbc.driver.OracleDriver:dbtype=oracle9:jdbc:oracle:thin:@" + this.dataSource + ":1521:" + this.dbName;
            }
        }
        return url;
    }

    public String getKsqlUrlType4() {
        String url = "";
        switch (this.dbType) {
            case 3: {
                url = "jdbc:ksql:com.microsoft.jdbc.sqlserver.SQLServerDriver:dbtype=mssqlserver:jdbc:microsoft:sqlserver://" + this.dataSource + ";DatabaseName=" + this.dbName;
                break;
            }
            case 1: {
                url = "jdbc:ksql:com.ibm.db2.jcc.DB2Driver:dbtype=db2:jdbc:db2://" + this.dataSource + "/" + this.dbName;
                break;
            }
            case 2: {
                url = "jdbc:ksql:oracle.jdbc.driver.OracleDriver:dbtype=oracle9:jdbc:oracle:thin:@" + this.dataSource + ":" + this.dbName;
            }
        }
        return url;
    }

    public String getKsqlUrlType4Encrypt() {
        String url = this.getKsqlUrlType4();
        if (url != null) {
            return KSqlUtil.encodeUrl((String)url);
        }
        return url;
    }

    public String getPasswordEncrypt() {
        if (this.password != null) {
            return KSqlUtil.encodePassword((String)this.password);
        }
        return this.password;
    }

    public String getJDBCUrl() {
        String url = "";
        switch (this.dbType) {
            case 3: {
                url = "jdbc:microsoft:sqlserver://" + this.getDataSource() + ":1433;DatabaseName=" + this.getDbName();
                break;
            }
            case 1: {
                url = "jdbc:db2:" + this.getDbName();
                break;
            }
            case 2: {
                url = "jdbc:oracle:thin:@" + this.getDataSource() + ":1521:" + this.getDbName();
            }
        }
        return url;
    }

    public Connection getKSQLConnection() throws Exception {
        DriverManager.registerDriver((java.sql.Driver)((Driver)Class.forName(this.getKSQLDriverName()).newInstance()));
        Connection conn = DriverManager.getConnection(this.getKsqlUrl(), this.getUserName(), this.getPassword());
        return conn;
    }

    public Connection getKSQLConnectionType4() throws Exception {
        DriverManager.registerDriver((java.sql.Driver)((Driver)Class.forName(this.getKSQLDriverName()).newInstance()));
        Connection conn = DriverManager.getConnection(this.getKsqlUrlType4(), this.getUserName(), this.getPassword());
        return conn;
    }

    public Connection getJDBCConnection() throws Exception {
        java.sql.Driver drv = (java.sql.Driver)Class.forName(this.getDriverName()).newInstance();
        DriverManager.registerDriver(drv);
        Connection conn = DriverManager.getConnection(this.getJDBCUrl(), this.getUserName(), this.getPassword());
        return conn;
    }

    public boolean checkConnection() throws Exception {
        boolean result = false;
        Connection conn = null;
        try {
            Driver driver = (Driver)Class.forName(this.getKSQLDriverName()).newInstance();
            DriverManager.registerDriver((java.sql.Driver)driver);
            conn = DriverManager.getConnection(this.getKsqlUrl(), this.getUserName(), this.getPassword());
            result = true;
        }
        catch (Exception err) {
            try {
                err.printStackTrace();
                result = false;
                throw err;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        return result;
    }

    public boolean checkConnectionType4() throws Exception {
        boolean result = false;
        Connection conn = null;
        try {
            Driver driver = (Driver)Class.forName(this.getKSQLDriverName()).newInstance();
            DriverManager.registerDriver((java.sql.Driver)driver);
            conn = DriverManager.getConnection(this.getKsqlUrlType4(), this.getUserName(), this.getPassword());
            result = true;
        }
        catch (Exception err) {
            try {
                err.printStackTrace();
                result = false;
                throw err;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        return result;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getDriverName() {
        String key = "";
        String defaultDriver = "";
        if (this.dbType == 3) {
            key = "SQLSERVER";
            defaultDriver = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
        } else if (this.dbType == 1) {
            key = "DB2";
            defaultDriver = "COM.ibm.db2.jdbc.app.DB2Driver";
        } else if (this.dbType == 2) {
            key = "ORACLE";
            defaultDriver = "oracle.jdbc.driver.OracleDriver";
        }
        return defaultDriver;
    }

    public String getKSQLDriverName() {
        String defaultDriverName = "com.kingdee.bos.sql.shell.Driver";
        return defaultDriverName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public int getDbType() {
        return this.dbType;
    }

    public void setDbType(int dbType) {
        this.dbType = dbType;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

