/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.ResourceListenerManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.ResourceBaseFirstLoadHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.BOSResourceBundle;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class ResourceBase {
    public static final String COMMON_RESOURCE_NAME = "com.kingdee.eas.common.EASCommonResource";
    public static final String BLUE_IMAGE_RESOURCE_NAME = "com.kingdee.eas.common.BOSImageResource2";
    public static final String BRIGHT_BLUE_IMAGE_RESOURCE_NAME = "com.kingdee.eas.common.BOSImageResource0";
    public static final String RED_IMAGE_RESOURCE_NAME = "com.kingdee.eas.common.BOSImageResource4";
    public static final String FIRST_LOAD_RESOURCE_NAME = "com.kingdee.eas.common.BOSFirstLoadImageResource";
    public static final String FIRST_LOAD_RESOURCE_NAME_4LOGIN = "com.kingdee.eas.common.BOSFirstLoadImage4LoginResource";
    public static final int FIRST_LOAD_RESOURCE_NAME_4LOGIN_COLORSTTYLE = 11;
    public static final String DIAMON_BLUE_THEME_RESOURCE_NAME = "com.kingdee.eas.common.BOSImageResource5";
    public static final String MISSING_STRING = "Missing Resource";
    private static final Logger logger = Logger.getLogger((String)ResourceBase.class.getName());
    private static final HashMap caches = new HashMap();
    private static HashMap propertiesMap = new HashMap();
    private static boolean loadedIcon_l1 = false;
    private static boolean loadedIcon_l2 = false;
    private static boolean loadedIcon_l3 = false;
    private static boolean loadedIcon4Login = false;
    private static Map firstLoadIcon_l1 = new HashMap();
    private static Map firstLoadIcon_l2 = new HashMap();
    private static Map firstLoadIcon_l3 = new HashMap();
    private static String NOT_MATCHED = "Not Matched";
    private static final String MISSING_IMAGE = "/resources/common/ico/kdworkbutton/tbtn_kong.png";

    private ResourceBase() {
    }

    private static Map getFirstLoadIconMap(Locale locale) {
        if ("zh_CN".equalsIgnoreCase(locale.toString()) || "l2".equalsIgnoreCase(locale.toString())) {
            return firstLoadIcon_l2;
        }
        if ("zh_TW".equalsIgnoreCase(locale.toString()) || "l3".equalsIgnoreCase(locale.toString())) {
            return firstLoadIcon_l3;
        }
        return firstLoadIcon_l1;
    }

    private static String getResourceFile() {
        int intColorStyle = ResourceBaseFirstLoadHelper.getColorStyle();
        return ResourceBase.getColorFileName(intColorStyle);
    }

    private static String getColorFileName(int colorStyle) {
        switch (colorStyle) {
            case 3: {
                return DIAMON_BLUE_THEME_RESOURCE_NAME;
            }
            case 0: {
                return BRIGHT_BLUE_IMAGE_RESOURCE_NAME;
            }
            case 2: {
                return BLUE_IMAGE_RESOURCE_NAME;
            }
            case 1: {
                return BRIGHT_BLUE_IMAGE_RESOURCE_NAME;
            }
            case 4: {
                return RED_IMAGE_RESOURCE_NAME;
            }
            case 10: {
                return FIRST_LOAD_RESOURCE_NAME;
            }
            case 11: {
                return FIRST_LOAD_RESOURCE_NAME_4LOGIN;
            }
        }
        return DIAMON_BLUE_THEME_RESOURCE_NAME;
    }

    public static void setloadedIcon(boolean loadstate, Locale loc) {
        if ("zh_CN".equalsIgnoreCase(loc.toString()) || "l2".equalsIgnoreCase(loc.toString())) {
            loadedIcon_l2 = loadstate;
        } else if ("zh_TW".equalsIgnoreCase(loc.toString()) || "l3".equalsIgnoreCase(loc.toString())) {
            loadedIcon_l3 = loadstate;
        }
        loadedIcon_l1 = loadstate;
    }

    public static boolean getloadedIconFromLocaleState(Locale loc) {
        if ("zh_CN".equalsIgnoreCase(loc.toString()) || "l2".equalsIgnoreCase(loc.toString())) {
            return loadedIcon_l2;
        }
        if ("zh_TW".equalsIgnoreCase(loc.toString()) || "l3".equalsIgnoreCase(loc.toString())) {
            return loadedIcon_l3;
        }
        return loadedIcon_l1;
    }

    public static String getString(String resName, Locale locale) {
        return ResourceBase.getString(resName, locale, true);
    }

    public static String getString(String resName, Locale locale, Object[] params) {
        String s = ResourceBase.getString(resName, locale, true);
        MessageFormat format = new MessageFormat(s);
        return format.format(params);
    }

    protected static String getString(String resName, Locale locale, boolean loadFromDB) {
        if (locale == null) {
            throw new NullPointerException("locale can't be null");
        }
        int index = resName.lastIndexOf(".");
        String _resourceClassName = null;
        String _resName = null;
        if (index == -1) {
            _resourceClassName = COMMON_RESOURCE_NAME;
            _resName = resName;
        } else {
            _resourceClassName = resName.substring(0, index);
            _resName = resName.substring(index + 1);
        }
        return ResourceBase.getString(_resourceClassName, _resName, locale, loadFromDB);
    }

    private static Enumeration getAllKeys(int colorStyle, Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale can't be null");
        }
        String _resourceClassName = ResourceBase.getColorFileName(colorStyle);
        ResourceBundle resourceBundle = BOSResourceBundle.getBundle((String)_resourceClassName, (Locale)locale);
        if (resourceBundle != null) {
            return resourceBundle.getKeys();
        }
        throw new IllegalArgumentException(" file not found , resourceClassName is:" + _resourceClassName + " locale is:" + locale);
    }

    public static Properties getFromCache(String resNameSrc, Locale locale) {
        Object obj;
        if (propertiesMap == null) {
            propertiesMap = new HashMap();
        }
        if ((obj = propertiesMap.get(StringUtils.cnulls((String)resNameSrc) + StringUtils.cnulls((Object)locale))) != null) {
            return (Properties)obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getResourceFile(String resNameSrc, Locale locale) {
        InputStream inputStream = null;
        try {
            Properties retObj = ResourceBase.getFromCache(resNameSrc, locale);
            if (retObj != null) {
                Properties properties = retObj;
                return properties;
            }
            String resName = resNameSrc.replace('.', '/');
            StringBuffer sb = new StringBuffer("");
            sb.append(resName).append("_").append(locale).append(".properties");
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(sb.toString());
            String retFileName = null;
            if (inputStream != null && inputStream.available() > 0) {
                retFileName = sb.toString();
            } else {
                String tempStr = resName + ".properties";
                inputStream = ResourceBase.class.getClass().getResourceAsStream(tempStr);
                if (inputStream != null && inputStream.available() > 0) {
                    retFileName = tempStr;
                }
            }
            if (retFileName != null && inputStream != null) {
                Properties ps = new Properties();
                ps.load(inputStream);
                String keyStr = StringUtils.cnulls((String)resNameSrc) + StringUtils.cnulls((Object)locale);
                if (!propertiesMap.containsKey(keyStr)) {
                    propertiesMap.put(keyStr, ps);
                }
                Properties properties = ps;
                return properties;
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getString(String resClassName, String resName, Locale locale) {
        return ResourceBase.getString(resClassName, resName, locale, true);
    }

    public static String getString(String resClassName, String resName, Locale locale, Object[] params) {
        String s = ResourceBase.getString(resClassName, resName, locale, true);
        MessageFormat format = new MessageFormat(s);
        return format.format(params);
    }

    protected static String getString(String resClassName, String resName, Locale locale, boolean loadFromDB) {
        String s;
        if (loadFromDB && ResourceListenerManager.isMultiLanguages() && !StringUtils.isEmpty((String)(s = ResourceListenerManager.getString((IMetaDataPK)MetaDataPK.create((String)resClassName), (BOSObjectType)MetaDataTypeList.RESOURCE_TYPE, (Locale)locale, (String)resName)))) {
            s = s.replaceAll("\\\\r", "\r");
            s = s.replaceAll("\\\\n", "\n");
            s = s.replaceAll("\\\\t", "\t");
            return s;
        }
        try {
            ResourceBundle resBundle = BOSResourceBundle.getBundle((String)resClassName, (Locale)locale);
            if (resBundle == null) {
                return MISSING_STRING;
            }
            if (resBundle != null) {
                String result = resBundle.getString(resName);
                if (StringUtils.isEmpty((String)result)) {
                    return NOT_MATCHED;
                }
                result = result.replaceAll("\\\\r", "\r");
                result = result.replaceAll("\\\\n", "\n");
                result = result.replaceAll("\\\\t", "\t");
                return result;
            }
        }
        catch (MissingResourceException e) {
            return MISSING_STRING;
        }
        catch (ClassCastException cce) {
            return MISSING_STRING;
        }
        return MISSING_STRING;
    }

    public static Image getImage(String resName, Locale locale) {
        Image firstImg = ResourceBase.getFirstLoadImg(resName, locale);
        if (firstImg != null) {
            return firstImg;
        }
        int index = resName.lastIndexOf(".");
        String _resourceClassName = null;
        String _resName = null;
        if (index == -1) {
            _resourceClassName = ResourceBase.getResourceFile();
            _resName = resName;
        } else {
            _resourceClassName = resName.substring(0, index);
            _resName = resName.substring(index + 1);
        }
        return ResourceBase.getResCache(locale).getImage(_resourceClassName + "." + _resName);
    }

    public static Image getImage4Login(String resName, Locale locale) {
        Image firstImg = ResourceBase.getFirstLoadImg4Login(resName, locale);
        if (firstImg != null) {
            return firstImg;
        }
        int index = resName.lastIndexOf(".");
        String _resourceClassName = null;
        String _resName = null;
        if (index == -1) {
            _resourceClassName = ResourceBase.getResourceFile();
            _resName = resName;
        } else {
            _resourceClassName = resName.substring(0, index);
            _resName = resName.substring(index + 1);
        }
        return ResourceBase.getResCache(locale).getImage4Login(_resourceClassName + "." + _resName);
    }

    public static Icon getIcon(String resName, Locale locale) {
        if (!ResourceBase.getloadedIconFromLocaleState(locale)) {
            ResourceBase.loadAllFirstLoadInco(locale);
        }
        int index = resName.lastIndexOf(".");
        String _resourceClassName = null;
        String _resName = null;
        if (index == -1) {
            _resourceClassName = ResourceBase.getResourceFile();
            _resName = resName;
        } else {
            _resourceClassName = resName.substring(0, index);
            _resName = resName.substring(index + 1);
        }
        Icon tempIcon = ResourceBase.getResCache(locale).getFirstLoadIcon(_resName);
        if (tempIcon != null) {
            return tempIcon;
        }
        return ResourceBase.getResCache(locale).getIcon(_resourceClassName + "." + _resName);
    }

    public static Icon getIcon4Login(String resName, Locale locale) {
        if (!loadedIcon4Login) {
            ResourceBase.loadAllFirstLoadInco4Login(locale);
        }
        int index = resName.lastIndexOf(".");
        String _resourceClassName = null;
        String _resName = null;
        if (index == -1) {
            _resourceClassName = ResourceBase.getResourceFile();
            _resName = resName;
        } else {
            _resourceClassName = resName.substring(0, index);
            _resName = resName.substring(index + 1);
        }
        Icon tempIcon = ResourceBase.getResCache(locale).getFirstLoadIcon(_resName);
        if (tempIcon != null) {
            return tempIcon;
        }
        return ResourceBase.getResCache(locale).getIcon("com.kingdee.eas.common.BOSFirstLoadImageResource." + _resName);
    }

    public static Icon getIcon(String resFileName, String iconKey, Locale locale) {
        if (!ResourceBase.getloadedIconFromLocaleState(locale)) {
            ResourceBase.loadAllFirstLoadInco(locale);
        }
        String _resourceClassName = resFileName + ResourceBaseFirstLoadHelper.getColorStyle();
        Icon tempIcon = ResourceBase.getResCache(locale).getFirstLoadIcon(iconKey);
        if (tempIcon != null) {
            return tempIcon;
        }
        return ResourceBase.getResCache(locale).getIcon(_resourceClassName + "." + iconKey);
    }

    public static Icon getIcon4Login(String resFileName, String iconKey, Locale locale) {
        if (!loadedIcon4Login) {
            ResourceBase.loadAllFirstLoadInco4Login(locale);
        }
        String _resourceClassName = resFileName + ResourceBaseFirstLoadHelper.getColorStyle();
        Icon tempIcon = ResourceBase.getResCache(locale).getFirstLoadIcon(iconKey);
        if (tempIcon != null) {
            return tempIcon;
        }
        return ResourceBase.getResCache(locale).getIcon(_resourceClassName + "." + iconKey);
    }

    private static ResCache getResCache(Locale locale) {
        SoftReference<ResCache> cacheRef = (SoftReference<ResCache>)caches.get(locale.toString());
        ResCache cache = null;
        if (cacheRef == null || cacheRef.get() == null) {
            cache = new ResCache(locale);
            cacheRef = new SoftReference<ResCache>(cache);
            caches.put(locale.toString(), cacheRef);
        }
        return (ResCache)cacheRef.get();
    }

    public static void loadAllInco(int colorStyle, Locale locale) {
        boolean loadedIcon = ResourceBase.getloadedIconFromLocaleState(locale);
        if (!loadedIcon4Login) {
            ResourceBase.loadAllFirstLoadInco4Login(locale);
        }
        if (!loadedIcon) {
            ResourceBase.loadAllFirstLoadInco(locale);
        }
    }

    private static Image getFirstLoadImg(String resName, Locale locale) {
        if (!ResourceBase.getloadedIconFromLocaleState(locale)) {
            ResourceBase.loadAllFirstLoadInco(locale);
        }
        if (ResourceBase.getFirstLoadIconMap(locale).containsKey(resName)) {
            return ResourceBase.getResCache(locale).getImage("com.kingdee.eas.common.BOSFirstLoadImageResource." + resName);
        }
        return null;
    }

    private static Image getFirstLoadImg4Login(String resName, Locale locale) {
        if (!loadedIcon4Login) {
            ResourceBase.loadAllFirstLoadInco4Login(locale);
        }
        if (ResourceBase.getFirstLoadIconMap(locale).containsKey(resName)) {
            return ResourceBase.getResCache(locale).getImage("com.kingdee.eas.common.BOSFirstLoadImageResource." + resName);
        }
        return null;
    }

    public static synchronized void loadAllFirstLoadInco(Locale locale) {
        if (ResourceBase.getloadedIconFromLocaleState(locale)) {
            return;
        }
        int count = 0;
        Enumeration allKeyEnum = ResourceBase.getAllKeys(10, locale);
        while (allKeyEnum.hasMoreElements()) {
            Icon icon;
            String oneKeyStr = (String)allKeyEnum.nextElement();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("oneKeyStr is:" + oneKeyStr));
            }
            if (oneKeyStr == null || oneKeyStr.trim().length() == 0 || (icon = ResourceBase.getResCache(locale).getFirstLoadIcon(oneKeyStr)) != null) continue;
            icon = ResourceBase.getResCache(locale).getIcon("com.kingdee.eas.common.BOSFirstLoadImageResource." + oneKeyStr);
            if (icon != null) {
                ResourceBase.getFirstLoadIconMap(locale).put(oneKeyStr, icon);
            }
            ++count;
        }
        ResourceBase.setloadedIcon(true, locale);
    }

    public static synchronized void loadAllFirstLoadInco4Login(Locale locale) {
        if (loadedIcon4Login) {
            return;
        }
        loadedIcon4Login = true;
    }

    public static void main(String[] args) {
        LowTimer lowTimer = new LowTimer();
        lowTimer.reset();
        ResourceBase.loadAllFirstLoadInco(new Locale("l3"));
        Image image = EASResource.getImage((String)"imgTable_fzz");
        if (image != null) {
            System.out.println("get img!");
        } else {
            System.out.println("no img!");
        }
    }

    static class ResCache {
        Map imageFileNames = null;
        Map images = null;
        Map icons = null;
        Locale locale = null;
        Icon defaultIcon = null;
        Image defaultImage = null;

        public ResCache(Locale loc) {
            this.locale = loc;
            this.imageFileNames = new Hashtable();
            this.images = new HashMap();
            this.icons = new HashMap();
            propertiesMap = new HashMap();
            this.defaultIcon = new ImageIcon(ResourceBase.class.getResource(ResourceBase.MISSING_IMAGE));
            this.defaultImage = Toolkit.getDefaultToolkit().createImage(ResourceBase.class.getResource(ResourceBase.MISSING_IMAGE));
        }

        public Icon getIcon(String resFullName) {
            Icon icon = (Icon)this.icons.get(resFullName);
            if (icon == null) {
                String fileName = this.getImageFileName(resFullName);
                URL url = ResourceBase.class.getResource(fileName);
                if (fileName.equals(ResourceBase.MISSING_STRING)) {
                    icon = this.getDefaultIcon();
                    return icon;
                }
                if (url != null) {
                    icon = new ImageIcon(url);
                    this.icons.put(resFullName, icon);
                } else {
                    icon = this.getDefaultIcon();
                }
            }
            return icon;
        }

        public Icon getIcon4Login(String resFullName) {
            Icon icon = (Icon)ResourceBase.getFirstLoadIconMap(this.locale).get(resFullName);
            if (icon == null) {
                String fileName = this.getImageFileName(resFullName);
                URL url = ResourceBase.class.getResource(fileName);
                if (fileName.equals(ResourceBase.MISSING_STRING)) {
                    icon = this.getDefaultIcon();
                    return icon;
                }
                if (url != null) {
                    icon = new ImageIcon(url);
                    ResourceBase.getFirstLoadIconMap(this.locale).put(resFullName, icon);
                } else {
                    icon = this.getDefaultIcon();
                }
            }
            return icon;
        }

        private Icon getDefaultIcon() {
            return this.defaultIcon;
        }

        private Image getDefaultImage() {
            return this.defaultImage;
        }

        public Image getImage(String resFullName) {
            Image image = (Image)this.images.get(resFullName);
            if (image == null) {
                String fileName = this.getImageFileName(resFullName);
                if (fileName.equals(ResourceBase.MISSING_STRING)) {
                    image = this.getDefaultImage();
                    return image;
                }
                URL url = ResourceBase.class.getResource(fileName);
                if (url != null) {
                    image = Toolkit.getDefaultToolkit().createImage(url);
                    this.images.put(resFullName, image);
                } else {
                    image = this.getDefaultImage();
                }
            }
            return image;
        }

        public Image getImage4Login(String resFullName) {
            Locale l = SysContext.getSysContext().getLocale();
            Image image = (Image)ResourceBase.getFirstLoadIconMap(l).get(resFullName);
            if (image == null) {
                String fileName = this.getImageFileName(resFullName);
                if (fileName.equals(ResourceBase.MISSING_STRING)) {
                    image = this.getDefaultImage();
                    return image;
                }
                URL url = ResourceBase.class.getResource(fileName);
                if (url != null) {
                    image = Toolkit.getDefaultToolkit().createImage(url);
                    ResourceBase.getFirstLoadIconMap(l).put(resFullName, image);
                } else {
                    image = this.getDefaultImage();
                }
            }
            return image;
        }

        private String getImageFileName(String resFullName) {
            String imageFileName = (String)this.imageFileNames.get(resFullName);
            if (imageFileName == null) {
                imageFileName = ResourceBase.getString(resFullName, this.locale, false);
                this.imageFileNames.put(resFullName, imageFileName);
            }
            return imageFileName;
        }

        public Icon getFirstLoadIcon(String name) {
            Icon icon = (Icon)ResourceBase.getFirstLoadIconMap(this.locale).get(ResourceBaseFirstLoadHelper.getInstance().getFirstLoadName(name));
            if (icon != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("getIcon from first! name is:" + name));
                }
                return icon;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("fetch icon from other! name is:" + name));
            }
            return null;
        }
    }
}

