/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util.app;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.util.app.ClusterServiceFactory;
import com.kingdee.eas.util.app.IClusterService;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class StatusDBUtil {
    private static Logger logger = Logger.getLogger(StatusDBUtil.class);
    private static final String DEFAULT_DRIVER_CLASS = "com.kingdee.bos.sql.shell.Driver";

    public static IRowSet executeQueryNoTx(String sql) throws BOSException {
        return StatusDBUtil.executeWithReturn(sql, null);
    }

    public static IRowSet executeQueryNoTx(String sql, Object[] params) throws BOSException {
        return StatusDBUtil.executeWithReturn(sql, params);
    }

    public static IRowSet executeQuery(String sql) throws BOSException {
        return StatusDBUtil.executeWithReturn(sql, null);
    }

    public static IRowSet executeQuery(String sql, Object[] params) throws BOSException {
        return StatusDBUtil.executeWithReturn(sql, params);
    }

    public static void execute(String sql) throws BOSException {
        StatusDBUtil.executeWithNoReturn(sql, null);
    }

    public static void execute(String sql, Object[] params) throws BOSException {
        StatusDBUtil.executeWithNoReturn(sql, params);
    }

    private static IRowSet executeWithReturn(String sql, Object[] params) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = StatusDBUtil.createConnectionDirect();
            ps = conn.prepareStatement(sql);
            if (params != null && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                if (params != null && params.length > 0) {
                    StringBuffer sb = new StringBuffer("");
                    for (int i = 0; i < params.length; ++i) {
                        sb.append("param ").append(i).append(" is:").append(params[i]);
                    }
                    logger.error((Object)("444 sql is:" + sql + " param is:" + sb.toString()), (Throwable)exc);
                }
                throw new BOSException("Sql4 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return jdbcRowSet;
    }

    public static void executeWithNoReturn(String sql, Object[] params) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = StatusDBUtil.createConnectionDirect();
            ps = conn.prepareStatement(sql);
            if (params != null && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            ps.execute();
        }
        catch (Exception exc) {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < params.length; ++i) {
                sb.append("param ").append(i).append(" is:").append(params[i]);
            }
            logger.error((Object)("222 sql is:" + sql + " param is:" + sb.toString()), (Throwable)exc);
            throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
        }
    }

    private static Connection createConnectionDirect() throws BOSException {
        Connection con = null;
        String url = null;
        try {
            Class.forName(DEFAULT_DRIVER_CLASS);
            IClusterService cs = ClusterServiceFactory.getLocalInstance();
            url = cs.getStatusDBUrl();
            con = DriverManager.getConnection(url, cs.getStatusDBUser(), cs.getStatusDBPassword());
        }
        catch (ClassNotFoundException exc) {
            logger.error((Object)"CreateConnection exception is : ", (Throwable)exc);
            throw new BOSException("CreateConnection exception : ", (Throwable)exc);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup(con);
            logger.error((Object)"CreateConnection exception is : ", (Throwable)exc);
            throw new BOSException("CreateConnection exception : ", (Throwable)exc);
        }
        return con;
    }

    public static void prepareVarcharParam(PreparedStatement stmt, int index, String param) throws SQLException {
        stmt.setString(index, param);
    }
}

