/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.ExtendPointInfo;
import com.kingdee.eas.ep.ExtendPointParamCollection;
import com.kingdee.eas.ep.ExtendPointParamInfo;
import com.kingdee.eas.ep.ICustomizedScheme;
import com.kingdee.eas.ep.plugin.ExtendMethodInfo;
import com.kingdee.eas.ep.plugin.ScriptExecuteException;
import com.kingdee.eas.ep.plugin.ScriptInfo;
import com.kingdee.eas.util.AbortException;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.WrappedException;

public class PluginUtils {
    public static void handleScriptException(Context ctx, Throwable e, ScriptInfo script) throws ScriptExecuteException, EASBizException {
        if (e == null) {
            return;
        }
        if (e instanceof WrappedException) {
            e = ((WrappedException)e).getWrappedException();
        } else if (e instanceof JavaScriptException) {
            NativeJavaObject o = (NativeJavaObject)((JavaScriptException)e).getValue();
            e = (Throwable)o.unwrap();
        }
        if (e instanceof EASBizException) {
            throw (EASBizException)e;
        }
        if (e instanceof BOSException) {
            if (e.getCause() != null && e.getCause() instanceof EASBizException) {
                throw (EASBizException)e.getCause();
            }
            throw PluginUtils.getScriptExecuteException(ctx, e, script);
        }
        if (e instanceof AbortException) {
            throw (AbortException)e;
        }
        throw PluginUtils.getScriptExecuteException(ctx, e, script);
    }

    private static ScriptExecuteException getScriptExecuteException(Context ctx, Throwable e, ScriptInfo script) {
        if (script != null) {
            String message = script.getScript();
            if (script.getSchemeID() != null) {
                try {
                    ICustomizedScheme is = null;
                    is = ctx == null ? CustomizedSchemeFactory.getRemoteInstance() : CustomizedSchemeFactory.getLocalInstance(ctx);
                    CustomizedSchemeInfo scheme = is.getCustomizedSchemeInfo((IObjectPK)new ObjectUuidPK(script.getSchemeID()));
                    if (scheme != null) {
                        message = "\u65b9\u6848" + scheme.getName() + "\u4e2d\u7684\u811a\u672c\u5b58\u5728\u95ee\u9898\u3002\u811a\u672c\u5982\u4e0b\uff1a\n" + message;
                    }
                }
                catch (Exception ex) {
                    return new ScriptExecuteException(e);
                }
            }
            if (e.getMessage().indexOf("Cannot convert function to interface com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener") != -1) {
                message = "\u5347\u7ea7880\u8868\u683c\u76d1\u542c\u811a\u672c\u62a5\u9519\uff0c\u53ef\u53c2\u8003\u793e\u533a\u6587\u6863\u4fee\u6539\u6269\u5c55\u811a\u672c\uff1a\nhttps://vip.kingdee.com/article/380751295466020096\u3002\n" + message;
            }
            return new ScriptExecuteException(message, e);
        }
        return new ScriptExecuteException(e);
    }

    public static ExtendPointInfo getExtendPoint(ExtendMethodInfo m) {
        ExtendPointInfo point = new ExtendPointInfo();
        point.setName(m.getName());
        point.setAlias(m.getAlias());
        point.setResult(m.getResultType());
        point.setInner(false);
        String[] pTypes = m.getParamTypes();
        ExtendPointParamInfo param = null;
        for (int j = 0; j < pTypes.length; ++j) {
            param = new ExtendPointParamInfo();
            param.setType(pTypes[j]);
            param.setSeq(j);
            point.getParam().add(param);
        }
        return point;
    }

    public static ExtendPointInfo getExtendPoint(MethodInfo m) {
        ExtendPointInfo point = new ExtendPointInfo();
        point.setName(m.getName());
        point.setAlias(m.getAlias());
        point.setResult(m.getDataType());
        point.setInner(false);
        ParameterCollection ppCol = m.getParameters();
        if (ppCol != null) {
            ExtendPointParamInfo param = null;
            int psize = ppCol.size();
            for (int j = 0; j < psize; ++j) {
                param = new ExtendPointParamInfo();
                param.setType(ppCol.get(j).getDataType());
                param.setSeq(j);
                point.getParam().add(param);
            }
        }
        return point;
    }

    public static ExtendPointInfo getExtendPoint(Method m) {
        ExtendPointInfo point = new ExtendPointInfo();
        String methodName = m.getName();
        Class<?>[] pClass = m.getParameterTypes();
        point.setName(methodName);
        point.setParamNum(pClass.length);
        int paramLen = 0;
        ExtendPointParamInfo pp = null;
        for (int i = 0; i < pClass.length; ++i) {
            pp = new ExtendPointParamInfo();
            pp.setType(pClass[i].getName());
            pp.setSeq(i);
            point.getParam().add(pp);
            paramLen += pClass[i].getName().length();
        }
        point.setParamLen(paramLen);
        return point;
    }

    public static ExtendPointInfo getExtendPoint(String actionName) {
        ExtendPointInfo point = new ExtendPointInfo();
        point.setName(actionName);
        point.setResult(null);
        point.setInner(false);
        ExtendPointParamInfo param = new ExtendPointParamInfo();
        param.setType(ActionEvent.class.getName());
        param.setSeq(0);
        point.getParam().add(param);
        return point;
    }

    public static boolean isExtendPointEqual(ExtendPointInfo p1, ExtendPointInfo p2) {
        if (p1 == null && p2 == null) {
            return true;
        }
        if (p1 != null && p2 != null) {
            if (p1.getId() != null && p2.getId() != null && p1.getId().equals((Object)p2.getId())) {
                return true;
            }
            if (p1.getName().equals(p2.getName())) {
                return PluginUtils.isParamEqual(p1, p2);
            }
            return false;
        }
        return false;
    }

    public static boolean isParamEqual(ExtendPointInfo p1, ExtendPointInfo p2) {
        ExtendPointParamCollection pCol1 = p1.getParam();
        ExtendPointParamCollection pCol2 = p2.getParam();
        int size = pCol1.size();
        if (size != pCol2.size()) {
            return false;
        }
        ExtendPointParamInfo param1 = null;
        ExtendPointParamInfo param2 = null;
        boolean isEqual = true;
        for (int i = 0; i < size; ++i) {
            param1 = pCol1.get(i);
            boolean contained = false;
            for (int j = 0; j < size; ++j) {
                param2 = pCol2.get(j);
                if (!param1.getType().equals(param2.getType()) || param1.getSeq() != param2.getSeq()) continue;
                contained = true;
                break;
            }
            boolean bl = isEqual = isEqual && contained;
            if (!isEqual) break;
        }
        return isEqual;
    }

    public static ExtendMethodInfo getExtendMethodInfo(String actionName, ActionEvent event) {
        ExtendMethodInfo m = new ExtendMethodInfo();
        m.setResult(null, null);
        m.addParam(ActionEvent.class.getName(), event);
        return m;
    }

    public static ExtendMethodInfo getExtendMethodInfo(MethodInfo method, Object[] args) {
        ExtendMethodInfo m = new ExtendMethodInfo();
        m.setName(method.getName());
        m.setAlias(method.getAlias());
        String resultType = method.getDataType();
        m.setResult(resultType, null);
        ParameterCollection pc = method.getParameters();
        if (pc != null) {
            int size = pc.size();
            int len = 0;
            if (size != args.length && size != args.length - 1) {
                return m;
            }
            if (size == args.length - 1) {
                len = 1;
            }
            ParameterInfo p = null;
            for (int i = 0; i < size; ++i) {
                p = pc.get(i);
                m.addParam(p.getDataType(), args[i + len]);
            }
        }
        return m;
    }

    public static ExtendMethodInfo getExtendMethodInfo(Method method, Object[] args) {
        ExtendMethodInfo m = new ExtendMethodInfo();
        m.setName(method.getName());
        Class<?>[] pt = method.getParameterTypes();
        Class<?> c = null;
        String type = null;
        for (int i = 0; i < pt.length; ++i) {
            c = pt[i];
            type = c == null ? null : c.getName();
            m.addParam(pt[i].getName(), args[i]);
        }
        c = method.getReturnType();
        type = c == null ? null : c.getName();
        m.setResult(type, null);
        return m;
    }

    public static int getType(BOSObjectType bosType) {
        if (MetaDataTypeList.UIOBJECT.equals((Object)bosType)) {
            return 0;
        }
        if (MetaDataTypeList.ENTITY.equals((Object)bosType) || MetaDataTypeList.FACADE.equals((Object)bosType)) {
            return 1;
        }
        if (MetaDataTypeList.WEBUIOBJECT.equals((Object)bosType)) {
            return 2;
        }
        return 0;
    }

    public static MethodCollection getAllMethods(BusinessObjectInfo bo) {
        LinkedList<BusinessObjectInfo> parents = new LinkedList<BusinessObjectInfo>();
        BusinessObjectInfo boCur = bo;
        do {
            parents.add(boCur);
        } while ((boCur = boCur.getParent()) != null);
        HashMap<String, MethodInfo> stage = new HashMap<String, MethodInfo>();
        int size = parents.size();
        for (int i = 0; i < size; ++i) {
            boCur = (BusinessObjectInfo)parents.get(i);
            MethodCollection mc = boCur.getMethods();
            if (mc == null) continue;
            for (int j = 0; j < mc.size(); ++j) {
                MethodInfo method = mc.get(j);
                stage.put(method.toString(), method);
            }
        }
        MethodCollection rtv = new MethodCollection();
        for (MethodInfo method : stage.values()) {
            rtv.add(method);
        }
        return rtv;
    }
}

