/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.ui.dtp.model.layout.Layout;
import com.kingdee.bos.ui.dtp.smartlayout.SmartLayoutData;
import com.kingdee.bos.ui.dtp.weblayout.WebLayoutData;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.BizDataTypeEnum;
import com.kingdee.eas.ep.DataSourceEnum;
import com.kingdee.eas.ep.client.editor.editui.designer.AbstractPropertyDescriptorUI;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.CommandStack;
import com.kingdee.eas.ep.client.editor.editui.designer.model.ComboBoxItem;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.ActionCellEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.util.ComponentHelper;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.ep.webclient.editor.webui.designer.AbstractWebEditPartViewer;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebContext;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebItemInfoAdapter;
import com.kingdee.eas.ep.webclient.editor.webui.designer.commands.WebPropertyValueChangeCommand;
import com.kingdee.eas.ep.webclient.editor.webui.designer.ui.AutoSizeCellEditor;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.WebComponentHelper;
import com.kingdee.eas.ep.webclient.model.WebItemInfo;
import com.kingdee.eas.ep.webclient.util.WebUIEditorHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class WebPropertyDescriptorUI
extends AbstractPropertyDescriptorUI {
    private static final Logger logger = CoreUIObject.getLogger(WebPropertyDescriptorUI.class);
    public static final String EDITTYPE = "edit type";
    public static final String EDIT_VIEWER = "edit viewer";
    public static final String EDIT_CTRL = "edit ctrl";
    public static final String EDIT_ENTRY_PRO = "edit entry pro";
    public static final String EDITPARTVIEWER = "viewer";
    public static final String ITEMADAPTER = "item adapter";
    public static final String ITEM = "item";
    public static final String ENTITY = "entity";
    public static final String LABELCONTAINER_NAME = "labelcontainername_pro";
    public static final String LABELCONTAINER_TEXT = "labelcontainertext_pro";
    public static final String LABELCONTAINER_LENGTH = "labelcontainerlength_pro";
    public static final String ACTION = "action_pro";
    public static final String CTRL_NAME = "ctrlname_pro";
    public static final String MAXLENGTH = "maxlength";
    public static final String X = "x_pro";
    public static final String Y = "y_pro";
    public static final String WIDTH = "width_pro";
    public static final String HEIGHT = "height_pro";
    public static final String ANCHOR_PRO = "anchor_pro";
    public static final String WLDWIDTH = "wldwidth_pro";
    public static final String WLDHEIGHT = "wldheight_pro";
    public static final String VISIBLE = "visible_pro";
    public static final String ENABLE = "enable_pro";
    public static final String REQUIRE = "requrie_pro";
    public static final String SUM = "sum_pro";
    public static final String DEFAULT_VALUE = "defaultvalue_inf";
    public static final String LAYOUT_INF = "layout_inf";
    public static final String UIWIDTH_INF = "uiwidth_inf";
    public static final String UIWLDWIDTH_INF = "uiwldwidth_inf";
    public static final String UIWLDHEIGHT_INF = "uiwldheight_inf";
    public static final String UIHEIGHT_INF = "uiheight_inf";
    public static final String BASE_INF = "base_inf";
    public static final String DISPLAYFORMAT = "diaplayformat";
    public static final String EDITFORMAT = "editformat";
    private AbstractWebEditPartViewer viewer;
    private WebItemInfoAdapter adapter;
    private WebItemInfo item;
    private String editType = "edit ctrl";

    public void onLoad() throws Exception {
        super.onLoad();
        this.tableList.checkParsed(true);
        Object object = this.getUIContext().get(EDITTYPE);
        if (EDIT_VIEWER.equals((String)object)) {
            this.editType = EDIT_VIEWER;
        } else if (EDIT_ENTRY_PRO.equals((String)object)) {
            this.editType = EDIT_ENTRY_PRO;
        }
        object = this.getUIContext().get(EDITPARTVIEWER);
        this.viewer = (AbstractWebEditPartViewer)((Object)object);
        if (EDIT_CTRL.equals(this.editType)) {
            object = this.getUIContext().get(ITEMADAPTER);
            this.adapter = (WebItemInfoAdapter)((Object)object);
        }
        if (EDIT_ENTRY_PRO.equals(this.editType)) {
            object = this.getUIContext().get(ITEM);
            this.item = (WebItemInfo)object;
        }
        this.init();
    }

    public void reload() {
        this.tableList.removeRows();
        this.init();
    }

    protected void init() {
        String displayFormatTitle = "\u663e\u793a\u540d\u79f0 :";
        if (EDIT_CTRL.equals(this.editType)) {
            Object constraint;
            WebItemInfo item = (WebItemInfo)this.adapter.getItem();
            ComponentInfo roundInfo = WebUIEditorHelper.getRoundedComponent(item.getComponent());
            if (roundInfo != null && "com.kingdee.bos.ctrl.web.LabelContainer".equalsIgnoreCase(roundInfo.getClassType())) {
                this.addRow(LABELCONTAINER_NAME, "\u6807\u7b7e\u540d\u79f0", (Object)roundInfo.getName(), true);
                this.addRow(LABELCONTAINER_TEXT, "\u6807\u7b7e\u6587\u5b57", item.getLabel());
                this.addRow(LABELCONTAINER_LENGTH, "\u6807\u7b7e\u6587\u5b57\u957f\u5ea6", new Integer(item.getLabelLength()));
            } else if ("com.kingdee.bos.ctrl.web.Label".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.web.Button".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.web.RadioButton".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.web.CheckBox".equals(roundInfo.getClassType())) {
                this.addRow(LABELCONTAINER_TEXT, "\u6807\u7b7e\u6587\u5b57", item.getLabel());
            }
            this.addRow(CTRL_NAME, "\u63a7\u4ef6\u540d\u79f0", (Object)this.adapter.getName(), true);
            this.addRow(BASE_INF, "\u5c5e\u4e8e\u9759\u6001\u5143\u6570\u636e", (Object)(item.getComponent().isConfigured() ? "\u5426" : "\u662f"), true);
            if ("com.kingdee.bos.ctrl.web.TextField".equalsIgnoreCase(item.getComponent().getClassType()) || "com.kingdee.bos.ctrl.web.NumberField".equalsIgnoreCase(item.getComponent().getClassType()) || "com.kingdee.bos.ctrl.web.TextArea".equalsIgnoreCase(item.getComponent().getClassType())) {
                this.addRow(MAXLENGTH, "\u5f55\u5165\u6700\u5927\u957f\u5ea6", WebComponentHelper.getPropertyValue(item.getComponent(), "maxLength"));
            }
            if ((constraint = this.adapter.getConstranit()) instanceof SmartLayoutData) {
                SmartLayoutData sld = (SmartLayoutData)constraint;
                this.addRow(X, "x\u5750\u6807", new Integer(sld.x));
                this.addRow(Y, "y\u5750\u6807", new Integer(sld.y));
                this.addRow(WIDTH, "\u5bbd\u5ea6", new Integer(sld.width));
                this.addRow(HEIGHT, "\u9ad8\u5ea6", new Integer(sld.height));
                this.addRow(ANCHOR_PRO, "\u951a\u5b9a", (Object)new Integer(sld.autoSize), new KDTDefaultCellEditor((IKDEditor)new AutoSizeCellEditor(this.adapter)));
            } else if (constraint instanceof WebLayoutData) {
                WebLayoutData wld = (WebLayoutData)constraint;
                this.addRow(WLDWIDTH, "\u5bbd\u5ea6", wld.width);
                this.addRow(WLDHEIGHT, "\u9ad8\u5ea6", new Integer(wld.height));
            }
            if ("com.kingdee.bos.ctrl.web.Button".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.web.Button".equals(roundInfo.getClassType())) {
                this.addRow(ACTION, "\u4e8b\u4ef6\u7ed1\u5b9a", ComponentHelper.getPropertyValue((ComponentInfo)item.getComponent(), (String)"actionBinding"), new KDTDefaultCellEditor((IKDEditor)new ActionCellEditor(this.viewer.getContext().getUiModel())), !roundInfo.isConfigured() || !this.viewer.getContext().isBase());
            }
            if (!this.viewer.getContext().isBase()) {
                this.addRow(VISIBLE, "\u662f\u5426\u53ef\u89c1", new Boolean(item.isVisible()));
            }
        } else if (EDIT_VIEWER.equals(this.editType)) {
            Object obj = this.viewer.getNode().getUserObject();
            if (obj instanceof ComponentInfo) {
                boolean isRoot = this.viewer == ((WebContext)this.viewer.getContext()).getRootViewer();
                ComponentInfo container = (ComponentInfo)obj;
                this.addRow(CTRL_NAME, "\u63a7\u4ef6\u540d\u79f0", (Object)container.getName(), true);
                this.addRow(BASE_INF, "\u5c5e\u4e8e\u9759\u6001\u5143\u6570\u636e", (Object)(container.isConfigured() ? "\u5426" : "\u662f"), true);
                Layout layout = this.viewer.getViewerLayout();
                this.addRow(LAYOUT_INF, "\u5e03\u5c40", (Object)layout, true);
                Object constraint = container.getConstraint();
                if (constraint instanceof SmartLayoutData) {
                    SmartLayoutData sld = (SmartLayoutData)constraint;
                    this.addRow(UIWIDTH_INF, "\u5bbd\u5ea6", (Object)new Integer(sld.width), !isRoot || !this.viewer.getContext().isBase());
                    this.addRow(UIHEIGHT_INF, "\u9ad8\u5ea6", (Object)new Integer(sld.height), !isRoot || !this.viewer.getContext().isBase());
                } else if (constraint instanceof WebLayoutData) {
                    WebLayoutData wld = (WebLayoutData)constraint;
                    this.addRow(UIWLDWIDTH_INF, "\u5bbd\u5ea6", (Object)wld.width, !isRoot || !this.viewer.getContext().isBase());
                    this.addRow(UIWLDHEIGHT_INF, "\u9ad8\u5ea6", (Object)new Integer(wld.height), !isRoot || !this.viewer.getContext().isBase());
                }
            }
        } else if (EDIT_ENTRY_PRO.equals(this.editType)) {
            this.addRow(CTRL_NAME, "\u63a7\u4ef6\u540d\u79f0", (Object)this.item.getName(), true);
            if (!this.viewer.getContext().isBase()) {
                this.addRow(VISIBLE, "\u662f\u5426\u53ef\u89c1", new Boolean(this.item.isVisible()));
            }
        }
    }

    public ComboBoxItem getSelectItemByName(KDComboBox combox, String name) {
        if (name == null) {
            name = "number";
        }
        for (int i = 0; i < combox.getItemCount(); ++i) {
            ComboBoxItem item;
            if (combox.getItemAt(i) == null || !(combox.getItemAt(i) instanceof ComboBoxItem) || (item = (ComboBoxItem)combox.getItemAt(i)).getValue() == null || !item.getValue().toString().equals(name)) continue;
            return item;
        }
        return null;
    }

    private void addRow(String userObject, String proName, Object proValue) {
        this.addRow(userObject, proName, proValue, null, false);
    }

    private void addRow(String userObject, String proName, Object proValue, boolean isLock) {
        this.addRow(userObject, proName, proValue, null, isLock);
    }

    private void addRow(String userObject, String proName, Object proValue, KDTDefaultCellEditor editor) {
        this.addRow(userObject, proName, proValue, editor, false);
    }

    private void addRow(String userObject, String proName, Object proValue, KDTDefaultCellEditor editor, boolean isLock) {
        IRow row = this.tableList.addRow();
        row.setUserObject((Object)userObject);
        if (editor != null) {
            row.getCell(1).setEditor((ICellEditor)editor);
        }
        row.getCell(0).setValue((Object)proName);
        row.getCell(1).setValue(proValue);
        row.getCell(1).getStyleAttributes().setLocked(isLock);
        if (isLock) {
            row.getStyleAttributes().setBackground(new Color(225, 225, 225));
        }
    }

    private void addRow(String userObject, String proName, WebItemInfo item, boolean isLock) {
        IRow row = this.tableList.addRow();
        row.setUserObject((Object)userObject);
        row.getCell(0).setValue((Object)proName);
        row.getCell(1).setValue((Object)item.getDefaultValue());
        WebPropertyDescriptorUI.setDefaultCtrl(item, row.getCell(1));
        row.getCell(1).getStyleAttributes().setLocked(isLock);
        if (isLock) {
            row.getStyleAttributes().setBackground(new Color(225, 225, 225));
        }
    }

    private static void setDefaultCtrl(WebItemInfo item, ICell cell) {
        DataSourceEnum dstype = item.getDataSourceType();
        BizDataTypeEnum dtype = item.getDataType();
        if (DataSourceEnum.SELF.equals((Object)dstype) || DataSourceEnum.BASEDATAEXT.equals((Object)dstype)) {
            if (BizDataTypeEnum.STRING.equals((Object)dtype) || BizDataTypeEnum.NOTE.equals((Object)dtype)) {
                KDTextField text = new KDTextField();
                cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)text));
            } else if (BizDataTypeEnum.INTEGER.equals((Object)dtype)) {
                KDFormattedTextField intText = new KDFormattedTextField(0);
                cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)intText));
            } else if (BizDataTypeEnum.DECIMAL.equals((Object)dtype) || BizDataTypeEnum.AMOUNT.equals((Object)dtype) || BizDataTypeEnum.PRICE.equals((Object)dtype) || BizDataTypeEnum.QUANTITY.equals((Object)dtype)) {
                KDFormattedTextField floatField = new KDFormattedTextField(1);
                WebPropertyDescriptorUI.setFormattedTextField(item, floatField);
                cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)floatField));
            } else if (BizDataTypeEnum.DATE.equals((Object)dtype)) {
                Object obj = cell.getFormattedValue();
                KDDatePicker datePicker = new KDDatePicker();
                datePicker.setValue(obj);
                cell.setEditor((ICellEditor)new KDTDefaultCellEditor(datePicker));
                cell.getStyleAttributes().setNumberFormat("yyyy-MM-dd");
            } else if (BizDataTypeEnum.BOOLEAN.equals((Object)dtype)) {
                KDCheckBox check = new KDCheckBox();
                cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)check));
            }
        } else if (DataSourceEnum.BASEDATA.equals((Object)dstype)) {
            KDBizPromptBox pro = new KDBizPromptBox();
            if (item.getDataSource() != null) {
                String sQueryPK = item.getDataSource().getExtendedProperty("defaultF7Query");
                if (!StringUtils.isEmpty((String)sQueryPK)) {
                    pro.setQueryInfo(sQueryPK);
                    pro.setDisplayFormat("$number$");
                    pro.setEditFormat("$number$");
                    pro.setCommitFormat("$number$");
                    ObjectValueRender render = new ObjectValueRender();
                    render.setFormat((IDataFormat)new BizDataFormat("$number$"));
                    cell.setRenderer((IBasicRender)render);
                    cell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)pro));
                } else {
                    KDTextField text = new KDTextField();
                    cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)text));
                }
            }
        } else if (DataSourceEnum.LIST.equals((Object)dstype)) {
            KDComboBox combo = new KDComboBox();
            if (!StringUtils.isEmpty((String)item.getEnumPK())) {
                BizEnumInfo bizEnum = UictUtils.loadBizEnum((IMetaDataPK)MetaDataPK.create((String)item.getEnumPK()), null);
                if (bizEnum != null) {
                    if (bizEnum.isDynamic()) {
                        combo.addItems(DynamicEnum.getEnumList((String)item.getEnumPK()).toArray());
                    } else {
                        combo.addItems(EnumUtils.getEnumList((String)bizEnum.getClassName()).toArray());
                    }
                }
                cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)combo));
            }
        }
    }

    private static void setFormattedTextField(WebItemInfo item, KDFormattedTextField floatField) {
        if (item == null || floatField == null) {
            logger.info((Object)"WebItemInfo \u6216 KDFormattedTextField \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u683c\u5f0f\u5316\u8f93\u5165\u6846\u7684\u683c\u5f0f...");
            return;
        }
        int precision = -1;
        String MINIMUMVALUE = null;
        String MAXIMUMVALUE = null;
        if (item.getComponent() == null) {
            PropertyInfo min = ComponentHelper.createMinimumValueProperty((int)item.getLength(), (int)item.getScale());
            PropertyInfo max = ComponentHelper.createMaximumValueProperty((int)item.getLength(), (int)item.getScale());
            PropertyInfo pre = ComponentHelper.createPrecisionProperty((int)item.getScale());
            if (min != null) {
                MINIMUMVALUE = min.getValue().replaceAll("\"", "");
            }
            if (max != null) {
                MAXIMUMVALUE = max.getValue().replaceAll("\"", "");
            }
            if (pre != null) {
                precision = Integer.valueOf(pre.getValue());
            }
        } else {
            com.kingdee.bos.metadata.ui.PropertyCollection pcol = item.getComponent().getProperties();
            int size = pcol.size();
            for (int i = 0; i < size; ++i) {
                PropertyInfo pInfo = pcol.get(i);
                if (pInfo.getName().equals("minimumValue")) {
                    MINIMUMVALUE = pInfo.getValue().replaceAll("\"", "");
                }
                if (pInfo.getName().equals("maximumValue")) {
                    MAXIMUMVALUE = pInfo.getValue().replaceAll("\"", "");
                }
                if (!pInfo.getName().equals("precision")) continue;
                precision = Integer.valueOf(pInfo.getValue());
            }
        }
        if (precision != -1) {
            floatField.setPrecision(precision);
        }
        if (!StringUtils.isEmpty(MINIMUMVALUE)) {
            floatField.setMinimumValue((Comparable)new BigDecimal(MINIMUMVALUE));
        }
        if (!StringUtils.isEmpty(MAXIMUMVALUE)) {
            floatField.setMaximumValue((Comparable)new BigDecimal(MAXIMUMVALUE));
        }
    }

    protected void tableList_editStopped(KDTEditEvent e) throws Exception {
        IRow row = this.tableList.getRow(e.getRowIndex());
        ICell cell = row.getCell(e.getColIndex());
        if (cell != null) {
            Object newValue = cell.getValue();
            String cellDisplayText = this.tableList.getCellDisplayText(cell);
            if (EDIT_CTRL.equals(this.editType)) {
                Object obj = row.getUserObject();
                CommandStack stack = this.viewer.getCommandStack();
                WebPropertyValueChangeCommand command = new WebPropertyValueChangeCommand(obj.toString(), this.adapter, newValue, cellDisplayText);
                stack.execute((Command)command);
                this.reload();
            } else if (EDIT_ENTRY_PRO.equals(this.editType)) {
                Object obj = row.getUserObject();
                CommandStack stack = this.viewer.getCommandStack();
                WebPropertyValueChangeCommand command = new WebPropertyValueChangeCommand(obj.toString(), this.item, newValue, cellDisplayText);
                stack.execute((Command)command);
                this.reload();
            }
        }
    }

    protected void fillBaseDataProperty(KDComboBox combo, EntityObjectInfo entity, boolean bFillOwnerPropery, boolean bFillOnlyStringType) {
        if (combo == null || entity == null) {
            return;
        }
        PropertyCollection propertys = entity.getInheritedNoDuplicatedProperties();
        if (combo.getItemCount() > 0) {
            combo.removeAllItems();
        }
        for (com.kingdee.bos.metadata.entity.PropertyInfo property : propertys) {
            String sPropertyName;
            if (property == null || !(property instanceof OwnPropertyInfo) && bFillOwnerPropery) continue;
            DataType dt = DataType.STRING;
            if (property != null && property instanceof OwnPropertyInfo) {
                dt = ((OwnPropertyInfo)property).getDataType();
            } else if (property != null && property instanceof LinkPropertyInfo) {
                dt = DataType.BOSUUID;
            }
            if ("id".equalsIgnoreCase(property.getName()) || !DataType.STRING.equals((Object)dt) && bFillOnlyStringType) continue;
            String sPropertyCapton = property.getAlias() == null ? property.getName() : property.getAlias();
            String string = sPropertyName = property.getName() == null ? "" : property.getName();
            if (sPropertyCapton == null || sPropertyCapton.trim().length() <= 0 || sPropertyName.trim().length() <= 0) continue;
            combo.addItem((Object)new ComboBoxItem((Object)sPropertyName, sPropertyCapton, (Object)WebPropertyDescriptorUI.getBizDataType(dt)));
        }
    }

    public static BizDataTypeEnum getBizDataType(DataType dataType) {
        BizDataTypeEnum bizDataType = null;
        bizDataType = dataType == DataType.STRING ? BizDataTypeEnum.STRING : (dataType == DataType.DATE ? BizDataTypeEnum.DATE : (dataType == DataType.DECIMAL ? BizDataTypeEnum.DECIMAL : (dataType == DataType.INTEGER ? BizDataTypeEnum.INTEGER : (dataType == DataType.STRING ? BizDataTypeEnum.NOTE : (dataType == DataType.BOOLEAN ? BizDataTypeEnum.BOOLEAN : (dataType == DataType.FLOAT ? BizDataTypeEnum.DECIMAL : (dataType == DataType.TIMESTAMP ? BizDataTypeEnum.DATE : (dataType == DataType.ENUM ? BizDataTypeEnum.ENUM : (dataType == DataType.BYTEARRAY ? BizDataTypeEnum.IMAGE : (dataType == DataType.BOSUUID ? BizDataTypeEnum.STRING : (dataType == DataType.TIME ? BizDataTypeEnum.TIME : (dataType == DataType.BYTEARRAY ? BizDataTypeEnum.IMAGE : BizDataTypeEnum.OTHER))))))))))));
        return bizDataType;
    }

    public String getFormatName(String format) {
        if (format == null || format.equals("")) {
            return null;
        }
        int first = format.indexOf("$");
        if (first != 0 || format.substring(first) == null) {
            return null;
        }
        format = format.substring(first + 1);
        int last = format.lastIndexOf("$");
        if (last == format.length() - 1) {
            format = format.substring(0, last);
        }
        return format;
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
    }

    public boolean destroyWindow() {
        if (this.tableList.getEditManager() != null) {
            this.tableList.getEditManager().stopEditing();
        }
        return super.destroyWindow();
    }
}

