/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer.commands;

import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;
import com.kingdee.eas.ep.webclient.editor.webui.designer.AbstractWebEditPartViewer;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebItemInfoAdapter;
import com.kingdee.eas.ep.webclient.model.WebItemCollection;
import com.kingdee.eas.ep.webclient.model.WebItemInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class DisplaceCommand
extends Command {
    private AbstractWebEditPartViewer viewer;
    private WebItemInfoAdapter source;
    private WebItemInfoAdapter target;
    private List items;
    private int targetIndex;
    private int sourceIndex;

    public DisplaceCommand(AbstractWebEditPartViewer viewer, WebItemInfoAdapter source, WebItemInfoAdapter target) {
        this.viewer = viewer;
        this.source = source;
        this.target = target;
        WebItemCollection itemList = (WebItemCollection)viewer.getNode().getConfigureItems();
        this.items = new ArrayList(itemList.size());
        int size = itemList.size();
        for (int i = 0; i < size; ++i) {
            this.items.add(itemList.get(i));
        }
        Collections.sort(this.items, new Comparator(){

            public int compare(Object o1, Object o2) {
                WebItemInfo m1 = (WebItemInfo)o1;
                WebItemInfo m2 = (WebItemInfo)o2;
                return (Integer)m1.getConstraint() - (Integer)m2.getConstraint();
            }
        });
        this.targetIndex = this.items.indexOf(target.getItem());
        this.sourceIndex = this.items.indexOf(source.getItem());
    }

    public boolean canExecute() {
        return this.sourceIndex != this.targetIndex;
    }

    public void execute() {
        this.swap(this.sourceIndex, this.targetIndex);
        Map itemAdapterMap = this.viewer.getItemAdapterMap();
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            WebItemInfo item = (WebItemInfo)this.items.get(i);
            Object obj = itemAdapterMap.get(item);
            if (!(obj instanceof WebItemInfoAdapter)) continue;
            ((WebItemInfoAdapter)((Object)obj)).setConstraint(new Integer(i));
        }
    }

    public void undo() {
        this.swap(this.targetIndex, this.sourceIndex);
        Map itemAdapterMap = this.viewer.getItemAdapterMap();
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            WebItemInfo item = (WebItemInfo)this.items.get(i);
            Object obj = itemAdapterMap.get(item);
            if (!(obj instanceof WebItemInfoAdapter)) continue;
            ((WebItemInfoAdapter)((Object)obj)).setConstraint(new Integer(i));
        }
    }

    public void swap(int source, int target) {
        WebItemInfo o1 = (WebItemInfo)this.items.get(source);
        this.items.remove(source);
        this.items.add(target, o1);
    }
}

