/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.ep.index.MergeDocIDRemapper;
import org.apache.lucene.ep.index.MergePolicy;
import org.apache.lucene.ep.index.SegmentInfos;

class BufferedDeletes {
    int numTerms;
    Map terms;
    Map queries = new HashMap();
    List docIDs = new ArrayList();
    long bytesUsed;
    private final boolean doTermSort;

    public BufferedDeletes(boolean doTermSort) {
        this.doTermSort = doTermSort;
        this.terms = doTermSort ? new TreeMap() : new HashMap();
    }

    int size() {
        return this.numTerms + this.queries.size() + this.docIDs.size();
    }

    void update(BufferedDeletes in) {
        this.numTerms += in.numTerms;
        this.bytesUsed += in.bytesUsed;
        this.terms.putAll(in.terms);
        this.queries.putAll(in.queries);
        this.docIDs.addAll(in.docIDs);
        in.clear();
    }

    void clear() {
        this.terms.clear();
        this.queries.clear();
        this.docIDs.clear();
        this.numTerms = 0;
        this.bytesUsed = 0L;
    }

    void addBytesUsed(long b) {
        this.bytesUsed += b;
    }

    boolean any() {
        return this.terms.size() > 0 || this.docIDs.size() > 0 || this.queries.size() > 0;
    }

    synchronized void remap(MergeDocIDRemapper mapper, SegmentInfos infos, int[][] docMaps, int[] delCounts, MergePolicy.OneMerge merge, int mergeDocCount) {
        HashMap newDeleteQueries;
        ArrayList<Integer> newDeleteDocIDs;
        AbstractMap newDeleteTerms;
        if (this.terms.size() > 0) {
            newDeleteTerms = this.doTermSort ? new TreeMap() : new HashMap();
            for (Map.Entry entry : this.terms.entrySet()) {
                Object num = (Num)entry.getValue();
                newDeleteTerms.put(entry.getKey(), new Num(mapper.remap(((Num)num).getNum())));
            }
        } else {
            newDeleteTerms = null;
        }
        if (this.docIDs.size() > 0) {
            newDeleteDocIDs = new ArrayList<Integer>(this.docIDs.size());
            for (Object num : this.docIDs) {
                newDeleteDocIDs.add(new Integer(mapper.remap((Integer)num)));
            }
        } else {
            newDeleteDocIDs = null;
        }
        if (this.queries.size() > 0) {
            newDeleteQueries = new HashMap(this.queries.size());
            for (Map.Entry entry : this.queries.entrySet()) {
                Integer num = (Integer)entry.getValue();
                newDeleteQueries.put(entry.getKey(), new Integer(mapper.remap(num)));
            }
        } else {
            newDeleteQueries = null;
        }
        if (newDeleteTerms != null) {
            this.terms = newDeleteTerms;
        }
        if (newDeleteDocIDs != null) {
            this.docIDs = newDeleteDocIDs;
        }
        if (newDeleteQueries != null) {
            this.queries = newDeleteQueries;
        }
    }

    static final class Num {
        private int num;

        Num(int num) {
            this.num = num;
        }

        int getNum() {
            return this.num;
        }

        void setNum(int num) {
            if (num > this.num) {
                this.num = num;
            }
        }
    }
}

