/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.ep.index.DocInverterPerThread;
import org.apache.lucene.ep.index.FieldInfo;
import org.apache.lucene.ep.index.FieldInfos;
import org.apache.lucene.ep.index.InvertedDocEndConsumer;
import org.apache.lucene.ep.index.InvertedDocEndConsumerPerThread;
import org.apache.lucene.ep.index.NormsWriterPerField;
import org.apache.lucene.ep.index.NormsWriterPerThread;
import org.apache.lucene.ep.index.SegmentMerger;
import org.apache.lucene.ep.index.SegmentWriteState;
import org.apache.lucene.ep.search.Similarity;
import org.apache.lucene.ep.store.IndexOutput;

final class NormsWriter
extends InvertedDocEndConsumer {
    private static final byte defaultNorm = Similarity.encodeNorm(1.0f);
    private FieldInfos fieldInfos;

    NormsWriter() {
    }

    @Override
    public InvertedDocEndConsumerPerThread addThread(DocInverterPerThread docInverterPerThread) {
        return new NormsWriterPerThread(docInverterPerThread, this);
    }

    @Override
    public void abort() {
    }

    void files(Collection files) {
    }

    @Override
    void setFieldInfos(FieldInfos fieldInfos) {
        this.fieldInfos = fieldInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(Map threadsAndFields, SegmentWriteState state) throws IOException {
        HashMap<FieldInfo, ArrayList<NormsWriterPerField>> byField = new HashMap<FieldInfo, ArrayList<NormsWriterPerField>>();
        for (Map.Entry entry : threadsAndFields.entrySet()) {
            Collection fields = (Collection)entry.getValue();
            Iterator fieldsIt = fields.iterator();
            while (fieldsIt.hasNext()) {
                NormsWriterPerField perField = (NormsWriterPerField)fieldsIt.next();
                if (perField.upto > 0) {
                    ArrayList<NormsWriterPerField> l = (ArrayList<NormsWriterPerField>)byField.get(perField.fieldInfo);
                    if (l == null) {
                        l = new ArrayList<NormsWriterPerField>();
                        byField.put(perField.fieldInfo, l);
                    }
                    l.add(perField);
                    continue;
                }
                fieldsIt.remove();
            }
        }
        String normsFileName = state.segmentName + "." + "nrm";
        state.flushedFiles.add(normsFileName);
        try (IndexOutput normsOut = state.directory.createOutput(normsFileName);){
            normsOut.writeBytes(SegmentMerger.NORMS_HEADER, 0, SegmentMerger.NORMS_HEADER.length);
            int numField = this.fieldInfos.size();
            int normCount = 0;
            for (int fieldNumber = 0; fieldNumber < numField; ++fieldNumber) {
                int upto;
                FieldInfo fieldInfo = this.fieldInfos.fieldInfo(fieldNumber);
                List toMerge = (List)byField.get(fieldInfo);
                if (toMerge != null) {
                    int numFields = toMerge.size();
                    ++normCount;
                    NormsWriterPerField[] fields = new NormsWriterPerField[numFields];
                    int[] uptos = new int[numFields];
                    for (int j = 0; j < numFields; ++j) {
                        fields[j] = (NormsWriterPerField)toMerge.get(j);
                    }
                    int numLeft = numFields;
                    while (numLeft > 0) {
                        assert (uptos[0] < fields[0].docIDs.length) : " uptos[0]=" + uptos[0] + " len=" + fields[0].docIDs.length;
                        int minLoc = 0;
                        int minDocID = fields[0].docIDs[uptos[0]];
                        for (int j = 1; j < numLeft; ++j) {
                            int docID = fields[j].docIDs[uptos[j]];
                            if (docID >= minDocID) continue;
                            minDocID = docID;
                            minLoc = j;
                        }
                        assert (minDocID < state.numDocs);
                        while (upto < minDocID) {
                            normsOut.writeByte(defaultNorm);
                            ++upto;
                        }
                        normsOut.writeByte(fields[minLoc].norms[uptos[minLoc]]);
                        int n = minLoc;
                        uptos[n] = uptos[n] + 1;
                        ++upto;
                        if (uptos[minLoc] != fields[minLoc].upto) continue;
                        fields[minLoc].reset();
                        if (minLoc != numLeft - 1) {
                            fields[minLoc] = fields[numLeft - 1];
                            uptos[minLoc] = uptos[numLeft - 1];
                        }
                        --numLeft;
                    }
                    while (upto < state.numDocs) {
                        normsOut.writeByte(defaultNorm);
                        ++upto;
                    }
                } else if (fieldInfo.isIndexed && !fieldInfo.omitNorms) {
                    ++normCount;
                    for (upto = 0; upto < state.numDocs; ++upto) {
                        normsOut.writeByte(defaultNorm);
                    }
                }
                assert ((long)(4 + normCount * state.numDocs) == normsOut.getFilePointer()) : ".nrm file size mismatch: expected=" + (4 + normCount * state.numDocs) + " actual=" + normsOut.getFilePointer();
            }
        }
    }

    @Override
    void closeDocStore(SegmentWriteState state) {
    }
}

