/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import org.apache.lucene.ep.search.Explanation;
import org.apache.lucene.ep.search.Scorer;
import org.apache.lucene.ep.search.Similarity;

class DisjunctionMaxScorer
extends Scorer {
    private final Scorer[] subScorers;
    private int numScorers;
    private final float tieBreakerMultiplier;
    private int doc = -1;

    public DisjunctionMaxScorer(float tieBreakerMultiplier, Similarity similarity, Scorer[] subScorers, int numScorers) throws IOException {
        super(similarity);
        this.tieBreakerMultiplier = tieBreakerMultiplier;
        this.subScorers = subScorers;
        this.numScorers = numScorers;
        this.heapify();
    }

    @Override
    public boolean next() throws IOException {
        return this.nextDoc() != Integer.MAX_VALUE;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.numScorers == 0) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        while (this.subScorers[0].docID() == this.doc) {
            if (this.subScorers[0].nextDoc() != Integer.MAX_VALUE) {
                this.heapAdjust(0);
                continue;
            }
            this.heapRemoveRoot();
            if (this.numScorers != 0) continue;
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        this.doc = this.subScorers[0].docID();
        return this.doc;
    }

    @Override
    public int doc() {
        return this.subScorers[0].doc();
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public float score() throws IOException {
        int doc = this.subScorers[0].docID();
        float[] sum = new float[]{this.subScorers[0].score()};
        float[] max = new float[]{sum[0]};
        int size = this.numScorers;
        this.scoreAll(1, size, doc, sum, max);
        this.scoreAll(2, size, doc, sum, max);
        return max[0] + (sum[0] - max[0]) * this.tieBreakerMultiplier;
    }

    private void scoreAll(int root, int size, int doc, float[] sum, float[] max) throws IOException {
        if (root < size && this.subScorers[root].docID() == doc) {
            float sub = this.subScorers[root].score();
            sum[0] = sum[0] + sub;
            max[0] = Math.max(max[0], sub);
            this.scoreAll((root << 1) + 1, size, doc, sum, max);
            this.scoreAll((root << 1) + 2, size, doc, sum, max);
        }
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        return this.advance(target) != Integer.MAX_VALUE;
    }

    @Override
    public int advance(int target) throws IOException {
        if (this.numScorers == 0) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        while (this.subScorers[0].docID() < target) {
            if (this.subScorers[0].advance(target) != Integer.MAX_VALUE) {
                this.heapAdjust(0);
                continue;
            }
            this.heapRemoveRoot();
            if (this.numScorers != 0) continue;
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        this.doc = this.subScorers[0].docID();
        return this.doc;
    }

    @Override
    public Explanation explain(int doc) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void heapify() {
        for (int i = (this.numScorers >> 1) - 1; i >= 0; --i) {
            this.heapAdjust(i);
        }
    }

    private void heapAdjust(int root) {
        Scorer scorer = this.subScorers[root];
        int doc = scorer.docID();
        int i = root;
        while (i <= (this.numScorers >> 1) - 1) {
            int lchild = (i << 1) + 1;
            Scorer lscorer = this.subScorers[lchild];
            int ldoc = lscorer.docID();
            int rdoc = Integer.MAX_VALUE;
            int rchild = (i << 1) + 2;
            Scorer rscorer = null;
            if (rchild < this.numScorers) {
                rscorer = this.subScorers[rchild];
                rdoc = rscorer.docID();
            }
            if (ldoc < doc) {
                if (rdoc < ldoc) {
                    this.subScorers[i] = rscorer;
                    this.subScorers[rchild] = scorer;
                    i = rchild;
                    continue;
                }
                this.subScorers[i] = lscorer;
                this.subScorers[lchild] = scorer;
                i = lchild;
                continue;
            }
            if (rdoc < doc) {
                this.subScorers[i] = rscorer;
                this.subScorers[rchild] = scorer;
                i = rchild;
                continue;
            }
            return;
        }
    }

    private void heapRemoveRoot() {
        if (this.numScorers == 1) {
            this.subScorers[0] = null;
            this.numScorers = 0;
        } else {
            this.subScorers[0] = this.subScorers[this.numScorers - 1];
            this.subScorers[this.numScorers - 1] = null;
            --this.numScorers;
            this.heapAdjust(0);
        }
    }
}

