/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.search.FieldCache;
import org.apache.lucene.ep.search.ScoreDoc;
import org.apache.lucene.ep.search.ScoreDocComparator;
import org.apache.lucene.ep.search.SortComparatorSource;

public abstract class SortComparator
implements SortComparatorSource {
    @Override
    public ScoreDocComparator newComparator(IndexReader reader, String fieldname) throws IOException {
        String field = fieldname.intern();
        final Comparable[] cachedValues = FieldCache.DEFAULT.getCustom(reader, field, this);
        return new ScoreDocComparator(){

            @Override
            public int compare(ScoreDoc i, ScoreDoc j) {
                return cachedValues[i.doc].compareTo(cachedValues[j.doc]);
            }

            @Override
            public Comparable sortValue(ScoreDoc i) {
                return cachedValues[i.doc];
            }

            @Override
            public int sortType() {
                return 9;
            }
        };
    }

    protected abstract Comparable getComparable(String var1);
}

