/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.util;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CloseableThreadLocal {
    private ThreadLocal t = new ThreadLocal();
    private Map hardRefs = new HashMap();

    protected Object initialValue() {
        return null;
    }

    public Object get() {
        WeakReference weakRef = (WeakReference)this.t.get();
        if (weakRef == null) {
            Object iv = this.initialValue();
            if (iv != null) {
                this.set(iv);
                return iv;
            }
            return null;
        }
        return weakRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Object object) {
        this.t.set(new WeakReference<Object>(object));
        Map map = this.hardRefs;
        synchronized (map) {
            this.hardRefs.put(Thread.currentThread(), object);
            Iterator it = this.hardRefs.keySet().iterator();
            while (it.hasNext()) {
                Thread t = (Thread)it.next();
                if (t.isAlive()) continue;
                it.remove();
            }
        }
    }

    public void close() {
        this.hardRefs = null;
        this.t = null;
    }
}

