/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.ExtendPointInfo;
import com.kingdee.eas.ep.PlugInCollection;
import com.kingdee.eas.ep.plugin.IPluginCacheSyn;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class PluginCacheSynFactory
implements IPluginCacheSyn {
    private List servers = new ArrayList();

    private PluginCacheSynFactory() {
    }

    public static IPluginCacheSyn getInstance() {
        PluginCacheSynFactory syn = new PluginCacheSynFactory();
        RPCServerView sv = RPCServerView.getLast();
        if (sv == null) {
            return syn;
        }
        IRPCServer[] ss = sv.getServers();
        for (int i = 0; i < ss.length; ++i) {
            String url;
            IRPCServer s = ss[i];
            if (s.connectionFailed() || StringUtils.isEmpty((String)(url = s.getUrl())) || PluginCacheSynFactory.isLocal(url)) continue;
            IPluginCacheSyn pcs = (IPluginCacheSyn)RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.eas.ep.plugin.PluginCacheSyn", IPluginCacheSyn.class);
            syn.servers.add(pcs);
        }
        return syn;
    }

    private static boolean isLocal(String url) {
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearCache() {
        int size = this.servers.size();
        for (int i = 0; i < size; ++i) {
            ((IPluginCacheSyn)this.servers.get(i)).clearCache();
        }
    }

    @Override
    public void clearCache(String ais) {
        int size = this.servers.size();
        for (int i = 0; i < size; ++i) {
            ((IPluginCacheSyn)this.servers.get(i)).clearCache(ais);
        }
    }

    @Override
    public void reload(Context ctx, String meta, ExtendPointInfo point, PlugInCollection plugin) throws EASBizException, BOSException {
        int size = this.servers.size();
        for (int i = 0; i < size; ++i) {
            ((IPluginCacheSyn)this.servers.get(i)).reload(ctx, meta, point, plugin);
        }
    }

    @Override
    public void reload(Context ctx, PlugInCollection col) throws EASBizException, BOSException {
        int size = this.servers.size();
        for (int i = 0; i < size; ++i) {
            ((IPluginCacheSyn)this.servers.get(i)).reload(ctx, col);
        }
    }

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return null;
    }
}

