/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.ILibScript;
import com.kingdee.eas.ep.IPlugIn;
import com.kingdee.eas.ep.LibScriptCollection;
import com.kingdee.eas.ep.LibScriptFactory;
import com.kingdee.eas.ep.PlugInFactory;
import com.kingdee.eas.ep.PlugInScriptInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScriptReference {
    public static String getScript(Context ctx, PlugInScriptInfo script) throws EASBizException, BOSException {
        String lib;
        if (script == null) {
            return null;
        }
        IPlugIn plugin = null;
        plugin = ctx == null ? PlugInFactory.getRemoteInstance() : PlugInFactory.getLocalInstance(ctx);
        StringBuffer r = new StringBuffer();
        if (!StringUtils.isEmpty((String)script.getReference()) && (lib = plugin.getExecuteLibScript(script.getReference())) != null) {
            r.append("//Function Lib Begin\n");
            r.append(lib);
            r.append("\n//Script Begin\n");
        }
        r.append(script.getContent());
        return r.toString();
    }

    public static String getLibScriptIds(Context ctx, Reference[] refs, String schemeID) throws EASBizException, BOSException {
        ILibScript libScript = null;
        libScript = ctx == null ? LibScriptFactory.getRemoteInstance() : LibScriptFactory.getLocalInstance(ctx);
        LibScriptCollection lsc = null;
        StringBuffer ids = null;
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < refs.length; ++i) {
            String id;
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)refs[i].getInstance()));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)refs[i].getFunction()));
            filter.getFilterItems().add(new FilterItemInfo("paramCount", (Object)new Integer(refs[i].getParamCount())));
            if (refs[i].getInstance().startsWith("dep")) {
                schemeID = "always_on";
            }
            filter.getFilterItems().add(new FilterItemInfo("schemeID", (Object)schemeID));
            evi.setFilter(filter);
            evi.getSelector().add(new SelectorItemInfo("id"));
            lsc = libScript.getLibScriptCollection(evi);
            if (lsc == null || lsc.size() <= 0 || idSet.contains(id = lsc.get(0).getId().toString())) continue;
            if (ids == null) {
                ids = new StringBuffer();
            } else {
                ids.append(";");
            }
            idSet.add(id);
            ids.append(id);
        }
        if (ids != null) {
            return ids.toString();
        }
        return null;
    }

    public static Reference[] parse(String script) {
        Reference[] re = new Reference[]{};
        if (StringUtils.isEmpty((String)script)) {
            return re;
        }
        String regEx = "\\$.+\n*\\..+\\(.*\\)";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(script);
        ArrayList<Reference> refs = new ArrayList<Reference>();
        while (m.find()) {
            String ref = m.group().replaceAll("\n", "");
            refs.add(ScriptReference.buildReference(ref));
        }
        return refs.toArray(new Reference[refs.size()]);
    }

    public static Reference buildReference(String re) {
        if (StringUtils.isEmpty((String)re)) {
            return null;
        }
        Reference ref = new Reference();
        String ins = re.substring("$".length(), re.indexOf(".")).trim();
        String name = re.substring(re.indexOf(".") + 1, re.indexOf("(")).trim();
        String params = re.substring(re.indexOf("(") + 1, re.indexOf(")"));
        int count = 0;
        if (!StringUtils.isEmpty((String)params)) {
            count = StringUtils.split((String)params, (String)",").length;
        }
        ref.setFunction(name);
        ref.setInstance(ins);
        ref.setParamCount(count);
        return ref;
    }

    public static class Reference {
        private String instance = null;
        private String function = null;
        private int paramCount = 0;

        public String getInstance() {
            return this.instance;
        }

        public void setInstance(String instance) {
            this.instance = instance;
        }

        public String getFunction() {
            return this.function;
        }

        public void setFunction(String function) {
            this.function = function;
        }

        public int getParamCount() {
            return this.paramCount;
        }

        public void setParamCount(int paramCount) {
            this.paramCount = paramCount;
        }
    }
}

