/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.updater;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.listener.CommonListenerManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizrule.ConditionRuleInfo;
import com.kingdee.bos.metadata.bizrule.RuleSetCtrl;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.bizrule.common.AbstractExpressionInfo;
import com.kingdee.bos.metadata.bizrule.common.AbstractRuleInfo;
import com.kingdee.bos.metadata.bizrule.common.ActionInfo;
import com.kingdee.bos.metadata.bizrule.common.EventType;
import com.kingdee.bos.metadata.bizrule.common.ExpressionType;
import com.kingdee.bos.metadata.bizrule.common.SimpleExpressionInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.configure.IServerMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectAssembler;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper;
import com.kingdee.bos.ui.bizunitproxy.UIProxyHelper;
import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutConstraint;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.layout.KDRectangle;
import com.kingdee.bos.ui.layout.UIComponentConfigInfo;
import com.kingdee.bos.ui.layout.UIKDTableConfigInfo;
import com.kingdee.bos.ui.layout.UILayoutConfigInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uict.BizConfigureCollection;
import com.kingdee.eas.base.uict.BizConfigureFactory;
import com.kingdee.eas.base.uict.BizConfigureInfo;
import com.kingdee.eas.base.uict.IBizConfigure;
import com.kingdee.eas.base.uict.IOrgUict;
import com.kingdee.eas.base.uict.IUserOrgUict;
import com.kingdee.eas.base.uict.OrgUictCollection;
import com.kingdee.eas.base.uict.OrgUictFactory;
import com.kingdee.eas.base.uict.OrgUictInfo;
import com.kingdee.eas.base.uict.UserOrgUictCollection;
import com.kingdee.eas.base.uict.UserOrgUictFactory;
import com.kingdee.eas.base.uict.UserOrgUictInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.CustomizedUnitFactory;
import com.kingdee.eas.ep.CustomizedUnitInfo;
import com.kingdee.eas.ep.EditUIConfigureFactory;
import com.kingdee.eas.ep.EditUIConfigureInfo;
import com.kingdee.eas.ep.EditUIUserOrgUictFactory;
import com.kingdee.eas.ep.ICustomizedScheme;
import com.kingdee.eas.ep.ICustomizedUnit;
import com.kingdee.eas.ep.IEditUIConfigure;
import com.kingdee.eas.ep.IEditUIUserOrgUict;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.updater.BizExpCodeGenerator4Update;
import com.kingdee.eas.ep.updater.BizExpressionType4Update;
import com.kingdee.eas.ep.updater.BizSettingExpression4Update;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfo;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfoConverter;
import com.kingdee.eas.ep.updater.ImportBizUnitHelper4Update;
import com.kingdee.eas.ep.updater.PKMapping;
import com.kingdee.eas.ep.updater.UpdateToSP2;
import com.kingdee.eas.ep.updater.UtilsForUpdate;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.expression.IBizConfigureInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class TranslateToCustomScheme {
    private static Logger logger = CoreUIObject.getLogger(TranslateToCustomScheme.class);
    public static final String CONTAINER = "container";
    private static final String EDITUI = "editui";
    private static final String LISTUI = "listui";
    private static BOSUuid cusSchemeId;
    public static final String CONFIGURE_ORDER = "_Configure_Order";

    public static void translateToCustom(Context ctx) {
        try {
            logger.error((Object)"start Translate To CustomScheme........");
            ctx.setCaller((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"));
            CtrlUnitCollection cuCollection = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitCollection();
            if (cuCollection == null || cuCollection.size() < 1) {
                logger.error((Object)"TranslateToCustomScheme : load CtrlUnitInfo failed ");
                CommonListenerManager.disable((Context)ctx, (String)TranslateToCustomScheme.class.getName(), (String)"translateToCustom");
                return;
            }
            CtrlUnitInfo cu = cuCollection.get(0);
            IBizConfigure configure = BizConfigureFactory.getLocalInstance((Context)ctx);
            BizConfigureCollection configureCollection = configure.getBizConfigureCollection();
            if (configureCollection == null || configureCollection.size() < 1) {
                logger.error((Object)"TranslateToCustomScheme : no bizconfigureInfo exist ");
                CommonListenerManager.disable((Context)ctx, (String)TranslateToCustomScheme.class.getName(), (String)"translateToCustom");
                return;
            }
            logger.error((Object)("TranslateToCustomScheme : " + configureCollection.size() + "bizconfigure scheme at all"));
            TreeMap<String, PKMapping> biz2cus = new TreeMap<String, PKMapping>();
            BizConfigureInfo configureInfo = null;
            Project project = new Project();
            CustomizedSchemeInfo csInfo = new CustomizedSchemeInfo();
            cusSchemeId = BOSUuid.create((BOSObjectType)csInfo.getBOSType());
            project.setId(cusSchemeId.toString());
            IServerMetadataStore mdstore = MetadataStoreFactory.getServerMetadataStore((Context)ctx);
            mdstore.upgrade(project);
            csInfo.setId(cusSchemeId);
            csInfo.setName("bizconfigure");
            csInfo.setAlias("bizconfigure");
            csInfo.setDescription("bizconfigure");
            csInfo.setDepend(null);
            csInfo.setBuildNumber("CS_USERDEFINE");
            csInfo.setStart(false);
            CustomizedUnitInfo parent = new CustomizedUnitInfo();
            parent.setCustomizedSchemeID(cusSchemeId.toString());
            parent.setNumber(cusSchemeId.toString());
            parent.setName("bizconfigure");
            parent.setDisplayName("bizconfigure");
            parent.setAlias("bizconfigure");
            parent.setNodeType(NodeTypeEnum.ROOT);
            parent.setLevel(1);
            parent.setIsLeaf(false);
            parent.setCU(cu);
            parent.setCustomizedSchemeID(csInfo.getId().toString());
            ICustomizedUnit icu = CustomizedUnitFactory.getLocalInstance(ctx);
            icu.addnew((CoreBaseInfo)parent);
            String pName = parent.getName() + "Permission";
            String pAlias = parent.getAlias() + "\u6743\u9650";
            CustomizedUnitInfo permission = new CustomizedUnitInfo();
            permission.setNumber(cusSchemeId.toString());
            permission.setName(pName);
            permission.setDisplayName(pName);
            permission.setAlias(pAlias);
            permission.setNodeType(NodeTypeEnum.PERMISSION);
            permission.setLevel(2);
            permission.setIsLeaf(true);
            permission.setMetaDataPK("base_bos");
            permission.setParent(parent);
            permission.setCU(cu);
            permission.setCustomizedSchemeID(parent.getCustomizedSchemeID());
            icu.addnew((CoreBaseInfo)permission);
            CustomizedUnitInfo exception = new CustomizedUnitInfo();
            exception.setName(parent.getName() + "Exception");
            exception.setAlias(parent.getAlias() + "\u5f02\u5e38");
            exception.setNodeType(NodeTypeEnum.EXCEPTION);
            exception.setLevel(2);
            exception.setIsLeaf(true);
            exception.setMetaDataPK(exception.getName());
            exception.setParent(parent);
            exception.setCU(cu);
            exception.setCustomizedSchemeID(parent.getCustomizedSchemeID());
            icu.addnew((CoreBaseInfo)exception);
            for (int j = 0; j < configureCollection.size(); ++j) {
                configureInfo = configureCollection.get(j);
                logger.error((Object)("TranslateToCustomScheme : start translate bizconfigureInfo \uff1a" + configureInfo.getName()));
                if (StringUtils.isEmpty((String)configureInfo.getBizUnitPK())) {
                    logger.error((Object)("TranslateToCustomScheme : can't find bizunit" + configureInfo.getBizUnitPK()));
                    continue;
                }
                BizUnitInfo buInfo = UtilsForUpdate.loadBizUnit((IMetaDataPK)new MetaDataPK(configureInfo.getBizUnitPK()), ctx);
                UIObjectInfo editUIModel = TranslateToCustomScheme.getUIModel(configureInfo, project, ctx);
                UIObjectInfo listUIModel = TranslateToCustomScheme.getListUIModel(configureInfo, project, ctx);
                if (buInfo != null && editUIModel != null) {
                    String listUIFunctionPK;
                    String editUIFunctionPK;
                    String entityFunctionPK;
                    String sWebEditUIPK;
                    String sWebListUIPK;
                    String sEditUIPK;
                    String sListUIPK;
                    String sQueryPK;
                    CustomizedUnitNodeInfo.MetaDataInfo md;
                    CustomizedUnitNodeInfo cunInfo = new CustomizedUnitNodeInfo();
                    cunInfo.setPackagePK(buInfo.getPackage());
                    cunInfo.setName(buInfo.getName());
                    cunInfo.setAlias(buInfo.getAlias());
                    cunInfo.setCustomizedType("bizunit");
                    String sEntityPK = buInfo.getString("entityPK");
                    if (!StringUtils.isEmpty((String)sEntityPK)) {
                        EntityObjectInfo entity = UtilsForUpdate.loadEntity((IMetaDataPK)new MetaDataPK(sEntityPK), null);
                        ArrayList entitys = new ArrayList();
                        ImportBizUnitHelper4Update.getEntitys(entity, entitys);
                        for (EntityObjectInfo eoi : entitys) {
                            md = new CustomizedUnitNodeInfo.MetaDataInfo(eoi.getPackage(), eoi.getName(), eoi.getAlias());
                            cunInfo.getEntity().add(md);
                        }
                    }
                    if (!StringUtils.isEmpty((String)(sQueryPK = buInfo.getString("queryPK")))) {
                        QueryInfo query = UtilsForUpdate.loadQuery((IMetaDataPK)new MetaDataPK(sQueryPK), null);
                        CustomizedUnitNodeInfo.MetaDataInfo md2 = new CustomizedUnitNodeInfo.MetaDataInfo(query.getPackage(), query.getName(), query.getAlias());
                        cunInfo.getQuery().add(md2);
                    }
                    if (!StringUtils.isEmpty((String)(sListUIPK = buInfo.getString("listUIPK")))) {
                        UIObjectInfo listui = UtilsForUpdate.loadUI((IMetaDataPK)new MetaDataPK(sListUIPK), null);
                        CustomizedUnitNodeInfo.MetaDataInfo md3 = new CustomizedUnitNodeInfo.MetaDataInfo(listui.getPackage(), listui.getName(), listui.getAlias());
                        cunInfo.getUi().getListui().add(md3);
                    }
                    if (!StringUtils.isEmpty((String)(sEditUIPK = buInfo.getString("editUIPK")))) {
                        UIObjectInfo editui = UtilsForUpdate.loadUI((IMetaDataPK)new MetaDataPK(sEditUIPK), null);
                        md = new CustomizedUnitNodeInfo.MetaDataInfo(editui.getPackage(), editui.getName(), editui.getAlias());
                        cunInfo.getUi().getEditui().add(md);
                    }
                    if (!StringUtils.isEmpty((String)(sWebListUIPK = buInfo.getString("webListUIPK")))) {
                        WebUIObjectInfo listui = UtilsForUpdate.loadWebUI((IMetaDataPK)new MetaDataPK(sWebListUIPK), null);
                        CustomizedUnitNodeInfo.MetaDataInfo md4 = new CustomizedUnitNodeInfo.MetaDataInfo(listui.getPackage(), listui.getName(), listui.getAlias());
                        cunInfo.getWebUi().getListui().add(md4);
                    }
                    if (!StringUtils.isEmpty((String)(sWebEditUIPK = buInfo.getString("webEditUIPK")))) {
                        WebUIObjectInfo editui = UtilsForUpdate.loadWebUI((IMetaDataPK)new MetaDataPK(sEditUIPK), null);
                        CustomizedUnitNodeInfo.MetaDataInfo md5 = new CustomizedUnitNodeInfo.MetaDataInfo(editui.getPackage(), editui.getName(), editui.getAlias());
                        cunInfo.getWebUi().getEditui().add(md5);
                    }
                    if (!StringUtils.isEmpty((String)(entityFunctionPK = buInfo.getString("entityFunctionPK")))) {
                        FunctionObjectInfo function = UtilsForUpdate.loadFunction((IMetaDataPK)new MetaDataPK(entityFunctionPK), null);
                        CustomizedUnitNodeInfo.MetaDataInfo md6 = new CustomizedUnitNodeInfo.MetaDataInfo(function.getPackage(), function.getName(), function.getAlias());
                        cunInfo.getFunction().add(md6);
                    }
                    if (!StringUtils.isEmpty((String)(editUIFunctionPK = buInfo.getString("editUIFunctionPK")))) {
                        FunctionObjectInfo function = UtilsForUpdate.loadFunction((IMetaDataPK)new MetaDataPK(editUIFunctionPK), null);
                        CustomizedUnitNodeInfo.MetaDataInfo md7 = new CustomizedUnitNodeInfo.MetaDataInfo(function.getPackage(), function.getName(), function.getAlias());
                        cunInfo.getFunction().add(md7);
                    }
                    if (!StringUtils.isEmpty((String)(listUIFunctionPK = buInfo.getString("listUIFunctionPK")))) {
                        FunctionObjectInfo function = UtilsForUpdate.loadFunction((IMetaDataPK)new MetaDataPK(listUIFunctionPK), null);
                        CustomizedUnitNodeInfo.MetaDataInfo md8 = new CustomizedUnitNodeInfo.MetaDataInfo(function.getPackage(), function.getName(), function.getAlias());
                        cunInfo.getFunction().add(md8);
                    }
                    String xml = CustomizedUnitNodeInfoConverter.coverter2xml(cunInfo);
                    ICustomizedUnit bizInterface = CustomizedUnitFactory.getLocalInstance(ctx);
                    CustomizedUnitInfo dataObj = new CustomizedUnitInfo();
                    dataObj.setId(BOSUuid.create((BOSObjectType)dataObj.getBOSType()));
                    dataObj.setNumber(dataObj.getId().toString());
                    dataObj.setName(cunInfo.getName());
                    dataObj.setDisplayName(cunInfo.getAlias());
                    dataObj.setNodeType(NodeTypeEnum.CUSTOMIZED_UNIT);
                    dataObj.setCustomizedUnitObject(xml);
                    dataObj.setIsLeaf(false);
                    dataObj.setLevel(parent.getLevel() + 1);
                    dataObj.setParent(parent);
                    dataObj.setCU(cu);
                    dataObj.setCustomizedSchemeID(parent.getCustomizedSchemeID());
                    IEditUIConfigure ioc = EditUIConfigureFactory.getLocalInstance(ctx);
                    IObjectPK editpk = null;
                    IObjectPK listpk = null;
                    try {
                        EditUIConfigureInfo editUIConfigureInfo = TranslateToCustomScheme.translateEditUI(configureInfo, editUIModel, project, ctx);
                        editUIConfigureInfo.setCustomizedSchemeID(cusSchemeId.toString());
                        UpdateToSP2.updateUIObject(ctx, editUIModel, project);
                        UtilsForUpdate.saveMetadata((AbstractMetaDataValue)editUIModel, csInfo.getId().toString(), project, ctx);
                        editpk = ioc.addnew(editUIConfigureInfo);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage());
                        logger.error((Object)e.getStackTrace());
                        continue;
                    }
                    if (listUIModel != null) {
                        try {
                            EditUIConfigureInfo listUIConfigureInfo = TranslateToCustomScheme.translateListUI(configureInfo, listUIModel, project, ctx);
                            listUIConfigureInfo.setCustomizedSchemeID(cusSchemeId.toString());
                            UtilsForUpdate.saveMetadata((AbstractMetaDataValue)listUIModel, csInfo.getId().toString(), project, ctx);
                            listpk = ioc.addnew(listUIConfigureInfo);
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage());
                            logger.error((Object)e.getStackTrace());
                            continue;
                        }
                    }
                    PKMapping pk = new PKMapping();
                    pk.setBizconPK(configureInfo.getId().toString());
                    pk.setEditconPK(editpk.toString());
                    pk.setEdituiPK(configureInfo.getUIObjectPK());
                    if (listpk != null) {
                        pk.setListconPK(listpk.toString());
                        pk.setListuiPK(configureInfo.getListUIObjectPK());
                    }
                    biz2cus.put(configureInfo.getId().toString(), pk);
                    bizInterface.addnew((CoreBaseInfo)dataObj);
                    String tableSql = "If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FEditUIConfigID'  and KSQL_COL_TABNAME='T_HR_EmployeePage' ) ALTER TABLE T_HR_EmployeePage ADD FEditUIConfigID VARCHAR(44);";
                    DbUtil.execute((Context)ctx, (String)tableSql);
                    StringBuffer sql = new StringBuffer("UPDATE T_HR_EmployeePage SET FEditUIConfigID='");
                    sql.append(editpk.toString());
                    sql.append("' WHERE FUISchemeID='");
                    sql.append(configureInfo.getId().toString());
                    sql.append("'");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                }
                logger.error((Object)("TranslateToCustomScheme : success to translate bizconfigureInfo :" + configureInfo.getName()));
            }
            ICustomizedScheme ics = CustomizedSchemeFactory.getLocalInstance(ctx);
            ics.addnew2(csInfo);
            TranslateToCustomScheme.translateOrgUict(ctx, biz2cus);
            TranslateToCustomScheme.translateUserOrgUict(ctx, biz2cus, cu);
            CommonListenerManager.disable((Context)ctx, (String)TranslateToCustomScheme.class.getName(), (String)"translateToCustom");
            logger.error((Object)"TranslateToCustomScheme : success Translate To CustomScheme");
        }
        catch (Exception e) {
            logger.error((Object)"TranslateToCustomScheme : Custom Scheme Upgrade Error.", (Throwable)e);
        }
    }

    public static EditUIConfigureInfo translateEditUI(BizConfigureInfo configureInfo, UIObjectInfo uiModel, Project project, Context ctx) throws Exception {
        EditUIConfigureInfo editUIConfigureInfo = new EditUIConfigureInfo();
        editUIConfigureInfo.setUIObjectPK(configureInfo.getUIObjectPK());
        editUIConfigureInfo.setOrgType(configureInfo.getOrgType());
        editUIConfigureInfo.setName(configureInfo.getName());
        editUIConfigureInfo.setOrgUnit(configureInfo.getOrgUnit());
        editUIConfigureInfo.setCU(configureInfo.getCU());
        editUIConfigureInfo.setLastUpdateUser(configureInfo.getLastUpdateUser());
        editUIConfigureInfo.setCreator(configureInfo.getCreator());
        editUIConfigureInfo.setSimpleName(configureInfo.getId().toString());
        TranslateToCustomScheme.translateRuleSet(editUIConfigureInfo, configureInfo);
        TranslateToCustomScheme.translateUIObject(editUIConfigureInfo, configureInfo, uiModel, project, ctx, EDITUI);
        return editUIConfigureInfo;
    }

    public static EditUIConfigureInfo translateListUI(BizConfigureInfo configureInfo, UIObjectInfo uiModel, Project project, Context ctx) throws Exception {
        EditUIConfigureInfo editUIConfigureInfo = new EditUIConfigureInfo();
        editUIConfigureInfo.setUIObjectPK(configureInfo.getListUIObjectPK());
        editUIConfigureInfo.setOrgType(configureInfo.getOrgType());
        editUIConfigureInfo.setName(configureInfo.getName());
        editUIConfigureInfo.setOrgUnit(configureInfo.getOrgUnit());
        editUIConfigureInfo.setCU(configureInfo.getCU());
        editUIConfigureInfo.setLastUpdateUser(configureInfo.getLastUpdateUser());
        editUIConfigureInfo.setCreator(configureInfo.getCreator());
        editUIConfigureInfo.setSimpleName(configureInfo.getId().toString());
        TranslateToCustomScheme.translateUIObject(editUIConfigureInfo, configureInfo, uiModel, project, ctx, LISTUI);
        return editUIConfigureInfo;
    }

    public static void translateOrgUict(Context ctx, Map map) {
        if (map == null || map.keySet().size() < 1) {
            return;
        }
        try {
            IOrgUict orgUict = OrgUictFactory.getLocalInstance((Context)ctx);
            OrgUictCollection orgUictCollection = orgUict.getOrgUictCollection();
            if (orgUictCollection == null || orgUictCollection.size() < 1) {
                logger.error((Object)"orgUictCollection is null or no bizconfigureInfo translated");
                return;
            }
            IEditUIUserOrgUict editUIUserOrgUict = EditUIUserOrgUictFactory.getLocalInstance(ctx);
            for (int i = 0; i < orgUictCollection.size(); ++i) {
                OrgUictInfo orgUictInfo = orgUictCollection.get(i);
                if (map.get(orgUictInfo.getConfigureID()) == null || !(map.get(orgUictInfo.getConfigureID()) instanceof PKMapping)) {
                    logger.error((Object)("TranslateToCustomScheme : faild to translate orgUictInfo" + orgUictInfo.getId().toString() + "  can't find edituiconfigureid"));
                    continue;
                }
                PKMapping pk = (PKMapping)map.get(orgUictInfo.getConfigureID());
                String listuiPK = pk.getListuiPK();
                String edituiPK = pk.getEdituiPK();
                String listconPK = pk.getListconPK();
                String editconPK = pk.getEditconPK();
                if (editconPK == null) continue;
                if (edituiPK == null) {
                    if (orgUictInfo.getBizUnitPK() == null) {
                        logger.error((Object)("TranslateToCustomScheme : bizunitPk is null at OrgUictInfo : " + orgUictInfo.getId()));
                        continue;
                    }
                    BizUnitInfo bizUnitInfo = UtilsForUpdate.loadBizUnit((IMetaDataPK)new MetaDataPK(orgUictInfo.getBizUnitPK()), ctx);
                    if (bizUnitInfo.getEditUIPK() == null) {
                        logger.error((Object)("TranslateToCustomScheme : failed to get edituiPK at bizunit " + bizUnitInfo.getFullName()));
                        continue;
                    }
                    edituiPK = bizUnitInfo.getEditUIPK();
                }
                editUIUserOrgUict.addnew(null, editconPK, orgUictInfo.getOrgID(), null);
                if (listuiPK == null || listconPK == null) continue;
                editUIUserOrgUict.addnew(null, listuiPK, orgUictInfo.getOrgID(), null);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("TranslateToCustomScheme : " + e.getMessage()));
        }
        catch (Exception e) {
            logger.error((Object)("TranslateToCustomScheme : " + e.getMessage()));
        }
    }

    public static void translateUserOrgUict(Context ctx, Map map, CtrlUnitInfo cu) {
        if (map == null || map.keySet().size() < 1 || cu == null) {
            logger.error((Object)"TranslateToCustomScheme : pkmapping or cu is null ");
        }
        try {
            IUserOrgUict userOrgUict = UserOrgUictFactory.getLocalInstance((Context)ctx);
            IEditUIUserOrgUict editUIUserOrgUict = EditUIUserOrgUictFactory.getLocalInstance(ctx);
            UserOrgUictCollection uouCollection = userOrgUict.getUserOrgUictCollection();
            if (uouCollection == null || uouCollection.size() < 1) {
                logger.error((Object)"TranslateToCustomScheme : UserOrgUictCollection is null , don't need update");
                return;
            }
            for (int i = 0; i < uouCollection.size(); ++i) {
                UserOrgUictInfo userOrgUictInfo = uouCollection.get(i);
                if (userOrgUictInfo.getConfigure() == null || userOrgUictInfo.getConfigure().getId() == null || map.get(userOrgUictInfo.getConfigure().getId().toString()) == null || !(map.get(userOrgUictInfo.getConfigure().getId().toString()) instanceof PKMapping)) {
                    logger.error((Object)("TranslateToCustomScheme : faild to translate orgUictInfo : " + userOrgUictInfo.getConfigure().getId().toString() + "  can't find edituiconfigureid"));
                    continue;
                }
                if (userOrgUictInfo.getUser() == null) {
                    logger.error((Object)("TranslateToCustomScheme : faild to translate orgUictInfo when getUserInfo : " + userOrgUictInfo.getConfigure().getId().toString() + "  can't find edituiconfigureid"));
                    continue;
                }
                String userID = null;
                String orgID = null;
                String ctrlUnitID = null;
                String editconfID = null;
                String listconfID = null;
                if (userOrgUictInfo.getOrg() != null) {
                    orgID = userOrgUictInfo.getOrg().getId().toString();
                }
                ctrlUnitID = userOrgUictInfo.getCtrlUnit() != null ? userOrgUictInfo.getCtrlUnit().getId().toString() : cu.getId().toString();
                PKMapping pk = (PKMapping)map.get(userOrgUictInfo.getConfigure().getId().toString());
                editconfID = pk.getEditconPK();
                listconfID = pk.getListconPK();
                userID = userOrgUictInfo.getUser().getId().toString();
                editUIUserOrgUict.addnew(userID, editconfID, orgID, ctrlUnitID);
                if (listconfID == null) continue;
                editUIUserOrgUict.addnew(userID, listconfID, orgID, ctrlUnitID);
            }
        }
        catch (Exception e) {
            logger.error((Object)("TranslateToCustomScheme : " + e.getMessage()));
        }
    }

    public static UIObjectInfo loadUIObject(String uiObjectXml) {
        UIObjectInfo uiObj = null;
        if (!StringUtils.isEmpty((String)uiObjectXml)) {
            try {
                uiObj = (UIObjectInfo)new UIObjectCtrl(ContextManager.getContext()).load((InputStream)new ByteArrayInputStream(uiObjectXml.getBytes("UTF-8")));
                uiObj.setAssembled(false);
                uiObj = UIObjectAssembler.assembleUI((Context)ContextManager.getContext(), (UIObjectInfo)uiObj);
            }
            catch (Exception e) {
                logger.error((Object)"failed load uiObject");
            }
        }
        return uiObj;
    }

    private static UIObjectInfo getListConfigUIModel(IBizConfigureInfo configure) {
        if (configure == null) {
            return null;
        }
        UIObjectInfo uiObj = null;
        try {
            String uiObjectXml = configure.getListUIObject();
            uiObj = (UIObjectInfo)new UIObjectCtrl(ContextManager.getContext()).load((InputStream)new ByteArrayInputStream(uiObjectXml.getBytes("UTF-8")));
        }
        catch (Exception e) {
            logger.error((Object)"TranslateToCustomScheme.getListConfigUIModel", (Throwable)e);
        }
        return uiObj;
    }

    public static void translateUIObject(EditUIConfigureInfo editUIConfigureInfo, BizConfigureInfo configureInfo, UIObjectInfo uiModel, Project project, Context ctx, String uitype) throws Exception {
        UIObjectInfo cfgUI;
        String cfgUIXml;
        if (EDITUI.equals(uitype)) {
            cfgUIXml = configureInfo.getUIObject();
        } else if (LISTUI.equals(uitype)) {
            cfgUIXml = configureInfo.getListUIObject();
        } else {
            logger.error((Object)"TranslateToCustomScheme : wrong uitype");
            return;
        }
        UILayoutConfigInfo uiObj = new UILayoutConfigInfo(uiModel.getPackage(), uiModel.getName(), uiModel.getAlias());
        uiObj.setTitle(uiModel.getTitle());
        BizUnitInfo bizUnit = UtilsForUpdate.loadBizUnit((IMetaDataPK)new MetaDataPK(configureInfo.getBizUnitPK()), ctx);
        EntityObjectInfo entity = null;
        if (bizUnit != null && bizUnit.getString("entityPK") != null) {
            entity = UtilsForUpdate.loadEntity((IMetaDataPK)new MetaDataPK(bizUnit.getString("entityPK")), project, ctx);
        }
        if (entity == null) {
            logger.error((Object)(" : failed load entity at configureInfo : " + configureInfo.getName()));
            throw new Exception("TranslateToCustomScheme : failed load entity at configureInfo : " + configureInfo.getName());
        }
        if (!StringUtils.isEmpty((String)cfgUIXml) && (cfgUI = TranslateToCustomScheme.loadUIObject(cfgUIXml)) != null) {
            ComponentCollection col = cfgUI.getComponents();
            for (int i = 0; i < col.size(); ++i) {
                KDRectangle rect;
                ComponentInfo componentInfo = col.get(i);
                UIComponentConfigInfo cfgInfo = new UIComponentConfigInfo();
                cfgInfo.setName(componentInfo.getName());
                if (componentInfo.isConfigured()) {
                    com.kingdee.bos.metadata.entity.PropertyInfo pro = UtilsForUpdate.getBindingProperty(componentInfo, entity);
                    if (pro == null) {
                        logger.error((Object)("TranslateToCustomScheme : " + componentInfo.getName() + "propertyInfo is null don't need update"));
                        continue;
                    }
                    String parent = componentInfo.getExtendedProperty(CONTAINER);
                    if (parent == null) {
                        throw new Exception("TranslateToCustomScheme : failed to get parent container at bizconfigureInfo" + configureInfo.getName() + "compent" + componentInfo.getName());
                    }
                    ComponentInfo parentCompent = UIProxyHelper.findControlByName((UIObjectInfo)uiModel, (String)parent);
                    if (parentCompent == null || componentInfo.getParent() == null || componentInfo.getParent().getName() == null) {
                        throw new Exception("TranslateToCustomScheme : failed to get parent container at bizconfigureInfo" + configureInfo.getName() + "compent" + componentInfo.getName());
                    }
                    String eventObjectName = null;
                    eventObjectName = parentCompent.getParent() != null ? componentInfo.getParent().getName() + "." + componentInfo.getName() : componentInfo.getName();
                    RuleSetInfo ruleSet = new RuleSetInfo();
                    if (!StringUtils.isEmpty((String)editUIConfigureInfo.getBizRuleSet())) {
                        ruleSet = TranslateToCustomScheme.loadRuleSet(editUIConfigureInfo.getBizRuleSet());
                    } else {
                        ruleSet.setPackage(uiModel.getPackage());
                        ruleSet.setName(uiModel.getName() + "RuleSetRT");
                    }
                    if (configureInfo.getBizUnitPK() == null) {
                        throw new Exception("TranslateToCustomScheme : bizunitPK is null at bizconfigureInfo" + configureInfo.getName());
                    }
                    BizUnitInfo bizunitInfo = UtilsForUpdate.loadBizUnit((IMetaDataPK)new MetaDataPK(configureInfo.getBizUnitPK()), ctx);
                    if (bizunitInfo == null) {
                        throw new Exception("TranslateToCustomScheme : failed to load bizunitat bizconfigureInfo" + configureInfo.getName() + "  bizunitPK: " + configureInfo.getBizUnitPK());
                    }
                    BizExpCodeGenerator4Update codeGenerator = new BizExpCodeGenerator4Update(uiModel, bizunitInfo);
                    BizSettingExpression4Update setExp = new BizSettingExpression4Update(eventObjectName, Boolean.TRUE, BizExpressionType4Update.SETUIVISIBLE);
                    ruleSet.getRules().add(0, (AbstractRuleInfo)TranslateToCustomScheme.createRule(eventObjectName, EventType.INITIAL, null, setExp.toString(), codeGenerator.generate(setExp)));
                    try {
                        editUIConfigureInfo.setBizRuleSet(TranslateToCustomScheme.getRuleSetXml(ruleSet));
                    }
                    catch (DataAccessException e) {
                        logger.error((Object)("TranslateToCustomScheme : failed  add rule to set :" + componentInfo.getName() + "visible"));
                        throw e;
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.error((Object)("TranslateToCustomScheme : failed  add rule to set :" + componentInfo.getName() + "visible"));
                        throw e;
                    }
                    TranslateToCustomScheme.addConfigureControl(uiModel, componentInfo);
                }
                if (KDTable.class.getName().equalsIgnoreCase(componentInfo.getClassType())) {
                    String tableName = componentInfo.getName();
                    ComponentInfo tableCompent = UIProxyHelper.findControlByName((UIObjectInfo)uiModel, (String)tableName);
                    if (tableCompent == null) {
                        logger.error((Object)("TranslateToCustomScheme : can't find table :" + tableName));
                        return;
                    }
                    TranslateToCustomScheme.updateTable(tableCompent, componentInfo, configureInfo, uiModel, entity, ctx, uitype, editUIConfigureInfo);
                    if (EDITUI.equals(uitype)) {
                        UIKDTableConfigInfo tableCfgInfo = new UIKDTableConfigInfo();
                        tableCfgInfo.setName(tableCompent.getName());
                        TranslateToCustomScheme.saveTableColumnOrder(cfgUI, componentInfo, tableCfgInfo);
                        uiObj.addKDTableConfig(tableCfgInfo);
                    }
                }
                if (EDITUI.equals(uitype) && (rect = TranslateToCustomScheme.getBounds(componentInfo, uiModel)) != null) {
                    cfgInfo.setConstraint(rect);
                    int value = TranslateToCustomScheme.getLabelLength2(componentInfo);
                    if (value != -404) {
                        cfgInfo.setLabelLength(value);
                    }
                    if ((value = TranslateToCustomScheme.getLabelUnderLine2(componentInfo)) != -404) {
                        cfgInfo.setLabelUnderline(value != 0);
                    }
                    if (componentInfo.getExtendedProperty(CONTAINER) != null) {
                        cfgInfo.setContainer(componentInfo.getExtendedProperty(CONTAINER));
                    }
                }
                uiObj.addMainPanelComponentConfig(cfgInfo);
            }
        }
        try {
            editUIConfigureInfo.setUIObject(uiObj.toJSONObject().toString());
        }
        catch (Exception e) {
            logger.error((Object)"TranslateToCustomScheme : TranslateUIObjec error", (Throwable)e);
            throw e;
        }
    }

    private static void saveTableColumnOrder(UIObjectInfo cfgUI, ComponentInfo table, UIKDTableConfigInfo cfgInfo) {
        if (cfgUI == null || table == null || cfgInfo == null) {
            return;
        }
        if (cfgUI.getExtendedProperty(table.getName() + CONFIGURE_ORDER) != null) {
            String order = cfgUI.getExtendedProperty(table.getName() + CONFIGURE_ORDER).toString();
            cfgInfo.setColumnOrder(order);
            logger.info((Object)(table.getName() + ":" + order.toString()));
        } else {
            PropertyInfo property = table.getProperties().get("formatXml");
            if (property != null) {
                TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)property.getValue());
                List columns = tableInfo.getColumns();
                StringBuffer sb = new StringBuffer();
                logger.info((Object)("------------- save " + table.getName() + " column order ---------------"));
                int size = columns.size();
                for (int i = 0; i < size; ++i) {
                    ColumnInfo columnInfo = (ColumnInfo)columns.get(i);
                    if (i == 0) {
                        sb.append(columnInfo.getName());
                        continue;
                    }
                    sb.append("|" + columnInfo.getName());
                }
                cfgInfo.setColumnOrder(sb.toString());
                logger.info((Object)(table.getName() + ":" + sb.toString()));
            }
        }
    }

    public static void updateTable(ComponentInfo kdtEntrys, ComponentInfo table, BizConfigureInfo configureInfo, UIObjectInfo uiModel, EntityObjectInfo entity, Context ctx, String uitype, EditUIConfigureInfo editUIConfigureInfo) {
        if (kdtEntrys.getProperties() == null || table.getProperties() == null) {
            logger.error((Object)("TranslateToCustomScheme : " + kdtEntrys.getName() + "getProperties  is null"));
            return;
        }
        PropertyBindingCollection epbc = kdtEntrys.getPropertyBindings();
        PropertyBindingCollection tpbc = table.getPropertyBindings();
        if (tpbc == null || tpbc.size() < 1) {
            logger.error((Object)("TranslateToCustomScheme : " + table.getName() + "'s PropertyBindingCollection is null"));
            return;
        }
        PropertyInfo conproperty = table.getProperties().get("formatXml");
        PropertyInfo property = kdtEntrys.getProperties().get("formatXml");
        if (property != null && conproperty != null) {
            TableInfo conTableInfo = KDTableDesignerHelper.getTableInfoFrom((String)conproperty.getValue());
            TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)property.getValue());
            List columns = tableInfo.getColumns();
            List conColumns = conTableInfo.getColumns();
            for (int conCol = 0; conCol < conColumns.size(); ++conCol) {
                com.kingdee.bos.metadata.entity.PropertyInfo prop;
                CellInfo conCellInfo;
                ColumnInfo conColumnInfo = (ColumnInfo)conColumns.get(conCol);
                String conColumnName = conColumnInfo.getName();
                if (conColumnName == null) continue;
                boolean exist = false;
                for (int col = 0; col < columns.size(); ++col) {
                    ColumnInfo columnInfo = (ColumnInfo)columns.get(col);
                    String columnName = columnInfo.getName();
                    if (!conColumnName.equals(columnName)) continue;
                    exist = true;
                }
                if (exist) continue;
                HeaderInfo conHeaderInfo = (HeaderInfo)conTableInfo.getHeaders().get(0);
                HeaderInfo headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
                if (conHeaderInfo.getCellCount() < conCol || (conCellInfo = (CellInfo)conHeaderInfo.getCells().get(conCol)) == null) continue;
                PropertyBindingInfo bindInfo = null;
                String proName = conColumnInfo.getName() + ".text";
                if (tpbc.get(proName) != null && (bindInfo = tpbc.get(proName)) == null) {
                    logger.error((Object)("TranslateToCustomScheme : can't get bind property at column :" + conColumnInfo.getName()));
                    continue;
                }
                if (EDITUI.equals(uitype) && (prop = EditUIProxyHelper.getPropertyByName((EntityObjectInfo)entity, (String)bindInfo.getBingdingField())) == null) {
                    logger.error((Object)("TranslateToCustomScheme : can't get bind property at column :" + conColumnInfo.getName() + "in entity"));
                    continue;
                }
                headerInfo.addCell(conCellInfo);
                boolean isHide = conColumnInfo.isHide();
                conColumnInfo.setHide(true);
                tableInfo.addColumn(conColumnInfo);
                if (epbc == null) {
                    epbc = new PropertyBindingCollection();
                    kdtEntrys.setPropertyBindings(epbc);
                }
                epbc.add(bindInfo);
                if (!kdtEntrys.isConfigured()) {
                    kdtEntrys.setConfigured(true);
                }
                if (LISTUI.equals(uitype) && isHide) continue;
                String eventObjectName = kdtEntrys.getName() + "." + conColumnInfo.getName();
                RuleSetInfo ruleSet = new RuleSetInfo();
                if (!StringUtils.isEmpty((String)editUIConfigureInfo.getBizRuleSet())) {
                    ruleSet = TranslateToCustomScheme.loadRuleSet(editUIConfigureInfo.getBizRuleSet());
                } else {
                    ruleSet.setPackage(uiModel.getPackage());
                    ruleSet.setName(uiModel.getName() + "RuleSetRT");
                }
                if (configureInfo.getBizUnitPK() == null) {
                    return;
                }
                BizUnitInfo bizunitInfo = UtilsForUpdate.loadBizUnit((IMetaDataPK)new MetaDataPK(configureInfo.getBizUnitPK()), ctx);
                if (bizunitInfo == null) {
                    return;
                }
                BizExpCodeGenerator4Update codeGenerator = new BizExpCodeGenerator4Update(uiModel, bizunitInfo);
                BizSettingExpression4Update setExp = new BizSettingExpression4Update(eventObjectName, Boolean.TRUE, BizExpressionType4Update.SETUIVISIBLE);
                ruleSet.getRules().add(0, (AbstractRuleInfo)TranslateToCustomScheme.createRule(eventObjectName, EventType.INITIAL, null, setExp.toString(), codeGenerator.generate(setExp)));
                try {
                    editUIConfigureInfo.setBizRuleSet(TranslateToCustomScheme.getRuleSetXml(ruleSet));
                    continue;
                }
                catch (DataAccessException e) {
                    logger.error((Object)"TranslateToCustomScheme : rule\u8f6c\u6362\u5931\u8d25", (Throwable)e);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    logger.error((Object)"TranslateToCustomScheme : rule\u8f6c\u6362\u5931\u8d25", (Throwable)e);
                }
            }
            property.setValue(KDTableDesignerHelper.getXmlFrom((TableInfo)tableInfo));
        }
    }

    private static boolean addConfigureControl(UIObjectInfo uiModel, ComponentInfo configure) {
        if (uiModel == null || configure == null || configure.getParent() == null) {
            logger.error((Object)"TranslateToCustomScheme : some arguments is null in BizConfigureHelper -> addConfigureControl()");
            return false;
        }
        String containerName = configure.getExtendedProperty(CONTAINER);
        if (StringUtils.isEmpty((String)containerName)) {
            return false;
        }
        if ((configure = TranslateToCustomScheme.getRoundedComponent(configure)) == null) {
            return false;
        }
        ComponentInfo parentCompent = UIProxyHelper.findControlByName((UIObjectInfo)uiModel, (String)containerName);
        if (parentCompent == null) {
            return false;
        }
        Object constraint = configure.getConstraint();
        if (constraint != null && constraint instanceof Rectangle) {
            constraint = TranslateToCustomScheme.createContraint(parentCompent, (Rectangle)constraint);
        }
        configure.setConstraint(constraint);
        PropertyInfo visible = new PropertyInfo();
        visible.setName("visible");
        visible.setValue("false");
        configure.getProperties().add(visible);
        return parentCompent.addChild((AbstractUIObjectInfo)uiModel, configure);
    }

    public static Object createContraint(ComponentInfo parent, Rectangle rect) {
        LayoutInfo layout = parent.getLayoutInfo();
        String layoutType = "XYLayout";
        if (layout != null) {
            layoutType = layout.getType();
        }
        if ("XYLayout".equalsIgnoreCase(layoutType)) {
            return new Rectangle(rect);
        }
        if ("KDLayout".equalsIgnoreCase(layoutType)) {
            return new KDLayoutConstraint(rect);
        }
        return null;
    }

    public static void translateRuleSet(EditUIConfigureInfo editUIConfigureInfo, BizConfigureInfo configureInfo) {
        editUIConfigureInfo.setBizRuleSet(configureInfo.getBizRuleSet());
    }

    public static KDRectangle getBounds(ComponentInfo component, UIObjectInfo uiModel) {
        Object constraint = component.getConstraint();
        if (constraint == null) {
            return null;
        }
        ComponentInfo ocomp = TranslateToCustomScheme.getCompByName(uiModel, component.getName());
        if ((ocomp = TranslateToCustomScheme.getParentComp(ocomp)) != null && ocomp.getConstraint() != null && ocomp.getConstraint() instanceof KDLayoutConstraint) {
            KDLayoutConstraint oConstraint = (KDLayoutConstraint)ocomp.getConstraint();
            if (constraint instanceof Rectangle) {
                return new KDRectangle((Rectangle)constraint, oConstraint.anchor);
            }
            if (constraint instanceof KDLayoutConstraint) {
                return new KDRectangle(((KDLayoutConstraint)constraint).toRectangle(), oConstraint.anchor);
            }
        } else {
            if (constraint instanceof Rectangle) {
                return new KDRectangle((Rectangle)constraint);
            }
            if (constraint instanceof KDLayoutConstraint) {
                return new KDRectangle(((KDLayoutConstraint)constraint).toRectangle(), ((KDLayoutConstraint)constraint).anchor);
            }
        }
        return null;
    }

    public static ComponentInfo getParentComp(ComponentInfo ocomp) {
        if (ocomp != null && ocomp.getParent() != null && "com.kingdee.bos.ctrl.swing.KDLabelContainer".equalsIgnoreCase(ocomp.getParent().getClassType())) {
            return ocomp.getParent();
        }
        return ocomp;
    }

    public static ComponentInfo getCompByName(UIObjectInfo uiModel, String name) {
        if (uiModel == null || name == null || uiModel.getComponents() == null) {
            return null;
        }
        return uiModel.getComponents().getComponentInfo(name);
    }

    public static ComponentInfo getRoundedComponent(ComponentInfo component) {
        ComponentInfo parent = null;
        if (component != null) {
            if ("com.kingdee.bos.ctrl.swing.KDTextArea".equalsIgnoreCase(component.getClassType()) && component.getParent() != null && "com.kingdee.bos.ctrl.swing.KDScrollPane".equalsIgnoreCase(component.getParent().getClassType())) {
                parent = component.getParent();
                parent.setConstraint(component.getConstraint());
                parent.setOverrideConstraint(true);
                parent.setOverrideParent(true);
            }
            if (component.getParent() != null && "com.kingdee.bos.ctrl.swing.KDLabelContainer".equalsIgnoreCase(component.getParent().getClassType())) {
                Object constrant = component.getConstraint();
                parent = component.getParent();
                parent.setConstraint(constrant);
                parent.setOverrideConstraint(true);
                parent.setOverrideParent(true);
            }
        }
        if (parent != null) {
            return parent;
        }
        return component;
    }

    private static UIObjectInfo getUIModel(BizConfigureInfo editData, Project project, Context ctx) {
        UIObjectInfo _model = null;
        if (editData != null) {
            if (!StringUtils.isEmpty((String)editData.getBizUnitPK())) {
                try {
                    String editUIPK;
                    BizUnitInfo bizUnit = UtilsForUpdate.loadBizUnit((IMetaDataPK)new MetaDataPK(editData.getBizUnitPK()), ctx);
                    if (bizUnit != null && !StringUtils.isEmpty((String)(editUIPK = bizUnit.getString("editUIPK")))) {
                        _model = UtilsForUpdate.loadUI((IMetaDataPK)new MetaDataPK(editUIPK), project, ctx);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            } else if (editData.getUIObjectPK() != null) {
                _model = UtilsForUpdate.loadUI((IMetaDataPK)new MetaDataPK(editData.getUIObjectPK()), project, ctx);
            } else {
                logger.error((Object)"TranslateToCustomScheme : failed to load UIObject");
            }
        }
        if (_model != null && !_model.isAssembled()) {
            _model = UIObjectAssembler.assembleUI((Context)ctx, _model);
        }
        return _model;
    }

    private static UIObjectInfo getListUIModel(BizConfigureInfo editData, Project project, Context ctx) {
        UIObjectInfo _model = null;
        if (editData != null) {
            if (!StringUtils.isEmpty((String)editData.getBizUnitPK())) {
                try {
                    String listUIPK;
                    BizUnitInfo bizUnit = UtilsForUpdate.loadBizUnit((IMetaDataPK)new MetaDataPK(editData.getBizUnitPK()), ctx);
                    if (bizUnit != null && !StringUtils.isEmpty((String)(listUIPK = bizUnit.getString("listUIPK")))) {
                        _model = UtilsForUpdate.loadUI((IMetaDataPK)new MetaDataPK(listUIPK), project, ctx);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            } else if (editData.getListUIObjectPK() != null) {
                _model = UtilsForUpdate.loadUI((IMetaDataPK)new MetaDataPK(editData.getListUIObjectPK()), project, ctx);
            } else {
                logger.error((Object)"TranslateToCustomScheme : failed to load UIObject");
            }
        }
        if (_model != null && !_model.isAssembled()) {
            _model = UIObjectAssembler.assembleUI((Context)ctx, _model);
        }
        return _model;
    }

    public static UIObjectInfo loadUIObject(MetaDataPK pk) {
        UIObjectInfo uiObj = null;
        if (pk != null) {
            try {
                uiObj = new UIObjectCtrl(ContextManager.getContext()).getValueNotCache((IMetaDataPK)pk);
                if (!uiObj.isAssembled()) {
                    uiObj = UIObjectAssembler.assembleUI((Context)ContextManager.getContext(), (UIObjectInfo)uiObj);
                }
            }
            catch (Exception e) {
                logger.error((Object)"TranslateToCustomScheme : failed to load UIObject");
                logger.error((Object)e.getStackTrace());
            }
        }
        return uiObj;
    }

    public static int getLabelLength2(ComponentInfo component) {
        if (component != null) {
            String length = component.getExtendedProperty("boundLabelLength");
            try {
                if (!StringUtils.isEmpty((String)length)) {
                    return Integer.parseInt(length);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -404;
    }

    public static int getLabelUnderLine2(ComponentInfo component) {
        if (component != null) {
            String underline = component.getExtendedProperty("boundLabelUnderline");
            try {
                if (!StringUtils.isEmpty((String)underline)) {
                    if ("false".equalsIgnoreCase(underline)) {
                        return 0;
                    }
                    return 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -404;
    }

    public static RuleSetInfo loadRuleSet(String ruleSetXml) {
        RuleSetInfo ruleSet = null;
        if (!StringUtils.isEmpty((String)ruleSetXml)) {
            try {
                ruleSet = (RuleSetInfo)new RuleSetCtrl(ContextManager.getContext()).load((InputStream)new ByteArrayInputStream(ruleSetXml.getBytes("UTF-8")));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return ruleSet;
    }

    private static ConditionRuleInfo createRule(String eventObjectName, EventType eventType, String eventName, String source, String javaScript) {
        ConditionRuleInfo rule = new ConditionRuleInfo();
        rule.setEventObjectName(eventObjectName);
        rule.setEventType(eventType);
        rule.setEventName(eventName);
        ActionInfo action = new ActionInfo();
        SimpleExpressionInfo exp = new SimpleExpressionInfo();
        exp.setType(ExpressionType.SCRIPT);
        exp.put("source", (Object)source);
        exp.setValue(javaScript);
        action.setExpression((AbstractExpressionInfo)exp);
        rule.getActions().add(action);
        return rule;
    }

    public static String getRuleSetXml(RuleSetInfo ruleSet) throws DataAccessException, UnsupportedEncodingException {
        if (ruleSet == null) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
        new RuleSetCtrl(ContextManager.getContext()).store((IObjectValue)ruleSet, (OutputStream)out);
        return new String(out.toByteArray(), "UTF-8");
    }
}

