/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer.commands;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.eas.ep.client.editor.editui.designer.AbstractEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;
import com.kingdee.eas.ep.client.editor.editui.designer.request.ChangeContainerRequest;
import com.kingdee.eas.ep.client.model.ComponentTreeNode;
import com.kingdee.eas.ep.webclient.editor.webui.designer.ContainerEditPart;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebItemInfoAdapter;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.ConstraintUtil;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.ModelUtils;
import com.kingdee.eas.ep.webclient.model.WebItemCollection;
import com.kingdee.eas.ep.webclient.model.WebItemInfo;
import com.kingdee.eas.ep.webclient.model.WebTreeNode;
import java.awt.Point;
import javax.swing.tree.MutableTreeNode;

public class ChangeContainerCommand
extends Command {
    private AbstractEditPartViewer sourceViwer;
    private AbstractEditPartViewer targetViewer;
    private ComponentTreeNode sourceNode;
    private ComponentTreeNode targetNode;
    private ComponentTreeNode containerNode;
    private WebItemCollection sourceList;
    private WebItemCollection targetList;
    private EditPart source;
    private Object oldConstraint;
    private Object newConstraint;
    private int sourceIndex;
    private boolean canExecute = true;
    private Point suggestPlace;

    public ChangeContainerCommand(ChangeContainerRequest request) {
        this.sourceViwer = request.getSourceViwer();
        this.targetViewer = request.getTargetViewer();
        this.suggestPlace = request.getSuggestPlace();
        if (this.sourceViwer == null || this.targetViewer == null) {
            this.canExecute = false;
            return;
        }
        this.sourceNode = this.sourceViwer.getNode();
        this.targetNode = this.targetViewer.getNode();
        Object obj = this.targetNode.getUserObject();
        if (!(obj instanceof ComponentInfo)) {
            this.canExecute = false;
            return;
        }
        this.sourceList = (WebItemCollection)this.sourceNode.getConfigureItems();
        this.targetList = (WebItemCollection)this.targetNode.getConfigureItems();
        this.source = request.getSourceEditPart();
        this.oldConstraint = ((WebItemInfoAdapter)((Object)this.source.getModel())).getConstranit();
        this.sourceIndex = this.sourceList.indexOf(((WebItemInfoAdapter)((Object)this.source.getModel())).getItem());
        if (this.source instanceof ContainerEditPart) {
            String nodeName = ((WebItemInfoAdapter)((Object)this.source.getModel())).getName();
            int count = this.sourceNode.getChildCount();
            for (int i = 0; i < count; ++i) {
                WebTreeNode child = (WebTreeNode)((Object)this.sourceNode.getChildAt(i));
                if (nodeName == null || !nodeName.equals(child.getName())) continue;
                this.containerNode = child;
                break;
            }
        }
        this.newConstraint = this.suggestPlace != null && this.suggestPlace.x > 0 && this.suggestPlace.y > 0 && this.suggestPlace.x < this.targetViewer.getBounds().width && this.suggestPlace.y < this.targetViewer.getBounds().height ? ConstraintUtil.createConstraint((ComponentInfo)obj, this.oldConstraint, this.suggestPlace) : ConstraintUtil.createConstraint((ComponentInfo)obj, this.oldConstraint);
    }

    public boolean canExecute() {
        if (this.canExecute) {
            ComponentInfo tInfo = (ComponentInfo)this.targetNode.getUserObject();
            ComponentInfo sInfo = ((WebItemInfoAdapter)((Object)this.source.getModel())).getItem().getComponent();
            if ("com.kingdee.bos.ctrl.web.ToolBar".equals(tInfo.getClassType())) {
                return ModelUtils.allowToolBarComponent(sInfo.getClassType());
            }
            return true;
        }
        return false;
    }

    public void execute() {
        WebItemInfo item = (WebItemInfo)((WebItemInfoAdapter)((Object)this.source.getModel())).getItem();
        item.setConstraint(this.newConstraint);
        this.sourceList.removeObject(this.sourceIndex);
        this.targetList.add(item);
        if (this.containerNode != null) {
            this.sourceNode.remove((MutableTreeNode)this.containerNode);
            this.targetNode.add((MutableTreeNode)this.containerNode);
        }
        this.sourceViwer.createEditPart();
        this.targetViewer.createEditPart();
    }

    public void undo() {
        WebItemInfo item = (WebItemInfo)((WebItemInfoAdapter)((Object)this.source.getModel())).getItem();
        item.setConstraint(this.oldConstraint);
        this.targetList.remove(item);
        this.sourceList.addObject(this.sourceIndex, (IObjectValue)item);
        if (this.containerNode != null) {
            this.targetNode.remove((MutableTreeNode)this.containerNode);
            this.sourceNode.add((MutableTreeNode)this.containerNode);
        }
        this.sourceViwer.createEditPart();
        this.targetViewer.createEditPart();
    }
}

