/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import org.apache.lucene.ep.index.DocFieldConsumerPerField;
import org.apache.lucene.ep.index.DocFieldConsumerPerThread;
import org.apache.lucene.ep.index.DocFieldConsumers;
import org.apache.lucene.ep.index.DocFieldConsumersPerField;
import org.apache.lucene.ep.index.DocFieldProcessorPerThread;
import org.apache.lucene.ep.index.DocumentsWriter;
import org.apache.lucene.ep.index.FieldInfo;

final class DocFieldConsumersPerThread
extends DocFieldConsumerPerThread {
    final DocFieldConsumerPerThread one;
    final DocFieldConsumerPerThread two;
    final DocFieldConsumers parent;
    final DocumentsWriter.DocState docState;

    public DocFieldConsumersPerThread(DocFieldProcessorPerThread docFieldProcessorPerThread, DocFieldConsumers parent, DocFieldConsumerPerThread one, DocFieldConsumerPerThread two) {
        this.parent = parent;
        this.one = one;
        this.two = two;
        this.docState = docFieldProcessorPerThread.docState;
    }

    @Override
    public void startDocument() throws IOException {
        this.one.startDocument();
        this.two.startDocument();
    }

    @Override
    public void abort() {
        try {
            this.one.abort();
        }
        finally {
            this.two.abort();
        }
    }

    @Override
    public DocumentsWriter.DocWriter finishDocument() throws IOException {
        DocumentsWriter.DocWriter oneDoc = this.one.finishDocument();
        DocumentsWriter.DocWriter twoDoc = this.two.finishDocument();
        if (oneDoc == null) {
            return twoDoc;
        }
        if (twoDoc == null) {
            return oneDoc;
        }
        DocFieldConsumers.PerDoc both = this.parent.getPerDoc();
        both.docID = this.docState.docID;
        assert (oneDoc.docID == this.docState.docID);
        assert (twoDoc.docID == this.docState.docID);
        both.one = oneDoc;
        both.two = twoDoc;
        return both;
    }

    @Override
    public DocFieldConsumerPerField addField(FieldInfo fi) {
        return new DocFieldConsumersPerField(this, this.one.addField(fi), this.two.addField(fi));
    }
}

