/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.lucene.ep.index.DocConsumer;
import org.apache.lucene.ep.index.DocConsumerPerThread;
import org.apache.lucene.ep.index.DocFieldConsumer;
import org.apache.lucene.ep.index.DocFieldConsumerPerThread;
import org.apache.lucene.ep.index.DocFieldProcessorPerThread;
import org.apache.lucene.ep.index.DocumentsWriter;
import org.apache.lucene.ep.index.DocumentsWriterThreadState;
import org.apache.lucene.ep.index.FieldInfos;
import org.apache.lucene.ep.index.SegmentWriteState;
import org.apache.lucene.ep.index.StoredFieldsWriter;

final class DocFieldProcessor
extends DocConsumer {
    final DocumentsWriter docWriter;
    final FieldInfos fieldInfos = new FieldInfos();
    final DocFieldConsumer consumer;
    final StoredFieldsWriter fieldsWriter;

    public DocFieldProcessor(DocumentsWriter docWriter, DocFieldConsumer consumer) {
        this.docWriter = docWriter;
        this.consumer = consumer;
        consumer.setFieldInfos(this.fieldInfos);
        this.fieldsWriter = new StoredFieldsWriter(docWriter, this.fieldInfos);
    }

    @Override
    public void closeDocStore(SegmentWriteState state) throws IOException {
        this.consumer.closeDocStore(state);
        this.fieldsWriter.closeDocStore(state);
    }

    @Override
    public void flush(Collection threads, SegmentWriteState state) throws IOException {
        HashMap<DocFieldConsumerPerThread, Collection> childThreadsAndFields = new HashMap<DocFieldConsumerPerThread, Collection>();
        for (DocFieldProcessorPerThread perThread : threads) {
            childThreadsAndFields.put(perThread.consumer, perThread.fields());
            perThread.trimFields(state);
        }
        this.fieldsWriter.flush(state);
        this.consumer.flush(childThreadsAndFields, state);
        String fileName = state.segmentFileName("fnm");
        this.fieldInfos.write(state.directory, fileName);
        state.flushedFiles.add(fileName);
    }

    @Override
    public void abort() {
        this.fieldsWriter.abort();
        this.consumer.abort();
    }

    @Override
    public boolean freeRAM() {
        return this.consumer.freeRAM();
    }

    @Override
    public DocConsumerPerThread addThread(DocumentsWriterThreadState threadState) throws IOException {
        return new DocFieldProcessorPerThread(threadState, this);
    }
}

