/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.ep.index.CorruptIndexException;
import org.apache.lucene.ep.index.IndexWriter;
import org.apache.lucene.ep.index.SegmentInfo;
import org.apache.lucene.ep.index.SegmentInfos;
import org.apache.lucene.ep.index.SegmentReader;
import org.apache.lucene.ep.store.Directory;

public abstract class MergePolicy {
    protected final IndexWriter writer;

    public MergePolicy(IndexWriter writer) {
        this.writer = writer;
    }

    public abstract MergeSpecification findMerges(SegmentInfos var1) throws CorruptIndexException, IOException;

    public abstract MergeSpecification findMergesForOptimize(SegmentInfos var1, int var2, Set var3) throws CorruptIndexException, IOException;

    public abstract MergeSpecification findMergesToExpungeDeletes(SegmentInfos var1) throws CorruptIndexException, IOException;

    public abstract void close();

    public abstract boolean useCompoundFile(SegmentInfos var1, SegmentInfo var2);

    public abstract boolean useCompoundDocStore(SegmentInfos var1);

    public static class MergeAbortedException
    extends IOException {
        public MergeAbortedException() {
            super("merge is aborted");
        }

        public MergeAbortedException(String message) {
            super(message);
        }
    }

    public static class MergeException
    extends RuntimeException {
        private Directory dir;

        public MergeException(String message) {
            super(message);
        }

        public MergeException(String message, Directory dir) {
            super(message);
            this.dir = dir;
        }

        public MergeException(Throwable exc) {
            super(exc);
        }

        public MergeException(Throwable exc, Directory dir) {
            super(exc);
            this.dir = dir;
        }

        public Directory getDirectory() {
            return this.dir;
        }
    }

    public static class MergeSpecification {
        public List merges = new ArrayList();

        public void add(OneMerge merge) {
            this.merges.add(merge);
        }

        public String segString(Directory dir) {
            StringBuffer b = new StringBuffer();
            b.append("MergeSpec:\n");
            int count = this.merges.size();
            for (int i = 0; i < count; ++i) {
                b.append("  ").append(1 + i).append(": ").append(((OneMerge)this.merges.get(i)).segString(dir));
            }
            return b.toString();
        }
    }

    public static class OneMerge {
        SegmentInfo info;
        boolean mergeDocStores;
        boolean optimize;
        boolean increfDone;
        boolean registerDone;
        long mergeGen;
        boolean isExternal;
        int maxNumSegmentsOptimize;
        SegmentReader[] readers;
        SegmentReader[] readersClone;
        List mergeFiles;
        final SegmentInfos segments;
        final boolean useCompoundFile;
        boolean aborted;
        Throwable error;

        public OneMerge(SegmentInfos segments, boolean useCompoundFile) {
            if (0 == segments.size()) {
                throw new RuntimeException("segments must include at least one segment");
            }
            this.segments = segments;
            this.useCompoundFile = useCompoundFile;
        }

        synchronized void setException(Throwable error) {
            this.error = error;
        }

        synchronized Throwable getException() {
            return this.error;
        }

        synchronized void abort() {
            this.aborted = true;
        }

        synchronized boolean isAborted() {
            return this.aborted;
        }

        synchronized void checkAborted(Directory dir) throws MergeAbortedException {
            if (this.aborted) {
                throw new MergeAbortedException("merge is aborted: " + this.segString(dir));
            }
        }

        String segString(Directory dir) {
            StringBuffer b = new StringBuffer();
            int numSegments = this.segments.size();
            for (int i = 0; i < numSegments; ++i) {
                if (i > 0) {
                    b.append(' ');
                }
                b.append(this.segments.info(i).segString(dir));
            }
            if (this.info != null) {
                b.append(" into ").append(this.info.name);
            }
            if (this.optimize) {
                b.append(" [optimize]");
            }
            if (this.mergeDocStores) {
                b.append(" [mergeDocStores]");
            }
            return b.toString();
        }
    }
}

