/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.ep.document.Document;
import org.apache.lucene.ep.document.FieldSelector;
import org.apache.lucene.ep.index.CorruptIndexException;
import org.apache.lucene.ep.index.DirectoryReader;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.index.SegmentReader;
import org.apache.lucene.ep.index.Term;
import org.apache.lucene.ep.index.TermDocs;
import org.apache.lucene.ep.index.TermEnum;
import org.apache.lucene.ep.index.TermFreqVector;
import org.apache.lucene.ep.index.TermPositions;
import org.apache.lucene.ep.index.TermVectorMapper;
import org.apache.lucene.ep.search.DefaultSimilarity;
import org.apache.lucene.ep.search.FieldCache;

public class MultiReader
extends IndexReader
implements Cloneable {
    protected IndexReader[] subReaders;
    private int[] starts;
    private boolean[] decrefOnClose;
    private Map normsCache = new HashMap();
    private int maxDoc = 0;
    private int numDocs = -1;
    private boolean hasDeletions = false;
    private byte[] ones;

    public MultiReader(IndexReader[] subReaders) {
        this.initialize(subReaders, true);
    }

    public MultiReader(IndexReader[] subReaders, boolean closeSubReaders) {
        this.initialize(subReaders, closeSubReaders);
    }

    private void initialize(IndexReader[] subReaders, boolean closeSubReaders) {
        this.subReaders = (IndexReader[])subReaders.clone();
        this.starts = new int[subReaders.length + 1];
        this.decrefOnClose = new boolean[subReaders.length];
        for (int i = 0; i < subReaders.length; ++i) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += subReaders[i].maxDoc();
            if (!closeSubReaders) {
                subReaders[i].incRef();
                this.decrefOnClose[i] = true;
            } else {
                this.decrefOnClose[i] = false;
            }
            if (!subReaders[i].hasDeletions()) continue;
            this.hasDeletions = true;
        }
        this.starts[subReaders.length] = this.maxDoc;
    }

    @Override
    public synchronized IndexReader reopen() throws CorruptIndexException, IOException {
        return this.doReopen(false);
    }

    @Override
    public synchronized Object clone() {
        try {
            return this.doReopen(true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexReader doReopen(boolean doClone) throws CorruptIndexException, IOException {
        int i;
        this.ensureOpen();
        boolean reopened = false;
        IndexReader[] newSubReaders = new IndexReader[this.subReaders.length];
        boolean success = false;
        try {
            for (i = 0; i < this.subReaders.length; ++i) {
                newSubReaders[i] = doClone ? (IndexReader)this.subReaders[i].clone() : this.subReaders[i].reopen();
                if (newSubReaders[i] == this.subReaders[i]) continue;
                reopened = true;
            }
            success = true;
        }
        finally {
            if (!success && reopened) {
                for (i = 0; i < newSubReaders.length; ++i) {
                    if (newSubReaders[i] == this.subReaders[i]) continue;
                    try {
                        newSubReaders[i].close();
                        continue;
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (reopened) {
            boolean[] newDecrefOnClose = new boolean[this.subReaders.length];
            for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
                if (newSubReaders[i2] != this.subReaders[i2]) continue;
                newSubReaders[i2].incRef();
                newDecrefOnClose[i2] = true;
            }
            MultiReader mr = new MultiReader(newSubReaders);
            mr.decrefOnClose = newDecrefOnClose;
            mr.setDisableFakeNorms(this.getDisableFakeNorms());
            return mr;
        }
        return this;
    }

    @Override
    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVectors(n - this.starts[i]);
    }

    @Override
    public TermFreqVector getTermFreqVector(int n, String field) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVector(n - this.starts[i], field);
    }

    @Override
    public void getTermFreqVector(int docNumber, String field, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(docNumber);
        this.subReaders[i].getTermFreqVector(docNumber - this.starts[i], field, mapper);
    }

    @Override
    public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(docNumber);
        this.subReaders[i].getTermFreqVector(docNumber - this.starts[i], mapper);
    }

    @Override
    public boolean isOptimized() {
        return false;
    }

    @Override
    public int numDocs() {
        if (this.numDocs == -1) {
            int n = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                n += this.subReaders[i].numDocs();
            }
            this.numDocs = n;
        }
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.maxDoc;
    }

    @Override
    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].document(n - this.starts[i], fieldSelector);
    }

    @Override
    public boolean isDeleted(int n) {
        int i = this.readerIndex(n);
        return this.subReaders[i].isDeleted(n - this.starts[i]);
    }

    @Override
    public boolean hasDeletions() {
        return this.hasDeletions;
    }

    @Override
    protected void doDelete(int n) throws CorruptIndexException, IOException {
        this.numDocs = -1;
        int i = this.readerIndex(n);
        this.subReaders[i].deleteDocument(n - this.starts[i]);
        this.hasDeletions = true;
    }

    @Override
    protected void doUndeleteAll() throws CorruptIndexException, IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].undeleteAll();
        }
        this.hasDeletions = false;
        this.numDocs = -1;
    }

    private int readerIndex(int n) {
        return DirectoryReader.readerIndex(n, this.starts, this.subReaders.length);
    }

    @Override
    public boolean hasNorms(String field) throws IOException {
        this.ensureOpen();
        for (int i = 0; i < this.subReaders.length; ++i) {
            if (!this.subReaders[i].hasNorms(field)) continue;
            return true;
        }
        return false;
    }

    private byte[] fakeNorms() {
        if (this.ones == null) {
            this.ones = SegmentReader.createFakeNorms(this.maxDoc());
        }
        return this.ones;
    }

    @Override
    public synchronized byte[] norms(String field) throws IOException {
        this.ensureOpen();
        byte[] bytes = (byte[])this.normsCache.get(field);
        if (bytes != null) {
            return bytes;
        }
        if (!this.hasNorms(field)) {
            return this.getDisableFakeNorms() ? null : this.fakeNorms();
        }
        bytes = new byte[this.maxDoc()];
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field, bytes, this.starts[i]);
        }
        this.normsCache.put(field, bytes);
        return bytes;
    }

    @Override
    public synchronized void norms(String field, byte[] result, int offset) throws IOException {
        int i;
        this.ensureOpen();
        byte[] bytes = (byte[])this.normsCache.get(field);
        for (i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field, result, offset + this.starts[i]);
        }
        if (bytes == null && !this.hasNorms(field)) {
            Arrays.fill(result, offset, result.length, DefaultSimilarity.encodeNorm(1.0f));
        } else if (bytes != null) {
            System.arraycopy(bytes, 0, result, offset, this.maxDoc());
        } else {
            for (i = 0; i < this.subReaders.length; ++i) {
                this.subReaders[i].norms(field, result, offset + this.starts[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSetNorm(int n, String field, byte value) throws CorruptIndexException, IOException {
        Map map = this.normsCache;
        synchronized (map) {
            this.normsCache.remove(field);
        }
        int i = this.readerIndex(n);
        this.subReaders[i].setNorm(n - this.starts[i], field, value);
    }

    @Override
    public TermEnum terms() throws IOException {
        this.ensureOpen();
        return new DirectoryReader.MultiTermEnum(this, this.subReaders, this.starts, null);
    }

    @Override
    public TermEnum terms(Term term) throws IOException {
        this.ensureOpen();
        return new DirectoryReader.MultiTermEnum(this, this.subReaders, this.starts, term);
    }

    @Override
    public int docFreq(Term t) throws IOException {
        this.ensureOpen();
        int total = 0;
        for (int i = 0; i < this.subReaders.length; ++i) {
            total += this.subReaders[i].docFreq(t);
        }
        return total;
    }

    @Override
    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return new DirectoryReader.MultiTermDocs(this, this.subReaders, this.starts);
    }

    @Override
    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return new DirectoryReader.MultiTermPositions(this, this.subReaders, this.starts);
    }

    @Override
    protected void doCommit() throws IOException {
        this.doCommit(null);
    }

    @Override
    protected void doCommit(Map commitUserData) throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].commit(commitUserData);
        }
    }

    @Override
    protected synchronized void doClose() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            if (this.decrefOnClose[i]) {
                this.subReaders[i].decRef();
                continue;
            }
            this.subReaders[i].close();
        }
        FieldCache.DEFAULT.purge(this);
    }

    @Override
    public Collection getFieldNames(IndexReader.FieldOption fieldNames) {
        this.ensureOpen();
        return DirectoryReader.getFieldNames(fieldNames, this.subReaders);
    }

    @Override
    public boolean isCurrent() throws CorruptIndexException, IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            if (this.subReaders[i].isCurrent()) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getVersion() {
        throw new UnsupportedOperationException("MultiReader does not support this method.");
    }

    @Override
    public IndexReader[] getSequentialSubReaders() {
        return this.subReaders;
    }
}

