/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import org.apache.lucene.ep.index.DocInverterPerField;
import org.apache.lucene.ep.index.DocumentsWriter;
import org.apache.lucene.ep.index.FieldInfo;
import org.apache.lucene.ep.index.FieldInvertState;
import org.apache.lucene.ep.index.InvertedDocEndConsumerPerField;
import org.apache.lucene.ep.index.NormsWriterPerThread;
import org.apache.lucene.ep.search.Similarity;
import org.apache.lucene.ep.util.ArrayUtil;

final class NormsWriterPerField
extends InvertedDocEndConsumerPerField
implements Comparable {
    final NormsWriterPerThread perThread;
    final FieldInfo fieldInfo;
    final DocumentsWriter.DocState docState;
    int[] docIDs = new int[1];
    byte[] norms = new byte[1];
    int upto;
    final FieldInvertState fieldState;

    public void reset() {
        this.docIDs = ArrayUtil.shrink(this.docIDs, this.upto);
        this.norms = ArrayUtil.shrink(this.norms, this.upto);
        this.upto = 0;
    }

    public NormsWriterPerField(DocInverterPerField docInverterPerField, NormsWriterPerThread perThread, FieldInfo fieldInfo) {
        this.perThread = perThread;
        this.fieldInfo = fieldInfo;
        this.docState = perThread.docState;
        this.fieldState = docInverterPerField.fieldState;
    }

    @Override
    void abort() {
        this.upto = 0;
    }

    public int compareTo(Object other) {
        return this.fieldInfo.name.compareTo(((NormsWriterPerField)other).fieldInfo.name);
    }

    @Override
    void finish() {
        assert (this.docIDs.length == this.norms.length);
        if (this.fieldInfo.isIndexed && !this.fieldInfo.omitNorms) {
            if (this.docIDs.length <= this.upto) {
                assert (this.docIDs.length == this.upto);
                this.docIDs = ArrayUtil.grow(this.docIDs, 1 + this.upto);
                this.norms = ArrayUtil.grow(this.norms, 1 + this.upto);
            }
            float norm = this.docState.similarity.computeNorm(this.fieldInfo.name, this.fieldState);
            this.norms[this.upto] = Similarity.encodeNorm(norm);
            this.docIDs[this.upto] = this.docState.docID;
            ++this.upto;
        }
    }
}

